'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');
const Node = require('./Node.cjs');

class ChildNode extends Node.Node {
  remove() {
    const parent = this.parentNode;
    if (!parent) return;
    parent.removeChild(this);
  }
  replaceWith(...nodes) {
    const parent = this.parentNode;
    if (!parent) return;
    const node = toNode(parent, nodes[0]);
    const next = node[constants.NEXT];
    parent.replaceChild(this, node);
    for (let i = 1; i < nodes.length; i++) {
      parent.insertBefore(toNode(parent, nodes[i]), next);
    }
  }
  before(...nodes) {
    const parent = this.parentNode;
    if (!parent) return;
    for (const node of nodes) {
      parent.insertBefore(toNode(parent, node), this);
    }
  }
  after(...nodes) {
    const parent = this.parentNode;
    if (!parent) return;
    const next = this[constants.NEXT];
    for (const node of nodes) {
      parent.insertBefore(toNode(parent, node), next);
    }
  }
}
function toNode(parent, node) {
  if (node instanceof Node.Node) return node;
  const ownerDocument = parent.ownerDocument;
  return ownerDocument.createTextNode(String(node));
}

exports.ChildNode = ChildNode;
exports.toNode = toNode;
