import { type CustomMatchers } from '@quilted/react-testing/matchers';
declare module 'vitest' {
    interface Assertion<T = any> extends CustomMatchers<T> {
    }
    interface AsymmetricMatchersContaining extends CustomMatchers {
    }
}
interface ButtonProps {
    tooltip?: string;
    disabled?: boolean;
    onPress?(): void;
    onClick?(): void;
}
declare const RemoteButtonElement: import("@remote-dom/core/elements").RemoteElementConstructor<ButtonProps, {}, {}, {
    press(): void;
}>;
declare const RemoteModalElement: import("@remote-dom/core/elements").RemoteElementConstructor<{}, {
    open(): void;
    close(): void;
}, {
    action?: true;
}, {}>;
declare const RemoteInputElement: import("@remote-dom/core/elements").RemoteElementConstructor<{}, {}, {}, {
    change(detail: string): void;
}>;
declare global {
    interface HTMLElementTagNameMap {
        'remote-button': InstanceType<typeof RemoteButtonElement>;
        'remote-modal': InstanceType<typeof RemoteModalElement>;
        'remote-input': InstanceType<typeof RemoteInputElement>;
    }
}
export {};
//# sourceMappingURL=e2e.test.d.ts.map