'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

class CustomElementRegistryImplementation {
  registry = (() => new Map())();
  listenersByName = (() => new Map())();
  define(name, Constructor, _options) {
    this.registry.set(name, Constructor);
    const listeners = this.listenersByName.get(name);
    if (listeners == null) return;
    this.listenersByName.delete(name);
    for (const listener of listeners) {
      listener(Constructor);
    }
  }
  get(name) {
    return this.registry.get(name);
  }
  getName(Constructor) {
    for (const [name, value] of this.registry) {
      if (value === Constructor) return name;
    }
    return null;
  }
  whenDefined(name) {
    const Constructor = this.registry.get(name);
    if (Constructor != null) return Promise.resolve(Constructor);
    let listeners = this.listenersByName.get(name);
    if (listeners == null) {
      listeners = [];
      this.listenersByName.set(name, listeners);
    }
    return new Promise(resolve => {
      listeners.push(resolve);
    });
  }
  upgrade(_root) {
    // TODO
  }
}

exports.CustomElementRegistryImplementation = CustomElementRegistryImplementation;
