'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');
const Element = require('./Element.cjs');
const serialization = require('./serialization.cjs');

class HTMLTemplateElement extends Element.Element {
  get content() {
    let content = this[constants.CONTENT];
    if (!content) {
      content = this.ownerDocument.createDocumentFragment();
      this[constants.CONTENT] = content;
    }
    return content;
  }
  set content(_) {}
  set innerHTML(html) {
    this.content.replaceChildren(serialization.parseHtml(String(html), this));
  }
  get innerHTML() {
    const content = this[constants.CONTENT];
    return content ? serialization.serializeChildren(content) : '';
  }
}

exports.HTMLTemplateElement = HTMLTemplateElement;
