module type S = sig
  exception Exit

  type fpclass =
  
    Stdlib.fpclass =
  
  (*
    Pervasives.fpclass =
  *)
    | FP_normal 
    | FP_subnormal 
    | FP_zero 
    | FP_infinite 
    | FP_nan 

  type in_channel = Stdcompat__init.in_channel

  type out_channel = Stdcompat__init.out_channel

  type open_flag =
  
    Stdlib.open_flag =
  
  (*
    Pervasives.open_flag =
  *)
    | Open_rdonly 
    | Open_wronly 
    | Open_append 
    | Open_creat 
    | Open_trunc 
    | Open_excl 
    | Open_binary 
    | Open_text
    | Open_nonblock 

  
  module LargeFile =
  
    Stdlib.LargeFile
  
  (*
    Pervasives.LargeFile
  *)
  
  (*
  module LargeFile : sig
      val seek_out : out_channel -> int64 -> unit
      val pos_out : out_channel -> int64
      val out_channel_length : out_channel -> int64
      val seek_in : in_channel -> int64 -> unit
      val pos_in : in_channel -> int64
      val in_channel_length : in_channel -> int64
  end
  *)
  
  type 'a ref =
  
    'a Stdlib.ref =
  
  (*
    'a Pervasives.ref =
  *)
    { mutable contents: 'a }
  
  type ('a, 'b) result =
    ('a, 'b) Stdcompat__init.result =
    | Ok of 'a 
    | Error of 'b
  
  type ('a, 'b, 'c, 'd, 'e, 'f) format6 =
    ('a, 'b, 'c, 'd, 'e, 'f) Stdcompat__init.format6
  
  type ('a, 'b, 'c, 'd) format4 = ('a, 'b, 'c, 'c, 'c, 'd) format6
  
  type ('a, 'b, 'c) format = ('a, 'b, 'c, 'c) format4

  val stdin : in_channel
  
  val stdout : out_channel
  
  val stderr : out_channel
  
  val open_out : string -> out_channel
  
  val open_out_bin : string -> out_channel
  
  val open_out_gen : open_flag list -> int -> string -> out_channel
  
  val flush : out_channel -> unit
  
  val output_char : out_channel -> char -> unit
  
  val output_string : out_channel -> string -> unit
  
  val output_bytes : out_channel -> Stdcompat__init.bytes -> unit
  
  val output : out_channel -> Stdcompat__init.bytes -> int -> int -> unit
  
  val output_substring : out_channel -> string -> int -> int -> unit
  
  val output_byte : out_channel -> int -> unit
  
  val output_binary_int : out_channel -> int -> unit
  
  val output_value : out_channel -> 'a -> unit
  
  val seek_out : out_channel -> int -> unit
  
  val pos_out : out_channel -> int
  
  val out_channel_length : out_channel -> int
  
  val close_out : out_channel -> unit
  
  val close_out_noerr : out_channel -> unit
  
  val set_binary_mode_out : out_channel -> bool -> unit
  
  val open_in : string -> in_channel
  
  val open_in_bin : string -> in_channel
  
  val open_in_gen : open_flag list -> int -> string -> in_channel
  
  val input_char : in_channel -> char
  
  val input_line : in_channel -> string
  
  val input : in_channel -> Stdcompat__init.bytes -> int -> int -> int
  
  val really_input : in_channel -> Stdcompat__init.bytes -> int -> int -> unit
  
  val really_input_string : in_channel -> int -> string
  
  val input_byte : in_channel -> int
  
  val input_binary_int : in_channel -> int
  
  val input_value : in_channel -> 'a
  
  val seek_in : in_channel -> int -> unit
  
  val pos_in : in_channel -> int
  
  val in_channel_length : in_channel -> int
  
  val close_in : in_channel -> unit
  
  val close_in_noerr : in_channel -> unit
  
  val set_binary_mode_in : in_channel -> bool -> unit
  
  val string_of_format : ('a, 'b, 'c, 'd, 'e, 'f) format6 -> string
  
  val (^^) :
    ('a, 'b, 'c, 'd, 'e, 'f) format6 ->
      ('f, 'b, 'c, 'e, 'g, 'h) format6 ->
        ('a, 'b, 'c, 'd, 'g, 'h) format6
  
  val bool_of_string_opt : string -> bool option
  
  val int_of_string_opt : string -> int option
  
  val float_of_string_opt : string -> float option
  
  val read_int_opt : unit -> int option
  
  val read_float_opt : unit -> float option
  
  
  external raise_notrace : exn -> 'a = "%raise_notrace"
  
  (*
  external raise_notrace : exn -> 'a = "%raise"
  *)
  (** @since 4.02.0: external raise_notrace : exn -> 'a = "%raise_notrace"
   *)
  
  
  external __LOC__ : string = "%loc_LOC"
  
  (*
  val __LOC__ : string
  *)
  (** @since 4.02.0: external __LOC__ : string = "%loc_LOC"
   *)
  
  
  external __FILE__ : string = "%loc_FILE"
  
  (*
  val __FILE__ : string
  *)
  (** @since 4.02.0: external __FILE__ : string = "%loc_FILE"
   *)
  
  
  external __LINE__ : int = "%loc_LINE"
  
  (*
  val __LINE__ : int
  *)
  (** @since 4.02.0: external __LINE__ : int = "%loc_LINE"
   *)
  
  
  external __MODULE__ : string = "%loc_MODULE"
  
  (*
  val __MODULE__ : string
  *)
  (** @since 4.02.0: external __MODULE__ : string = "%loc_MODULE"
   *)
  
  
  external __POS__ : (string * int * int * int) = "%loc_POS"
  
  (*
  val __POS__ : (string * int * int * int)
  *)
  (** @since 4.02.0: external __POS__ : (string * int * int * int) = "%loc_POS"
   *)
  
  
  external __LOC_OF__ : 'a -> (string * 'a) = "%loc_LOC"
  
  (*
  val __LOC_OF__ : 'a -> (string * 'a)
  *)
  (** @since 4.02.0: external __LOC_OF__ : 'a -> (string * 'a) = "%loc_LOC"
   *)
  
  
  external __LINE_OF__ : 'a -> (int * 'a) = "%loc_LINE"
  
  (*
  val __LINE_OF__ : 'a -> (int * 'a)
  *)
  (** @since 4.02.0: external __LINE_OF__ : 'a -> (int * 'a) = "%loc_LINE"
   *)
  
  
  external __POS_OF__ : 'a -> ((string * int * int * int) * 'a) = "%loc_POS"
  
  (*
  val __POS_OF__ : 'a -> ((string * int * int * int) * 'a)
  *)
  (** @since 4.02.0:
      external __POS_OF__ :
        'a -> ((string * int * int * int) * 'a) = "%loc_POS"
   *)
  
  
  val print_bytes : bytes -> unit
  
  (*
  val print_bytes : Stdcompat__init.bytes -> unit
  *)
  (** @since 4.02.0: val print_bytes : bytes -> unit
   *)
  
  
  val prerr_bytes : bytes -> unit
  
  (*
  val prerr_bytes : Stdcompat__init.bytes -> unit
  *)
  (** @since 4.02.0: val prerr_bytes : bytes -> unit
   *)
  
  
  external (|>) : 'a -> ('a -> 'b) -> 'b = "%revapply"
  
  (*
  val (|>) : 'a -> ('a -> 'b) -> 'b
  *)
  (** @since 4.01.0: external (|>) : 'a -> ('a -> 'b) -> 'b = "%revapply"
   *)
  
  
  external (@@) : ('a -> 'b) -> 'a -> 'b = "%apply"
  
  (*
  val (@@) : ('a -> 'b) -> 'a -> 'b
  *)
  (** @since 4.01.0: external (@@) : ('a -> 'b) -> 'a -> 'b = "%apply"
   *)
  
  
  external hypot : float -> float -> float = "caml_hypot_float" "caml_hypot"
  [@@unboxed ][@@noalloc ]
  
  (*
  
  external hypot :
    float -> float -> float = "caml_hypot_float" "caml_hypot" "float"
  
  (*
  val hypot : float -> float -> float
  *)
  
  *)
  (** @since 4.03.0:
      external hypot :
        float -> float -> float = "caml_hypot_float" "caml_hypot"[@@unboxed ]
      [@@noalloc ]
  @since 4.00.0:
  external hypot :
    float -> float -> float = "caml_hypot_float" "caml_hypot" "float"
   *)
  
  
  external copysign :
    float -> float -> float = "caml_copysign_float" "caml_copysign"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external copysign :
    float -> float -> float = "caml_copysign_float" "caml_copysign" "float"
  
  (*
  val copysign : float -> float -> float
  *)
  
  *)
  (** @since 4.03.0:
      external copysign :
        float -> float -> float = "caml_copysign_float" "caml_copysign"
      [@@unboxed ][@@noalloc ]
  @since 4.00.0:
  external copysign :
    float -> float -> float = "caml_copysign_float" "caml_copysign" "float"
   *)
  
  external (~+) : int -> int = "%identity"
  (** @since 3.12.0: external (~+) : int -> int = "%identity" *)
  
  external (~+.) : float -> float = "%identity"
  (** @since 3.12.0: external (~+.) : float -> float = "%identity" *)
  
  
  external expm1 : float -> float = "caml_expm1_float" "caml_expm1"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external expm1 : float -> float = "caml_expm1_float" "caml_expm1" "float"
  
  (*
  val expm1 : float -> float
  *)
  
  *)
  (** @since 4.03.0:
      external expm1 : float -> float = "caml_expm1_float" "caml_expm1"
      [@@unboxed ][@@noalloc ]
  @since 3.12.0:
  external expm1 : float -> float = "caml_expm1_float" "caml_expm1" "float"
   *)
  
  
  external log1p : float -> float = "caml_log1p_float" "caml_log1p"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external log1p : float -> float = "caml_log1p_float" "caml_log1p" "float"
  
  (*
  val log1p : float -> float
  *)
  
  *)
  (** @since 4.03.0:
      external log1p : float -> float = "caml_log1p_float" "caml_log1p"
      [@@unboxed ][@@noalloc ]
  @since 3.12.0:
  external log1p : float -> float = "caml_log1p_float" "caml_log1p" "float"
   *)
  
  external raise : exn -> 'a = "%raise"
  (** Alias for {!Stdlib.raise} *)
  
  val invalid_arg : string -> 'a
  (** Alias for {!Stdlib.invalid_arg} *)
  
  val failwith : string -> 'a
  (** Alias for {!Stdlib.failwith} *)
  
  external (=) : 'a -> 'a -> bool = "%equal"
  (** Alias for {!Stdlib.=} *)
  
  external (<>) : 'a -> 'a -> bool = "%notequal"
  (** Alias for {!Stdlib.<>} *)
  
  external (<) : 'a -> 'a -> bool = "%lessthan"
  (** Alias for {!Stdlib.<} *)
  
  external (>) : 'a -> 'a -> bool = "%greaterthan"
  (** Alias for {!Stdlib.>} *)
  
  external (<=) : 'a -> 'a -> bool = "%lessequal"
  (** Alias for {!Stdlib.<=} *)
  
  external (>=) : 'a -> 'a -> bool = "%greaterequal"
  (** Alias for {!Stdlib.>=} *)
  
  external compare : 'a -> 'a -> int = "%compare"
  (** Alias for {!Stdlib.compare} *)
  
  val min : 'a -> 'a -> 'a
  (** Alias for {!Stdlib.min} *)
  
  val max : 'a -> 'a -> 'a
  (** Alias for {!Stdlib.max} *)
  
  external (==) : 'a -> 'a -> bool = "%eq"
  (** Alias for {!Stdlib.==} *)
  
  external (!=) : 'a -> 'a -> bool = "%noteq"
  (** Alias for {!Stdlib.!=} *)
  
  external not : bool -> bool = "%boolnot"
  (** Alias for {!Stdlib.not} *)
  
  external (&&) : bool -> bool -> bool = "%sequand"
  (** Alias for {!Stdlib.&&} *)
  
  (** 
  @since 4.02.0:
  external (&) : bool -> bool -> bool = "%sequand"[@@ocaml.deprecated
                                                    "Use (&&) instead."]
  @since 3.07.0: external (&) : bool -> bool -> bool = "%sequand"
   *)
  
  external (||) : bool -> bool -> bool = "%sequor"
  (** Alias for {!Stdlib.||} *)
  
  (**
  @since 4.02.0:
  external (or) : bool -> bool -> bool = "%sequor"[@@ocaml.deprecated
                                                    "Use (||) instead."]
  @since 3.07.0: external (or) : bool -> bool -> bool = "%sequor"
   *)
  
  external (~-) : int -> int = "%negint"
  (** Alias for {!Stdlib.~-} *)
  
  external succ : int -> int = "%succint"
  (** Alias for {!Stdlib.succ} *)
  
  external pred : int -> int = "%predint"
  (** Alias for {!Stdlib.pred} *)
  
  external (+) : int -> int -> int = "%addint"
  (** Alias for {!Stdlib.+} *)
  
  external (-) : int -> int -> int = "%subint"
  (** Alias for {!Stdlib.-} *)
  
  external ( * ) : int -> int -> int = "%mulint"
  (** Alias for {!Stdlib.*} *)
  
  external (/) : int -> int -> int = "%divint"
  (** Alias for {!Stdlib./} *)
  
  external (mod) : int -> int -> int = "%modint"
  (** Alias for {!Stdlib.mod} *)
  
  val abs : int -> int
  (** Alias for {!Stdlib.abs} *)
  
  val max_int : int
  (** Alias for {!Stdlib.max_int} *)
  
  val min_int : int
  (** Alias for {!Stdlib.min_int} *)
  
  external (land) : int -> int -> int = "%andint"
  (** Alias for {!Stdlib.land} *)
  
  external (lor) : int -> int -> int = "%orint"
  (** Alias for {!Stdlib.lor} *)
  
  external (lxor) : int -> int -> int = "%xorint"
  (** Alias for {!Stdlib.lxor} *)
  
  val lnot : int -> int
  (** Alias for {!Stdlib.lnot} *)
  
  external (lsl) : int -> int -> int = "%lslint"
  (** Alias for {!Stdlib.lsl} *)
  
  external (lsr) : int -> int -> int = "%lsrint"
  (** Alias for {!Stdlib.lsr} *)
  
  external (asr) : int -> int -> int = "%asrint"
  (** Alias for {!Stdlib.asr} *)
  
  external (~-.) : float -> float = "%negfloat"
  (** Alias for {!Stdlib.~-.} *)
  
  external (+.) : float -> float -> float = "%addfloat"
  (** Alias for {!Stdlib.+.} *)
  
  external (-.) : float -> float -> float = "%subfloat"
  (** Alias for {!Stdlib.-.} *)
  
  external ( *. ) : float -> float -> float = "%mulfloat"
  (** Alias for {!Stdlib.*.} *)
  
  external (/.) : float -> float -> float = "%divfloat"
  (** Alias for {!Stdlib./.} *)
  
  
  external ( ** ) : float -> float -> float = "caml_power_float" "pow"[@@unboxed
                                                                      ]
  [@@noalloc ]
  
  (*
  
  external ( ** ) : float -> float -> float = "caml_power_float" "pow" "float"
  
  (*
  external ( ** ) : float -> float -> float = "power_float" "pow" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external ( ** ) : float -> float -> float = "caml_power_float" "pow"
      [@@unboxed ][@@noalloc ]
  @since 3.08.0:
  external ( ** ) : float -> float -> float = "caml_power_float" "pow" "float"
  @since 3.07.0:
  external ( ** ) : float -> float -> float = "power_float" "pow" "float"
   *)
  
  
  external sqrt : float -> float = "caml_sqrt_float" "sqrt"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external sqrt : float -> float = "caml_sqrt_float" "sqrt" "float"
  
  (*
  external sqrt : float -> float = "sqrt_float" "sqrt" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external sqrt : float -> float = "caml_sqrt_float" "sqrt"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external sqrt : float -> float = "caml_sqrt_float" "sqrt" "float"
  @since 3.07.0: external sqrt : float -> float = "sqrt_float" "sqrt" "float"
   *)
  
  
  external exp : float -> float = "caml_exp_float" "exp"[@@unboxed ][@@noalloc
                                                                      ]
  
  (*
  
  external exp : float -> float = "caml_exp_float" "exp" "float"
  
  (*
  external exp : float -> float = "exp_float" "exp" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external exp : float -> float = "caml_exp_float" "exp"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0: external exp : float -> float = "caml_exp_float" "exp" "float"
  @since 3.07.0: external exp : float -> float = "exp_float" "exp" "float"
   *)
  
  
  external log : float -> float = "caml_log_float" "log"[@@unboxed ][@@noalloc
                                                                      ]
  
  (*
  
  external log : float -> float = "caml_log_float" "log" "float"
  
  (*
  external log : float -> float = "log_float" "log" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external log : float -> float = "caml_log_float" "log"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0: external log : float -> float = "caml_log_float" "log" "float"
  @since 3.07.0: external log : float -> float = "log_float" "log" "float"
   *)
  
  
  external log10 : float -> float = "caml_log10_float" "log10"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external log10 : float -> float = "caml_log10_float" "log10" "float"
  
  (*
  external log10 : float -> float = "log10_float" "log10" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external log10 : float -> float = "caml_log10_float" "log10"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external log10 : float -> float = "caml_log10_float" "log10" "float"
  @since 3.07.0:
  external log10 : float -> float = "log10_float" "log10" "float"
   *)
  
  
  external cos : float -> float = "caml_cos_float" "cos"[@@unboxed ][@@noalloc
                                                                      ]
  
  (*
  
  external cos : float -> float = "caml_cos_float" "cos" "float"
  
  (*
  external cos : float -> float = "cos_float" "cos" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external cos : float -> float = "caml_cos_float" "cos"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0: external cos : float -> float = "caml_cos_float" "cos" "float"
  @since 3.07.0: external cos : float -> float = "cos_float" "cos" "float"
   *)
  
  
  external sin : float -> float = "caml_sin_float" "sin"[@@unboxed ][@@noalloc
                                                                      ]
  
  (*
  
  external sin : float -> float = "caml_sin_float" "sin" "float"
  
  (*
  external sin : float -> float = "sin_float" "sin" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external sin : float -> float = "caml_sin_float" "sin"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0: external sin : float -> float = "caml_sin_float" "sin" "float"
  @since 3.07.0: external sin : float -> float = "sin_float" "sin" "float"
   *)
  
  
  external tan : float -> float = "caml_tan_float" "tan"[@@unboxed ][@@noalloc
                                                                      ]
  
  (*
  
  external tan : float -> float = "caml_tan_float" "tan" "float"
  
  (*
  external tan : float -> float = "tan_float" "tan" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external tan : float -> float = "caml_tan_float" "tan"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0: external tan : float -> float = "caml_tan_float" "tan" "float"
  @since 3.07.0: external tan : float -> float = "tan_float" "tan" "float"
   *)
  
  
  external acos : float -> float = "caml_acos_float" "acos"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external acos : float -> float = "caml_acos_float" "acos" "float"
  
  (*
  external acos : float -> float = "acos_float" "acos" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external acos : float -> float = "caml_acos_float" "acos"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external acos : float -> float = "caml_acos_float" "acos" "float"
  @since 3.07.0: external acos : float -> float = "acos_float" "acos" "float"
   *)
  
  
  external asin : float -> float = "caml_asin_float" "asin"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external asin : float -> float = "caml_asin_float" "asin" "float"
  
  (*
  external asin : float -> float = "asin_float" "asin" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external asin : float -> float = "caml_asin_float" "asin"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external asin : float -> float = "caml_asin_float" "asin" "float"
  @since 3.07.0: external asin : float -> float = "asin_float" "asin" "float"
   *)
  
  
  external atan : float -> float = "caml_atan_float" "atan"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external atan : float -> float = "caml_atan_float" "atan" "float"
  
  (*
  external atan : float -> float = "atan_float" "atan" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external atan : float -> float = "caml_atan_float" "atan"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external atan : float -> float = "caml_atan_float" "atan" "float"
  @since 3.07.0: external atan : float -> float = "atan_float" "atan" "float"
   *)
  
  
  external atan2 : float -> float -> float = "caml_atan2_float" "atan2"
  [@@unboxed ][@@noalloc ]
  
  (*
  
  external atan2 : float -> float -> float = "caml_atan2_float" "atan2" "float"
  
  (*
  external atan2 : float -> float -> float = "atan2_float" "atan2" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external atan2 : float -> float -> float = "caml_atan2_float" "atan2"
      [@@unboxed ][@@noalloc ]
  @since 3.08.0:
  external atan2 : float -> float -> float = "caml_atan2_float" "atan2" "float"
  @since 3.07.0:
  external atan2 : float -> float -> float = "atan2_float" "atan2" "float"
   *)
  
  
  external cosh : float -> float = "caml_cosh_float" "cosh"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external cosh : float -> float = "caml_cosh_float" "cosh" "float"
  
  (*
  external cosh : float -> float = "cosh_float" "cosh" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external cosh : float -> float = "caml_cosh_float" "cosh"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external cosh : float -> float = "caml_cosh_float" "cosh" "float"
  @since 3.07.0: external cosh : float -> float = "cosh_float" "cosh" "float"
   *)
  
  
  external sinh : float -> float = "caml_sinh_float" "sinh"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external sinh : float -> float = "caml_sinh_float" "sinh" "float"
  
  (*
  external sinh : float -> float = "sinh_float" "sinh" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external sinh : float -> float = "caml_sinh_float" "sinh"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external sinh : float -> float = "caml_sinh_float" "sinh" "float"
  @since 3.07.0: external sinh : float -> float = "sinh_float" "sinh" "float"
   *)
  
  
  external tanh : float -> float = "caml_tanh_float" "tanh"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external tanh : float -> float = "caml_tanh_float" "tanh" "float"
  
  (*
  external tanh : float -> float = "tanh_float" "tanh" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external tanh : float -> float = "caml_tanh_float" "tanh"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external tanh : float -> float = "caml_tanh_float" "tanh" "float"
  @since 3.07.0: external tanh : float -> float = "tanh_float" "tanh" "float"
   *)
  
  
  external ceil : float -> float = "caml_ceil_float" "ceil"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external ceil : float -> float = "caml_ceil_float" "ceil" "float"
  
  (*
  external ceil : float -> float = "ceil_float" "ceil" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external ceil : float -> float = "caml_ceil_float" "ceil"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external ceil : float -> float = "caml_ceil_float" "ceil" "float"
  @since 3.07.0: external ceil : float -> float = "ceil_float" "ceil" "float"
   *)
  
  
  external floor : float -> float = "caml_floor_float" "floor"[@@unboxed ]
  [@@noalloc ]
  
  (*
  
  external floor : float -> float = "caml_floor_float" "floor" "float"
  
  (*
  external floor : float -> float = "floor_float" "floor" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external floor : float -> float = "caml_floor_float" "floor"[@@unboxed ]
      [@@noalloc ]
  @since 3.08.0:
  external floor : float -> float = "caml_floor_float" "floor" "float"
  @since 3.07.0:
  external floor : float -> float = "floor_float" "floor" "float"
   *)
  
  external abs_float : float -> float = "%absfloat"
  (** Alias for {!Stdlib.abs_float} *)
  
  
  external mod_float : float -> float -> float = "caml_fmod_float" "fmod"
  [@@unboxed ][@@noalloc ]
  
  (*
  
  external mod_float :
    float -> float -> float = "caml_fmod_float" "fmod" "float"
  
  (*
  external mod_float : float -> float -> float = "fmod_float" "fmod" "float"
  *)
  
  *)
  (** @since 4.03.0:
      external mod_float : float -> float -> float = "caml_fmod_float" "fmod"
      [@@unboxed ][@@noalloc ]
  @since 3.08.0:
  external mod_float :
    float -> float -> float = "caml_fmod_float" "fmod" "float"
  @since 3.07.0:
  external mod_float : float -> float -> float = "fmod_float" "fmod" "float"
   *)
  
  
  external frexp : float -> (float * int) = "caml_frexp_float"
  
  (*
  external frexp : float -> (float * int) = "frexp_float"
  *)
  (** @since 3.08.0:
      external frexp : float -> (float * int) = "caml_frexp_float"
  @since 3.07.0: external frexp : float -> (float * int) = "frexp_float"
   *)
  
  
  external ldexp :
    ((float)[@unboxed ]) -> ((int)[@untagged ]) -> ((float)[@unboxed ]) =
      "caml_ldexp_float" "caml_ldexp_float_unboxed"[@@noalloc ]
  
  (*
  
  external ldexp : float -> int -> float = "caml_ldexp_float"
  
  (*
  external ldexp : float -> int -> float = "ldexp_float"
  *)
  
  *)
  (** @since 4.03.0:
      external ldexp :
        ((float)[@unboxed ]) -> ((int)[@untagged ]) -> ((float)[@unboxed ]) =
          "caml_ldexp_float" "caml_ldexp_float_unboxed"[@@noalloc ]
  @since 3.08.0: external ldexp : float -> int -> float = "caml_ldexp_float"
  @since 3.07.0: external ldexp : float -> int -> float = "ldexp_float"
   *)
  
  
  external modf : float -> (float * float) = "caml_modf_float"
  
  (*
  external modf : float -> (float * float) = "modf_float"
  *)
  (** @since 3.08.0:
      external modf : float -> (float * float) = "caml_modf_float"
  @since 3.07.0: external modf : float -> (float * float) = "modf_float"
   *)
  
  external float : int -> float = "%floatofint"
  (** Alias for {!Stdlib.float} *)
  
  external float_of_int : int -> float = "%floatofint"
  (** Alias for {!Stdlib.float_of_int} *)
  
  external truncate : float -> int = "%intoffloat"
  (** Alias for {!Stdlib.truncate} *)
  
  external int_of_float : float -> int = "%intoffloat"
  (** Alias for {!Stdlib.int_of_float} *)
  
  val infinity : float
  (** Alias for {!Stdlib.infinity} *)
  
  val neg_infinity : float
  (** Alias for {!Stdlib.neg_infinity} *)
  
  val nan : float
  (** Alias for {!Stdlib.nan} *)
  
  val max_float : float
  (** Alias for {!Stdlib.max_float} *)
  
  val min_float : float
  (** Alias for {!Stdlib.min_float} *)
  
  val epsilon_float : float
  (** Alias for {!Stdlib.epsilon_float} *)
  
  
  external classify_float :
    ((float)[@unboxed ]) -> fpclass = "caml_classify_float"
      "caml_classify_float_unboxed"[@@noalloc ]
  
  (*
  
  external classify_float : float -> fpclass = "caml_classify_float"
  
  (*
  external classify_float : float -> fpclass = "classify_float"
  *)
  
  *)
  (** @since 4.03.0:
      external classify_float :
        ((float)[@unboxed ]) -> fpclass = "caml_classify_float"
          "caml_classify_float_unboxed"[@@noalloc ]
  @since 3.08.0:
  external classify_float : float -> fpclass = "caml_classify_float"
  @since 3.07.0: external classify_float : float -> fpclass = "classify_float"
   *)
  
  val (^) : string -> string -> string
  (** Alias for {!Stdlib.^} *)
  
  external int_of_char : char -> int = "%identity"
  (** Alias for {!Stdlib.int_of_char} *)
  
  val char_of_int : int -> char
  (** Alias for {!Stdlib.char_of_int} *)
  
  external ignore : 'a -> unit = "%ignore"
  (** Alias for {!Stdlib.ignore} *)
  
  val string_of_bool : bool -> string
  (** Alias for {!Stdlib.string_of_bool} *)
  
  val bool_of_string : string -> bool
  (** Alias for {!Stdlib.bool_of_string} *)
  
  val string_of_int : int -> string
  (** Alias for {!Stdlib.string_of_int} *)
  
  
  external int_of_string : string -> int = "caml_int_of_string"
  
  (*
  external int_of_string : string -> int = "int_of_string"
  *)
  (** @since 3.08.0:
      external int_of_string : string -> int = "caml_int_of_string"
  @since 3.07.0: external int_of_string : string -> int = "int_of_string"
   *)
  
  val string_of_float : float -> string
  (** Alias for {!Stdlib.string_of_float} *)
  
  
  external float_of_string : string -> float = "caml_float_of_string"
  
  (*
  external float_of_string : string -> float = "float_of_string"
  *)
  (** @since 3.08.0:
      external float_of_string : string -> float = "caml_float_of_string"
  @since 3.07.0: external float_of_string : string -> float = "float_of_string"
   *)
  
  (*
  external fst : ('a * 'b) -> 'a = "%field0_immut"
  (** Alias for {!Stdlib.fst} *)
  
  external snd : ('a * 'b) -> 'b = "%field1_immut"
  (** Alias for {!Stdlib.snd} *)
  *)
  
  external fst : ('a * 'b) -> 'a = "%field0"
  (** Alias for {!Stdlib.fst} *)
  
  external snd : ('a * 'b) -> 'b = "%field1"
  (** Alias for {!Stdlib.snd} *)
  
  
  val (@) : 'a list -> 'a list -> 'a list
  (** Alias for {!Stdlib.@} *)
  
  val print_char : char -> unit
  (** Alias for {!Stdlib.print_char} *)
  
  val print_string : string -> unit
  (** Alias for {!Stdlib.print_string} *)
  
  val print_int : int -> unit
  (** Alias for {!Stdlib.print_int} *)
  
  val print_float : float -> unit
  (** Alias for {!Stdlib.print_float} *)
  
  val print_endline : string -> unit
  (** Alias for {!Stdlib.print_endline} *)
  
  val print_newline : unit -> unit
  (** Alias for {!Stdlib.print_newline} *)
  
  val prerr_char : char -> unit
  (** Alias for {!Stdlib.prerr_char} *)
  
  val prerr_string : string -> unit
  (** Alias for {!Stdlib.prerr_string} *)
  
  val prerr_int : int -> unit
  (** Alias for {!Stdlib.prerr_int} *)
  
  val prerr_float : float -> unit
  (** Alias for {!Stdlib.prerr_float} *)
  
  val prerr_endline : string -> unit
  (** Alias for {!Stdlib.prerr_endline} *)
  
  val prerr_newline : unit -> unit
  (** Alias for {!Stdlib.prerr_newline} *)
  
  val read_line : unit -> string
  (** Alias for {!Stdlib.read_line} *)
  
  val read_int : unit -> int
  (** Alias for {!Stdlib.read_int} *)
  
  val read_float : unit -> float
  (** Alias for {!Stdlib.read_float} *)
  
  val flush_all : unit -> unit
  (** Alias for {!Stdlib.flush_all} *)
  
  external ref : 'a -> 'a ref = "%makemutable"
  (** Alias for {!Stdlib.ref} *)
  
  external (!) : 'a ref -> 'a = "%field0"
  (** Alias for {!Stdlib.!} *)
  
  external (:=) : 'a ref -> 'a -> unit = "%setfield0"
  (** Alias for {!Stdlib.:=} *)
  
  external incr : int ref -> unit = "%incr"
  (** Alias for {!Stdlib.incr} *)
  
  external decr : int ref -> unit = "%decr"
  (** Alias for {!Stdlib.decr} *)
  
  
  external format_of_string :
    ('a, 'b, 'c, 'd, 'e, 'f) format6 -> ('a, 'b, 'c, 'd, 'e, 'f) format6 =
      "%identity"
  
  (*
  external format_of_string :
    ('a, 'b, 'c, 'd) format4 -> ('a, 'b, 'c, 'd) format4 = "%identity"
  *)
  (** @since 3.10.0:
      external format_of_string :
        ('a, 'b, 'c, 'd, 'e, 'f) format6 -> ('a, 'b, 'c, 'd, 'e, 'f) format6 =
          "%identity"
  @since 3.07.0:
  external format_of_string :
    ('a, 'b, 'c, 'd) format4 -> ('a, 'b, 'c, 'd) format4 = "%identity"
   *)
  
  val exit : int -> 'a
  (** Alias for {!Stdlib.exit} *)
  
  val at_exit : (unit -> unit) -> unit
  (** Alias for {!Stdlib.at_exit} *)
  
  val valid_float_lexem : string -> string
  (** Alias for {!Stdlib.valid_float_lexem} *)
  
  val do_at_exit : unit -> unit
  (** Alias for {!Stdlib>.do_at_exit} *)
end
