module type S = sig

(*
type 'a t
*)


type !'a t


val create : unit -> 'a t
val make : int -> 'a -> 'a t

val init : int -> (int -> 'a) -> 'a t

val get : 'a t -> int -> 'a

val set : 'a t -> int -> 'a -> unit

val length : 'a t -> int

val equal : ('a -> 'a -> bool) -> 'a t -> 'a t -> bool
val compare : ('a -> 'a -> int) -> 'a t -> 'a t -> int

val is_empty : 'a t -> bool

val get_last : 'a t -> 'a

val find_last : 'a t -> 'a option

val copy : 'a t -> 'a t

val add_last : 'a t -> 'a -> unit

val append_array : 'a t -> 'a array -> unit

val append_list : 'a t -> 'a list -> unit

val append : 'a t -> 'a t -> unit

val append_seq : 'a t -> 'a Seq.t -> unit

val append_iter :
  'a t ->
  (('a -> unit) -> 'x -> unit) ->
  'x -> unit

val blit : src:'a t -> src_pos:int -> dst:'a t -> dst_pos:int -> len:int -> unit

val pop_last_opt : 'a t -> 'a option

val pop_last : 'a t -> 'a

val remove_last : 'a t -> unit

val truncate : 'a t -> int -> unit

val clear : 'a t -> unit

val iter : ('a -> unit) -> 'a t -> unit

val iteri : (int -> 'a -> unit) -> 'a t -> unit

val map : ('a -> 'b) -> 'a t -> 'b t

val mapi : (int -> 'a -> 'b) -> 'a t -> 'b t

val fold_left : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc

val fold_right : ('a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc

val mem : 'a -> 'a t -> bool
val memq : 'a -> 'a t -> bool

val exists : ('a -> bool) -> 'a t -> bool

val for_all : ('a -> bool) -> 'a t -> bool

val find_opt : ('a -> bool) -> 'a t -> 'a option

val find_index : ('a -> bool) -> 'a t -> int option

val find_map : ('a -> 'b option) -> 'a t -> 'b option

val find_mapi : (int -> 'a -> 'b option) -> 'a t -> 'b option

val filter : ('a -> bool) -> 'a t -> 'a t

val filter_map : ('a -> 'b option) -> 'a t -> 'b t

val of_array : 'a array -> 'a t

val to_array : 'a t -> 'a array

val of_list : 'a list -> 'a t

val to_list : 'a t -> 'a list

val of_seq : 'a Seq.t -> 'a t

val to_seq : 'a t -> 'a Seq.t

val to_seq_reentrant : 'a t -> 'a Seq.t

val to_seq_rev : 'a t -> 'a Seq.t

val to_seq_rev_reentrant : 'a t -> 'a Seq.t


val capacity : 'a t -> int

val ensure_capacity : 'a t -> int -> unit

val ensure_extra_capacity : 'a t -> int -> unit

val fit_capacity : 'a t -> unit

val set_capacity : 'a t -> int -> unit

val reset : 'a t -> unit
end
