from _typeshed import Incomplete
from collections.abc import Generator, Iterable, Iterator

from pygments.filter import Filter
from pygments.lexer import Lexer
from pygments.token import _TokenType

def find_filter_class(filtername): ...
def get_filter_by_name(filtername, **options): ...
def get_all_filters() -> Generator[str]: ...

class CodeTagFilter(Filter):
    tag_re: Incomplete
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class SymbolFilter(Filter):
    latex_symbols: Incomplete
    isabelle_symbols: Incomplete
    lang_map: Incomplete
    symbols: Incomplete
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class KeywordCaseFilter(Filter):
    convert: Incomplete
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class NameHighlightFilter(Filter):
    names: Incomplete
    tokentype: Incomplete
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class ErrorToken(Exception): ...

class RaiseOnErrorTokenFilter(Filter):
    exception: Incomplete
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class VisibleWhitespaceFilter(Filter):
    wstt: Incomplete
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class GobbleFilter(Filter):
    n: Incomplete
    def __init__(self, **options) -> None: ...
    def gobble(self, value, left): ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

class TokenMergeFilter(Filter):
    def __init__(self, **options) -> None: ...
    def filter(self, lexer: Lexer, stream: Iterable[tuple[_TokenType, str]]) -> Iterator[tuple[_TokenType, str]]: ...

FILTERS: Incomplete
