/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.flowfram;

import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.generic.ParCs;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.BeginDocumentEvent;
import com.dickimawbooks.texparserlib.latex.BeginDocumentListener;
import com.dickimawbooks.texparserlib.latex.GobbleOpt;
import com.dickimawbooks.texparserlib.latex.GobbleOptMandOpt;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.color.ColorSty;
import com.dickimawbooks.texparserlib.latex.flowfram.ComputeBottomEdge;
import com.dickimawbooks.texparserlib.latex.flowfram.ComputeLeftEdgeEven;
import com.dickimawbooks.texparserlib.latex.flowfram.ComputeLeftEdgeOdd;
import com.dickimawbooks.texparserlib.latex.flowfram.ComputeRightEdgeEven;
import com.dickimawbooks.texparserlib.latex.flowfram.ComputeRightEdgeOdd;
import com.dickimawbooks.texparserlib.latex.flowfram.ComputeTopEdge;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFramSectionUnit;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFramSetup;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameData;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameType;
import com.dickimawbooks.texparserlib.latex.flowfram.GetFlowId;
import com.dickimawbooks.texparserlib.latex.flowfram.GetFlowLabel;
import com.dickimawbooks.texparserlib.latex.flowfram.MakeDFHeaderFooter;
import com.dickimawbooks.texparserlib.latex.flowfram.NewFlowFrame;
import com.dickimawbooks.texparserlib.latex.flowfram.NumColumnInArea;
import com.dickimawbooks.texparserlib.latex.flowfram.SetFrameAttrs;
import com.dickimawbooks.texparserlib.latex.flowfram.SetFrameContents;
import com.dickimawbooks.texparserlib.latex.flowfram.SetFrameContentsEnv;
import com.dickimawbooks.texparserlib.latex.flowfram.StaticFloat;
import com.dickimawbooks.texparserlib.latex.flowfram.TwoTone;
import com.dickimawbooks.texparserlib.latex.flowfram.TwoToneBottom;
import com.dickimawbooks.texparserlib.latex.flowfram.TwoToneTop;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class FlowFramSty
extends LaTeXSty
implements BeginDocumentListener {
    boolean pagesRelative = true;
    FlowFrameData currentFrame;
    Vector<FlowFrameData> flowFrames;
    Vector<FlowFrameData> staticFrames;
    Vector<FlowFrameData> dynamicFrames;
    HashMap<String, Integer> flowIdMap;
    HashMap<String, Integer> staticIdMap;
    HashMap<String, Integer> dynamicIdMap;
    protected ColorSty colorSty;
    public static final String ERROR_FLOW_ALREADY_DEFINED = "flowfram.flow_already_defined";
    public static final String ERROR_FLOW_ID_NOT_DEFINED = "flowfram.flow_id_not_defined";
    public static final String ERROR_FLOW_LABEL_NOT_DEFINED = "flowfram.flow_label_not_defined";
    public static final String ERROR_STATIC_ALREADY_DEFINED = "staticfram.static_already_defined";
    public static final String ERROR_STATIC_ID_NOT_DEFINED = "staticfram.static_id_not_defined";
    public static final String ERROR_STATIC_LABEL_NOT_DEFINED = "staticfram.static_label_not_defined";
    public static final String ERROR_DYNAMIC_ALREADY_DEFINED = "dynamicfram.dynamic_already_defined";
    public static final String ERROR_DYNAMIC_ID_NOT_DEFINED = "dynamicfram.dynamic_id_not_defined";
    public static final String ERROR_DYNAMIC_LABEL_NOT_DEFINED = "dynamicfram.dynamic_label_not_defined";
    public static final String ERROR_LABEL_NOT_DEFINED = "flowfram.label_not_defined";
    public static final String ERROR_ID_NOT_DEFINED = "flowfram.id_not_defined";
    public static final String INVALID_FRAME_SETTING = "flowfram.invalid_frame_setting";
    public static final String INVALID_FRAME_NOVAL_SETTING = "flowfram.invalid_frame_noval_setting";

    public FlowFramSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl, ColorSty colorSty) throws IOException {
        super(keyValList, "flowfram", laTeXParserListener, bl);
        float f;
        this.colorSty = colorSty;
        this.flowFrames = new Vector();
        this.staticFrames = new Vector();
        this.dynamicFrames = new Vector();
        this.flowIdMap = new HashMap();
        this.staticIdMap = new HashMap();
        this.dynamicIdMap = new HashMap();
        if (laTeXParserListener instanceof L2HConverter) {
            laTeXParserListener.addBeginDocumentListener(this);
        }
        if ((f = TeXParserUtils.toPt(this.getParser(), "textwidth")) == 0.0f) {
            f = 430.0046f;
        }
        this.registerNewLength("typeblockwidth", f, TeXUnit.PT);
        float f2 = TeXParserUtils.toPt(this.getParser(), "textheight");
        if (f2 == 0.0f) {
            f2 = 556.47656f;
        }
        this.registerNewLength("typeblockheight", f2, TeXUnit.PT);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        NewIf.createConditional(true, this.getParser(), "iflefttorightcolumns", true);
        NewIf.createConditional(true, this.getParser(), "ifshowtypeblock", false);
        NewIf.createConditional(true, this.getParser(), "ifshowmargins", false);
        NewIf.createConditional(true, this.getParser(), "ifshowframebbox", false);
        laTeXParserListener.newcounter("absolutepage");
        laTeXParserListener.newcounter("maxflow");
        laTeXParserListener.newcounter("maxstatic");
        laTeXParserListener.newcounter("maxdynamic");
        laTeXParserListener.newcounter("maxthumbtabs");
        laTeXParserListener.newcounter("thisframe");
        laTeXParserListener.newcounter("displayedframe");
        laTeXParserListener.newcounter("minitoc");
        this.registerNewLength("fflabelsep", 1.0f, TeXUnit.PT);
        this.registerNewLength("fftolerance", 2.0f, TeXUnit.PT);
        this.registerNewLength("sdfparindent", 0.0f, TeXUnit.PT);
        this.registerNewLength("flowframesep", 3.0f, TeXUnit.PT);
        this.registerNewLength("flowframerule", 0.4f, TeXUnit.PT);
        this.registerNewLength("ffareawidth", 0.0f, TeXUnit.PT);
        this.registerNewLength("ffareaheight", 0.0f, TeXUnit.PT);
        this.registerNewLength("ffareax", 0.0f, TeXUnit.PT);
        this.registerNewLength("ffareay", 0.0f, TeXUnit.PT);
        this.registerNewLength("ffareaevenx", 0.0f, TeXUnit.PT);
        this.registerNewLength("ffareaeveny", 0.0f, TeXUnit.PT);
        this.registerNewLength("ffevenoffset", 0.0f, TeXUnit.PT);
        this.registerNewLength("columnheight", 0.0f, TeXUnit.PT);
        this.registerNewLength("vcolumnsep", 10.0f, TeXUnit.PT);
        this.registerNewLength("ffcolumnseprule", 2.0f, TeXUnit.PT);
        this.registerNewLength("thumbtabwidth", 1.0f, TeXUnit.CM);
        this.registerNewLength("beforeminitocskip", 0.0f, TeXUnit.PT);
        this.registerNewLength("afterminitocskip", 0.0f, TeXUnit.PT);
        this.registerControlSequence(new StaticFloat("staticfigure", "figure"));
        this.registerControlSequence(new StaticFloat("statictable", "table"));
        this.registerControlSequence(new NewFlowFrame(this));
        this.registerControlSequence(new NewFlowFrame("newstaticframe", FlowFrameType.STATIC, this));
        this.registerControlSequence(new NewFlowFrame("newdynamicframe", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new NumColumnInArea("onecolumn", 1, false, this));
        this.registerControlSequence(new NumColumnInArea("onecolumninarea", 1, true, this));
        this.registerControlSequence(new NumColumnInArea("twocolumn", 2, false, this));
        this.registerControlSequence(new NumColumnInArea("twocolumninarea", 2, true, this));
        this.registerControlSequence(new NumColumnInArea("Ncolumn", 0, false, this));
        this.registerControlSequence(new NumColumnInArea("Ncolumninarea", 0, true, this));
        this.registerControlSequence(new GetFlowLabel(this));
        this.registerControlSequence(new GetFlowLabel("getstaticlabel", FlowFrameType.STATIC, this));
        this.registerControlSequence(new GetFlowLabel("getdynamiclabel", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new GetFlowId(this));
        this.registerControlSequence(new GetFlowId("getstaticid", FlowFrameType.STATIC, this));
        this.registerControlSequence(new GetFlowId("getdynamicid", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new SetFrameContents("setstaticcontents", FlowFrameType.STATIC, this));
        this.registerControlSequence(new SetFrameContents("setdynamiccontents", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new SetFrameContents("appenddynamiccontents", FlowFrameType.DYNAMIC, true, this));
        this.registerControlSequence(new SetFrameContentsEnv("staticcontents", FlowFrameType.STATIC, this));
        this.registerControlSequence(new SetFrameContentsEnv("staticcontents*", FlowFrameType.STATIC, this));
        this.registerControlSequence(new SetFrameContentsEnv("dynamiccontents", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new SetFrameContentsEnv("dynamiccontents*", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new SetFrameAttrs("setstaticframe", FlowFrameType.STATIC, this));
        this.registerControlSequence(new SetFrameAttrs("setdynamicframe", FlowFrameType.DYNAMIC, this));
        this.registerControlSequence(new SetFrameAttrs("setflowframe", FlowFrameType.FLOW, this));
        this.registerControlSequence(new FlowFramSectionUnit());
        this.registerControlSequence(new ComputeLeftEdgeOdd());
        this.registerControlSequence(new ComputeLeftEdgeEven());
        this.registerControlSequence(new ComputeTopEdge());
        this.registerControlSequence(new ComputeBottomEdge());
        this.registerControlSequence(new ComputeRightEdgeOdd());
        this.registerControlSequence(new ComputeRightEdgeEven());
        this.registerControlSequence(new TwoTone(this));
        this.registerControlSequence(new TwoTone("htwotone", false, this));
        this.registerControlSequence(new TwoToneBottom(this));
        this.registerControlSequence(new TwoToneBottom("htwotoneleft", false, this));
        this.registerControlSequence(new TwoToneTop(this));
        this.registerControlSequence(new TwoToneTop("htwotoneright", false, this));
        this.registerControlSequence(new MakeDFHeaderFooter(this));
        this.registerControlSequence(new FlowFramSetup(this));
        this.registerControlSequence(new Relax("flowframeshowlayout"));
        this.registerControlSequence(new Relax("framebreak"));
        this.registerControlSequence(new Relax("enablethumbtabs"));
        this.registerControlSequence(new Relax("disablethumbtabs"));
        if (this.getListener() instanceof L2HConverter) {
            this.registerControlSequence(new ParCs("cleartoevenpage"));
        }
        this.registerControlSequence(new GenericCommand(true, "ffprechapterhook"));
        this.registerControlSequence(new GenericCommand(true, "ffruledeclarations"));
        this.registerControlSequence(new GobbleOpt("continueonframe", 1, 1, new int[0]));
        this.registerControlSequence(new AtGobble("ffcontinuedtextlayout"));
        this.registerControlSequence(new AtGobble("ffcontinuedtextfont"));
        this.registerControlSequence(new GobbleOpt("dfchaphead", 0, 1, 42));
        this.registerControlSequence(new AtGobble("DFchapterstyle"));
        this.registerControlSequence(new AtGobble("DFschapterstyle"));
        this.registerControlSequence(new GobbleOptMandOpt("makethumbtabs", 1, 1, 1, new int[0]));
        this.registerControlSequence(new GobbleOpt("enableminitoc", 1, 0, new int[0]));
        this.registerControlSequence(new AtGobble("setthumbtab", 2));
        this.registerControlSequence(new GobbleOpt("ffswapoddeven", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("sfswapoddeven", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dfswapoddeven", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchoffnext", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchoffnextodd", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchoffnextonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchoffnextoddonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchonnext", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchonnextodd", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchonnextonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("flowswitchonnextoddonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchonnext", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchonnextodd", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchonnextonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchonnextoddonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchoffnext", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchoffnextodd", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchoffnextonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("dynamicswitchoffnextoddonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchonnext", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchonnextodd", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchonnextonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchonnextoddonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchoffnext", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchoffnextodd", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchoffnextonly", 0, 1, 42));
        this.registerControlSequence(new GobbleOpt("staticswitchoffnextoddonly", 0, 1, 42));
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (string.equals("pages")) {
            String string2 = this.getParser().expandToString(teXObject, null).trim();
            this.pagesRelative = string2.equals("relative");
        } else if (string.equals("LR")) {
            this.getParser().putControlSequence(true, new IfTrue("iflefttorightcolumns"));
        } else if (string.equals("RL")) {
            this.getParser().putControlSequence(true, new IfFalse("iflefttorightcolumns"));
        } else if (string.equals("verbose") || string.equals("color") || string.equals("nocolor") || string.equals("rotate") || string.equals("thumbtabs") || string.equals("ttbtitle") || string.equals("ttbnotitle") || string.equals("ttbnum") || string.equals("ttbnonum")) {
            // empty if block
        }
    }

    public FlowFrameData newFlowFrame(String string, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4) throws TeXSyntaxException {
        int n = this.flowFrames.size();
        if (string == null) {
            string = "" + n;
        }
        if (this.flowIdMap.containsKey(string)) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_FLOW_ALREADY_DEFINED, string);
        }
        this.getParser().putControlSequence(new TextualContentCommand("@col@id@" + RomanNumeral.romannumeral(n), string));
        FlowFrameData flowFrameData = new FlowFrameData(FlowFrameType.FLOW, string, n, bl, teXDimension, teXDimension2, teXDimension3, teXDimension4);
        this.flowFrames.add(flowFrameData);
        this.flowIdMap.put(string, n);
        this.listener.stepcounter("maxflow");
        if (this.currentFrame == null) {
            this.currentFrame = flowFrameData;
        }
        return flowFrameData;
    }

    public FlowFrameData getFlowFrame(String string) {
        Integer n = this.flowIdMap.get(string);
        if (n == null) {
            return null;
        }
        return this.flowFrames.get(n);
    }

    public FlowFrameData getFlowFrame(int n) {
        return this.flowFrames.get(n);
    }

    public void setFlowFrameLabel(int n, String string) throws TeXSyntaxException {
        FlowFrameData flowFrameData = this.getFlowFrame(n);
        if (flowFrameData == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_FLOW_ID_NOT_DEFINED, n);
        }
        this.setFrameLabel(flowFrameData, string);
    }

    public int getFlowFrameId(String string) throws TeXSyntaxException {
        Integer n = this.flowIdMap.get(string);
        if (n == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_FLOW_LABEL_NOT_DEFINED, string);
        }
        return n;
    }

    public FlowFrameData newStaticFrame(String string, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4) throws TeXSyntaxException {
        int n = this.staticFrames.size();
        if (string == null) {
            string = "" + n;
        }
        if (this.staticIdMap.containsKey(string)) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_STATIC_ALREADY_DEFINED, string);
        }
        this.getParser().putControlSequence(new TextualContentCommand("@sf@id@" + RomanNumeral.romannumeral(n), string));
        FlowFrameData flowFrameData = new FlowFrameData(FlowFrameType.STATIC, string, n, bl, teXDimension, teXDimension2, teXDimension3, teXDimension4);
        this.staticFrames.add(flowFrameData);
        this.staticIdMap.put(string, n);
        this.listener.stepcounter("maxstatic");
        return flowFrameData;
    }

    public FlowFrameData getStaticFrame(String string) {
        Integer n = this.staticIdMap.get(string);
        if (n == null) {
            return null;
        }
        return this.staticFrames.get(n);
    }

    public FlowFrameData getStaticFrame(int n) {
        return this.staticFrames.get(n);
    }

    public void setStaticFrameLabel(int n, String string) throws TeXSyntaxException {
        FlowFrameData flowFrameData = this.getStaticFrame(n);
        if (flowFrameData == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_STATIC_ID_NOT_DEFINED, n);
        }
        this.setFrameLabel(flowFrameData, string);
    }

    public int getStaticFrameId(String string) throws TeXSyntaxException {
        Integer n = this.staticIdMap.get(string);
        if (n == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_STATIC_LABEL_NOT_DEFINED, string);
        }
        return n;
    }

    public FlowFrameData newDynamicFrame(String string, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4) throws TeXSyntaxException {
        int n = this.dynamicFrames.size();
        if (string == null) {
            string = "" + n;
        }
        if (this.dynamicIdMap.containsKey(string)) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_DYNAMIC_ALREADY_DEFINED, string);
        }
        this.getParser().putControlSequence(new TextualContentCommand("@df@id@" + RomanNumeral.romannumeral(n), string));
        FlowFrameData flowFrameData = new FlowFrameData(FlowFrameType.DYNAMIC, string, n, bl, teXDimension, teXDimension2, teXDimension3, teXDimension4);
        this.dynamicFrames.add(flowFrameData);
        this.dynamicIdMap.put(string, n);
        this.listener.stepcounter("maxdynamic");
        return flowFrameData;
    }

    public FlowFrameData getDynamicFrame(String string) {
        Integer n = this.dynamicIdMap.get(string);
        if (n == null) {
            return null;
        }
        return this.dynamicFrames.get(n);
    }

    public FlowFrameData getDynamicFrame(int n) {
        return this.dynamicFrames.get(n);
    }

    public void setDynamicFrameLabel(int n, String string) throws TeXSyntaxException {
        FlowFrameData flowFrameData = this.getDynamicFrame(n);
        if (flowFrameData == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_DYNAMIC_ID_NOT_DEFINED, n);
        }
        this.setFrameLabel(flowFrameData, string);
    }

    public int getDynamicFrameId(String string) throws TeXSyntaxException {
        Integer n = this.dynamicIdMap.get(string);
        if (n == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_DYNAMIC_LABEL_NOT_DEFINED, string);
        }
        return n;
    }

    public FlowFrameData getFrame(FlowFrameType flowFrameType, String string) throws TeXSyntaxException {
        FlowFrameData flowFrameData = null;
        switch (flowFrameType) {
            case STATIC: {
                flowFrameData = this.getStaticFrame(string);
                break;
            }
            case DYNAMIC: {
                flowFrameData = this.getDynamicFrame(string);
                break;
            }
            case FLOW: {
                flowFrameData = this.getFlowFrame(string);
            }
        }
        if (flowFrameData == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_LABEL_NOT_DEFINED, new Object[]{string, flowFrameType});
        }
        return flowFrameData;
    }

    public FlowFrameData getFrame(FlowFrameType flowFrameType, int n) throws TeXSyntaxException {
        FlowFrameData flowFrameData = null;
        switch (flowFrameType) {
            case STATIC: {
                flowFrameData = this.getStaticFrame(n);
                break;
            }
            case DYNAMIC: {
                flowFrameData = this.getDynamicFrame(n);
                break;
            }
            case FLOW: {
                flowFrameData = this.getFlowFrame(n);
            }
        }
        if (flowFrameData == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_ID_NOT_DEFINED, new Object[]{n, flowFrameType});
        }
        return flowFrameData;
    }

    public void setFrameLabel(FlowFrameData flowFrameData, String string) throws TeXSyntaxException {
        switch (flowFrameData.getType()) {
            case STATIC: {
                Integer n = this.staticIdMap.remove(flowFrameData.getLabel());
                flowFrameData.setLabel(string);
                this.staticIdMap.put(flowFrameData.getLabel(), n);
                this.getParser().putControlSequence(new TextualContentCommand("@sf@id@" + RomanNumeral.romannumeral(n), string));
                break;
            }
            case DYNAMIC: {
                Integer n = this.dynamicIdMap.remove(flowFrameData.getLabel());
                flowFrameData.setLabel(string);
                this.dynamicIdMap.put(flowFrameData.getLabel(), n);
                this.getParser().putControlSequence(new TextualContentCommand("@df@id@" + RomanNumeral.romannumeral(n), string));
                break;
            }
            case FLOW: {
                Integer n = this.flowIdMap.remove(flowFrameData.getLabel());
                flowFrameData.setLabel(string);
                this.flowIdMap.put(flowFrameData.getLabel(), n);
                this.getParser().putControlSequence(new TextualContentCommand("@col@id@" + RomanNumeral.romannumeral(n), string));
            }
        }
    }

    public int getMaxFlowFrames() {
        return this.flowFrames.size();
    }

    public int getMaxStaticFrames() {
        return this.staticFrames.size();
    }

    public int getMaxDynamicFrames() {
        return this.dynamicFrames.size();
    }

    public Color getColor(TeXObject teXObject) throws IOException {
        Object object;
        TeXObjectList teXObjectList;
        TeXParser teXParser = this.getParser();
        String string = TeXParserUtils.popOptLabelString(teXParser, teXObjectList = TeXParserUtils.toList(teXObject, teXParser));
        if (string == null) {
            string = "named";
            object = this.colorSty.getDefinedColor(teXObjectList.toString(teXParser).trim());
            if (object != null) {
                return object;
            }
        } else {
            string = string.trim();
        }
        object = TeXParserUtils.popLabelString(teXParser, teXObjectList).trim();
        return this.colorSty.getColor(teXParser, string, (String)object);
    }

    public Enumeration<FlowFrameData> getFlowElements() {
        return this.flowFrames.elements();
    }

    public Enumeration<FlowFrameData> getStaticElements() {
        return this.staticFrames.elements();
    }

    public Enumeration<FlowFrameData> getDynamicElements() {
        return this.dynamicFrames.elements();
    }

    @Override
    public void documentBegun(BeginDocumentEvent beginDocumentEvent) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)this.listener;
        if (!this.staticFrames.isEmpty() || !this.dynamicFrames.isEmpty()) {
            l2HConverter.write("<style>");
            for (FlowFrameData flowFrameData : this.staticFrames) {
                flowFrameData.writeCss(l2HConverter);
            }
            for (FlowFrameData flowFrameData : this.dynamicFrames) {
                flowFrameData.writeCss(l2HConverter);
            }
            l2HConverter.write("</style>");
        }
    }
}

