param(
    [string]$compiler = "68k",
    [string]$workspace,
    [string]$file
)

switch ($compiler) {
    "68k" { $image = "sacredbanana/amiga-compiler:m68k-amigaos"; break }
    "ppc-amigaos" { $image = "sacredbanana/amiga-compiler:ppc-amigaos"; break }
    "ppc-morphos" { $image = "sacredbanana/amiga-compiler:ppc-morphos"; break }
    default { Write-Error "Unknown compiler selection: $compiler"; exit 2 }
}

if (-not (Test-Path -Path $workspace)) {
    Write-Error "Workspace folder not found: $workspace"
    exit 3
}

if ([string]::IsNullOrEmpty($file)) {
    Write-Error "No file provided. Open the file you want to compile and re-run the task."
    exit 4
}

$outBase = [System.IO.Path]::GetFileNameWithoutExtension($file)
Write-Host "Using image: $image"
Write-Host "Compiling $file -> $outBase"

$dockerArgs = @(
    'run', '--rm',
    '-v', "$workspace:/opt/project",
    '-w', '/opt/project',
    $image,
    '/bin/sh', '-lc', "gcc -g '$file' -o '$outBase'"
)

Write-Host "Running: docker $($dockerArgs -join ' ')"
try {
    $p = Start-Process -FilePath "docker" -ArgumentList $dockerArgs -NoNewWindow -Wait -PassThru
    if ($p.ExitCode -ne 0) { exit $p.ExitCode }
} catch {
    Write-Error "Failed to invoke docker. Ensure Docker Desktop (or another Docker engine) is running and 'docker' is on PATH."
    exit 5
}

Write-Host "Compilation finished. Output binary (if successful) is at: $workspace\$outBase"
