$settingsPath = Join-Path $PSScriptRoot 'settings.json'
if (-not (Test-Path $settingsPath)) {
    Write-Host "Settings file not found: $settingsPath"
    exit 1
}

$raw = Get-Content -Raw -Path $settingsPath
try {
    $json = $raw | ConvertFrom-Json -ErrorAction Stop
} catch {
    Write-Host "Failed to parse settings.json: $_"
    exit 2
}

$runKey = 'emeraldwalk.runonsave'
$backupKey = 'emeraldwalk.runonsave_disabled_backup'

if ($json.PSObject.Properties.Name -contains $runKey) {
    $json | Add-Member -NotePropertyName $backupKey -NotePropertyValue ($json.$runKey) -Force
    $json.PSObject.Properties.Remove($runKey)
    $json | ConvertTo-Json -Depth 10 | Out-File -Encoding utf8 $settingsPath
    Write-Host "Auto-compile disabled. To re-enable, run this toggle again."
    exit 0
} elseif ($json.PSObject.Properties.Name -contains $backupKey) {
    $json | Add-Member -NotePropertyName $runKey -NotePropertyValue ($json.$backupKey) -Force
    $json.PSObject.Properties.Remove($backupKey)
    $json | ConvertTo-Json -Depth 10 | Out-File -Encoding utf8 $settingsPath
    Write-Host "Auto-compile enabled."
    exit 0
} else {
    $image = 'sacredbanana/amiga-compiler:m68k-amigaos'
    if ($json.PSObject.Properties.Name -contains 'amiga.compilerImage') { $image = $json.'amiga.compilerImage' }
    $runObj = @{ commands = @( @{ match = '\\.c$'; cmd = "${workspaceFolder}\\compile.bat '$image' '${file}'" } ) }
    $json | Add-Member -NotePropertyName $runKey -NotePropertyValue $runObj -Force
    $json | ConvertTo-Json -Depth 10 | Out-File -Encoding utf8 $settingsPath
    Write-Host "Auto-compile enabled with default settings."
    exit 0
}
