/*  Grafx2 - The Ultimate 256-color bitmap paint program

    Copyright 2008 Yves Rizoud
    Copyright 2007 Adrien Destugues
    Copyright 1996-2001 Sunset Design (Guillaume Dorme & Karl Maritaud)

    Grafx2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; version 2
    of the License.

    Grafx2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Grafx2; if not, see <http://www.gnu.org/licenses/> or
    write to the Free Software Foundation, Inc.,
    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _STRUCT_H_
#define _STRUCT_H_

#include <stdint.h>
#include "const.h"

// Dclaration des types de base /////////////////////////////////////////////

typedef uint8_t  byte;
typedef uint16_t word;
typedef uint32_t  dword;

typedef void (* fonction_action)    (void);
typedef void (* fonction_afficheur) (word,word,byte);
typedef byte (* fonction_lecteur)   (word,word);
typedef void (* fonction_effaceur)  (byte);
typedef void (* fonction_display)   (word,word,word);
typedef byte (* fonction_effet)     (word,word,byte);
typedef void (* fonction_block)     (word,word,word,word,byte);
typedef byte (* fonction_test_sign) (void);
typedef void (* fonction_Ligne_XOR) (word,word,word);
typedef void (* fonction_display_brush_Color) (word,word,word,word,word,word,byte,word);
typedef void (* fonction_display_brush_Mono)  (word,word,word,word,word,word,byte,byte,word);
typedef void (* fonction_degrade)   (long,short,short);
typedef void (* fonction_remap)     (word,word,word,word,byte *);
typedef void (* fonction_procsline) (word,word,word,byte *);
typedef void (* fonction_display_zoom) (word,word,word,byte *);
typedef void (* fonction_display_brush_Color_zoom) (word,word,word,word,word,word,byte,word,byte *);
typedef void (* fonction_display_brush_Mono_zoom)  (word,word,word,word,word,word,byte,byte,word,byte *);

struct Composantes
{
  byte R;
  byte V;
  byte B;
};
typedef struct Composantes T_Palette[256];



struct Fenetre_Bouton_normal
{
  short Numero;
  word Pos_X;
  word Pos_Y;
  word Largeur;
  word Hauteur;
  byte Clickable;
  word Raccourci;
  struct Fenetre_Bouton_normal * Next;
};

struct Fenetre_Bouton_palette
{
  short Numero;
  word Pos_X;
  word Pos_Y;
  struct Fenetre_Bouton_palette * Next;
};

struct Fenetre_Bouton_scroller
{
  short Numero;
  word Pos_X;
  word Pos_Y;
  word Hauteur;
  word Nb_elements;
  word Nb_visibles;
  word Position;
  word Hauteur_curseur;
  struct Fenetre_Bouton_scroller * Next;
};

struct Fenetre_Bouton_special
{
  short Numero;
  word Pos_X;
  word Pos_Y;
  word Largeur;
  word Hauteur;
  struct Fenetre_Bouton_special * Next;
};


struct T_Drive
{
  char Lettre;
  byte Type; // 0: Diskette 3" / 1: Diskette 5" / 2: HDD / 3: CD-ROM / 4: Logique
  word Touche;
  char Chemin[4]; // Reserv pour "x:\", ou "/", ou "~"
};


// Dclaration du type d'lment qu'on va mmoriser dans la liste:
struct Element_de_liste_de_fileselect
{
  char NomAbrege[13]; // Le nom tel qu'affich dans le fileselector
  char NomComplet[256]; // Le nom du fichier ou du rpertoire
  byte Type;    // Type d'lment : 0 = Fichier, 1 = Rpertoire

  // donnes de chanage de la liste
  struct Element_de_liste_de_fileselect * Suivant;
  struct Element_de_liste_de_fileselect * Precedent;
};



// Dclaration d'une section d'aide:
struct Section_d_aide
{
  const char ** Table_aide; // Pointeur sur le dbut de la table d'aide
  word Nombre_de_lignes;
};

// Dclaration d'une info sur un dgrad
struct T_Degrade_Tableau
{
  byte Debut;     // Premire couleur du dgrad
  byte Fin;       // Dernire couleur du dgrad
  dword Inverse;   // "Le dgrad va de Fin  Debut" //INT
  dword Melange;   // Valeur de mlange du dgrad (0-255) //LONG
  dword Technique; // Technique  utiliser (0-2) //INT
} __attribute__((__packed__));

// Dclaration d'une info de shade
struct T_Shade
{
  word Liste[512]; // Liste de couleurs
  byte Pas;        // Pas d'incrmentation/dcrmentation
  byte Mode;       // Mode d'utilisation (Normal/Boucle/Non-satur)
};



// Structure des donnes dans le fichier de config.

struct Config_Mode_video
{
  byte Etat;
  word Largeur;
  word Hauteur;
} __attribute__((__packed__));

struct Config_Header
{
  char Signature[3];
  byte Version1;
  byte Version2;
  byte Beta1;
  byte Beta2;
} __attribute__((__packed__));

struct Config_Chunk
{
  byte Numero;
  word Taille;
} __attribute__((__packed__));

struct Config_Infos_touche
{
  word Numero;
  word Touche;
  word Touche2;
} __attribute__((__packed__));



// Structures utilises pour les descriptions de pages et de liste de pages.
// Lorsqu'on grera les animations, il faudra aussi des listes de listes de
// pages.

// Ces structures sont manipules  travers des fonctions de gestion du
// backup dans "graph.c".

typedef struct
{
  byte *    Image;   // Bitmap de l'image
  int       Largeur; // Largeur du bitmap
  int       Hauteur; // Hauteur du bitmap
  T_Palette Palette; // Palette de l'image

  char      Commentaire[TAILLE_COMMENTAIRE+1]; // Commentaire de l'image

  char      Repertoire_fichier[TAILLE_CHEMIN_FICHIER]; // |_ Nom complet =
  char      Nom_fichier[TAILLE_CHEMIN_FICHIER];        // |  Repertoire_fichier+"\"+Nom_fichier
  byte      Format_fichier;          // Format auquel il faut lire et crire le fichier

/*
  short     Decalage_X; // Dcalage en X de l'cran par rapport au dbut de l'image
  short     Decalage_Y; // Dcalage en Y de l'cran par rapport au dbut de l'image
  short     Ancien_Decalage_X; // Le mme avant le passage en mode loupe
  short     Ancien_Decalage_Y; // Le mme avant le passage en mode loupe

  short     Split; // Position en X du bord gauche du split de la loupe
  short     X_Zoom; // (Menu_Facteur_X) + Position en X du bord droit du split de la loupe
  float     Proportion_split; // Proportion de la zone non-zoome par rapport  l'cran

  byte      Loupe_Mode;       // On est en mode loupe
  word      Loupe_Facteur;    // Facteur de zoom
  word      Loupe_Hauteur;    // Largeur de la fentre de zoom
  word      Loupe_Largeur;    // Hauteur de la fentre de zoom
  short     Loupe_Decalage_X; // Decalage horizontal de la fentre de zoom
  short     Loupe_Decalage_Y; // Decalage vertical   de la fentre de zoom
*/
} S_Page;

typedef struct
{
  int      Taille_liste;      // Nb de S_Page dans le vecteur "Pages"
  int      Nb_pages_allouees; // Nb de S_Page dsignant des pages alloues
  S_Page * Pages;             // Liste de pages (Taille_liste lments)
} S_Liste_de_pages;



#endif
