### 1010 - Parameter Property Updated

**Description**: Checks whether an existing property value is updated from a cmd's parameter. 

**Analysis**: Not all configured properties updated from a cmd's parameter are considered breaking changes. The properties listed in PARA_PROPERTY_UPDATE_BREAK_LIST below are thought to influence or interrupt current workflow and be breaking changes. 
* PARA_PROPERTY_UPDATE_BREAK_LIST = ["default", "aaz_default"]

**Example**: In new cli version, `default` is being updated from `3600` to `7200` for `--timeout` of cmd `az monitor account wait` which may cause inconsistency in users' default behaviour.

#### Before
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor account": {
                  "name": "monitor account",
                  "commands": {
                      "monitor account wait": {
                          "name": "monitor account wait",
                          "is_aaz": true,
                          "parameters": [
                              {
                                  "name": "timeout",
                                  "options": ["--timeout"],
                                  "default": 3600
                              }
                              ...
                              ...
                          ]
                      }
                  }
              }
          }
      },
    ...
  }
}
```

#### After
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor account": {
                  "name": "monitor account",
                  "commands": {
                      "monitor account wait": {
                          "name": "monitor account wait",
                          "is_aaz": true,
                          "parameters": [
                              {
                                  "name": "timeout",
                                  "options": ["--timeout"],
                                  "default": 7200
                              }
                              ...
                              ...
                          ]
                      }
                  }
              }
          }
      },
    ...
  }
}
```
