{- Build man pages.
 -
 - Copyright 2016-2025 Joey Hess <id@joeyh.name>
 -
 - Licensed under the GNU AGPL version 3 or higher.
 -}

{-# OPTIONS_GHC -fno-warn-tabs #-}

module Build.Mans where

import Utility.Process
import System.Directory
import System.FilePath
import Data.List
import Control.Monad
import System.Exit
import Data.Maybe
import Utility.Exception

buildMansOrWarn :: IO ()
buildMansOrWarn = do
	mans <- buildMans
	when (any isNothing mans) $
		error "mdwn2man failed"

buildMans :: IO [Maybe FilePath]
buildMans = do
	mansrc <- filter isManSrc <$> getDirectoryContents "doc"
	createDirectoryIfMissing False "man"
	forM mansrc $ \f -> do
		let src = "doc" </> f
		let dest = srcToDest src
		srcm <- getModificationTime src
		destm <- catchMaybeIO $ getModificationTime dest
		if (Just srcm > destm)
			then do
				(Nothing, Nothing, Nothing, pid) <- createProcess $ shell $ unwords $
					-- Run with perl because in some
					-- cases it may not be executable.
					[ "perl"
					, "./Build/mdwn2man"
					, progName src
					, "1"
					, src
					, "> " ++ dest
					]
				r <- waitForProcess pid
				if r == ExitSuccess
					then return (Just dest)
					else return Nothing
			else return (Just dest)

isManSrc :: FilePath -> Bool
isManSrc s
	| not (takeExtension s == ".mdwn") = False
	| otherwise = "git-annex" `isPrefixOf` f || "git-remote-" `isPrefixOf` f
  where
	f = takeFileName s

srcToDest :: FilePath -> FilePath
srcToDest s = "man" </> progName s ++ ".1"

progName :: FilePath -> FilePath
progName = dropExtension . takeFileName
