//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// ReservationsServer is a fake server for instances of the armbilling.ReservationsClient type.
type ReservationsServer struct {
	// NewListByBillingAccountPager is the fake for method ReservationsClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountName string, options *armbilling.ReservationsClientListByBillingAccountOptions) (resp azfake.PagerResponder[armbilling.ReservationsClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method ReservationsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, options *armbilling.ReservationsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.ReservationsClientListByBillingProfileResponse])
}

// NewReservationsServerTransport creates a new instance of ReservationsServerTransport with the provided implementation.
// The returned ReservationsServerTransport instance is connected to an instance of armbilling.ReservationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReservationsServerTransport(srv *ReservationsServer) *ReservationsServerTransport {
	return &ReservationsServerTransport{
		srv:                          srv,
		newListByBillingAccountPager: newTracker[azfake.PagerResponder[armbilling.ReservationsClientListByBillingAccountResponse]](),
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armbilling.ReservationsClientListByBillingProfileResponse]](),
	}
}

// ReservationsServerTransport connects instances of armbilling.ReservationsClient to instances of ReservationsServer.
// Don't use this type directly, use NewReservationsServerTransport instead.
type ReservationsServerTransport struct {
	srv                          *ReservationsServer
	newListByBillingAccountPager *tracker[azfake.PagerResponder[armbilling.ReservationsClientListByBillingAccountResponse]]
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armbilling.ReservationsClientListByBillingProfileResponse]]
}

// Do implements the policy.Transporter interface for ReservationsServerTransport.
func (r *ReservationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReservationsClient.NewListByBillingAccountPager":
		resp, err = r.dispatchNewListByBillingAccountPager(req)
	case "ReservationsClient.NewListByBillingProfilePager":
		resp, err = r.dispatchNewListByBillingProfilePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReservationsServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := r.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reservations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		refreshSummaryUnescaped, err := url.QueryUnescape(qp.Get("refreshSummary"))
		if err != nil {
			return nil, err
		}
		refreshSummaryParam := getOptional(refreshSummaryUnescaped)
		selectedStateUnescaped, err := url.QueryUnescape(qp.Get("selectedState"))
		if err != nil {
			return nil, err
		}
		selectedStateParam := getOptional(selectedStateUnescaped)
		var options *armbilling.ReservationsClientListByBillingAccountOptions
		if filterParam != nil || orderbyParam != nil || refreshSummaryParam != nil || selectedStateParam != nil {
			options = &armbilling.ReservationsClientListByBillingAccountOptions{
				Filter:         filterParam,
				Orderby:        orderbyParam,
				RefreshSummary: refreshSummaryParam,
				SelectedState:  selectedStateParam,
			}
		}
		resp := r.srv.NewListByBillingAccountPager(billingAccountNameParam, options)
		newListByBillingAccountPager = &resp
		r.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armbilling.ReservationsClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		r.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (r *ReservationsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := r.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reservations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		refreshSummaryUnescaped, err := url.QueryUnescape(qp.Get("refreshSummary"))
		if err != nil {
			return nil, err
		}
		refreshSummaryParam := getOptional(refreshSummaryUnescaped)
		selectedStateUnescaped, err := url.QueryUnescape(qp.Get("selectedState"))
		if err != nil {
			return nil, err
		}
		selectedStateParam := getOptional(selectedStateUnescaped)
		var options *armbilling.ReservationsClientListByBillingProfileOptions
		if filterParam != nil || orderbyParam != nil || refreshSummaryParam != nil || selectedStateParam != nil {
			options = &armbilling.ReservationsClientListByBillingProfileOptions{
				Filter:         filterParam,
				Orderby:        orderbyParam,
				RefreshSummary: refreshSummaryParam,
				SelectedState:  selectedStateParam,
			}
		}
		resp := r.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, options)
		newListByBillingProfilePager = &resp
		r.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.ReservationsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		r.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}
