//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdigitaltwins_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/digitaltwins/armdigitaltwins"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsList_example.json
func ExampleTimeSeriesDatabaseConnectionsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTimeSeriesDatabaseConnectionsClient().NewListPager("resRg", "myDigitalTwinsService", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TimeSeriesDatabaseConnectionListResult = armdigitaltwins.TimeSeriesDatabaseConnectionListResult{
		// 	Value: []*armdigitaltwins.TimeSeriesDatabaseConnection{
		// 		{
		// 			Name: to.Ptr("myConnection"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/timeSeriesDatabaseConnections"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/timeSeriesDatabaseConnections/myConnection"),
		// 			Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
		// 				ConnectionType: to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.TimeSeriesDatabaseConnectionStateSucceeded),
		// 				AdxDatabaseName: to.Ptr("myDatabase"),
		// 				AdxEndpointURI: to.Ptr("https://mycluster.kusto.windows.net"),
		// 				AdxResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
		// 				AdxTableName: to.Ptr("myTable"),
		// 				EventHubEndpointURI: to.Ptr("sb://myeh.servicebus.windows.net/"),
		// 				EventHubEntityPath: to.Ptr("myeh"),
		// 				EventHubNamespaceResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsGet_example.json
func ExampleTimeSeriesDatabaseConnectionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTimeSeriesDatabaseConnectionsClient().Get(ctx, "resRg", "myDigitalTwinsService", "myConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TimeSeriesDatabaseConnection = armdigitaltwins.TimeSeriesDatabaseConnection{
	// 	Name: to.Ptr("myConnection"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/timeSeriesDatabaseConnections"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/timeSeriesDatabaseConnections/myConnection"),
	// 	Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
	// 		ConnectionType: to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.TimeSeriesDatabaseConnectionStateSucceeded),
	// 		AdxDatabaseName: to.Ptr("myDatabase"),
	// 		AdxEndpointURI: to.Ptr("https://mycluster.kusto.windows.net"),
	// 		AdxResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
	// 		AdxTableName: to.Ptr("myTable"),
	// 		EventHubConsumerGroup: to.Ptr("$Default"),
	// 		EventHubEndpointURI: to.Ptr("sb://myeh.servicebus.windows.net/"),
	// 		EventHubEntityPath: to.Ptr("myeh"),
	// 		EventHubNamespaceResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsPut_WithUserIdentity_example.json
func ExampleTimeSeriesDatabaseConnectionsClient_BeginCreateOrUpdate_createOrReplaceATimeSeriesDatabaseConnectionForADigitalTwinsInstanceWithUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTimeSeriesDatabaseConnectionsClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", "myConnection", armdigitaltwins.TimeSeriesDatabaseConnection{
		Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
			ConnectionType: to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
			Identity: &armdigitaltwins.ManagedIdentityReference{
				Type:                 to.Ptr(armdigitaltwins.IdentityTypeUserAssigned),
				UserAssignedIdentity: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity"),
			},
			AdxDatabaseName:             to.Ptr("myDatabase"),
			AdxEndpointURI:              to.Ptr("https://mycluster.kusto.windows.net"),
			AdxResourceID:               to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
			AdxTableName:                to.Ptr("myTable"),
			EventHubEndpointURI:         to.Ptr("sb://myeh.servicebus.windows.net/"),
			EventHubEntityPath:          to.Ptr("myeh"),
			EventHubNamespaceResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TimeSeriesDatabaseConnection = armdigitaltwins.TimeSeriesDatabaseConnection{
	// 	Name: to.Ptr("myConnection"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/timeSeriesDatabaseConnections"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/timeSeriesDatabaseConnections/myConnection"),
	// 	Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
	// 		ConnectionType: to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
	// 		Identity: &armdigitaltwins.ManagedIdentityReference{
	// 			Type: to.Ptr(armdigitaltwins.IdentityTypeUserAssigned),
	// 			UserAssignedIdentity: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity"),
	// 		},
	// 		ProvisioningState: to.Ptr(armdigitaltwins.TimeSeriesDatabaseConnectionStateSucceeded),
	// 		AdxDatabaseName: to.Ptr("myDatabase"),
	// 		AdxEndpointURI: to.Ptr("https://mycluster.kusto.windows.net"),
	// 		AdxResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
	// 		AdxTableName: to.Ptr("myTable"),
	// 		EventHubConsumerGroup: to.Ptr("$Default"),
	// 		EventHubEndpointURI: to.Ptr("sb://myeh.servicebus.windows.net/"),
	// 		EventHubEntityPath: to.Ptr("myeh"),
	// 		EventHubNamespaceResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
	// 		RecordPropertyAndItemRemovals: to.Ptr(armdigitaltwins.RecordPropertyAndItemRemovalsFalse),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsPut_example.json
func ExampleTimeSeriesDatabaseConnectionsClient_BeginCreateOrUpdate_createOrReplaceATimeSeriesDatabaseConnectionForADigitalTwinsInstance() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTimeSeriesDatabaseConnectionsClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", "myConnection", armdigitaltwins.TimeSeriesDatabaseConnection{
		Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
			ConnectionType:                          to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
			AdxDatabaseName:                         to.Ptr("myDatabase"),
			AdxEndpointURI:                          to.Ptr("https://mycluster.kusto.windows.net"),
			AdxRelationshipLifecycleEventsTableName: to.Ptr("myRelationshipLifecycleEventsTable"),
			AdxResourceID:                           to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
			AdxTableName:                            to.Ptr("myPropertyUpdatesTable"),
			AdxTwinLifecycleEventsTableName:         to.Ptr("myTwinLifecycleEventsTable"),
			EventHubEndpointURI:                     to.Ptr("sb://myeh.servicebus.windows.net/"),
			EventHubEntityPath:                      to.Ptr("myeh"),
			EventHubNamespaceResourceID:             to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
			RecordPropertyAndItemRemovals:           to.Ptr(armdigitaltwins.RecordPropertyAndItemRemovalsTrue),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TimeSeriesDatabaseConnection = armdigitaltwins.TimeSeriesDatabaseConnection{
	// 	Name: to.Ptr("myConnection"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/timeSeriesDatabaseConnections"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/timeSeriesDatabaseConnections/myConnection"),
	// 	Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
	// 		ConnectionType: to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.TimeSeriesDatabaseConnectionStateSucceeded),
	// 		AdxDatabaseName: to.Ptr("myDatabase"),
	// 		AdxEndpointURI: to.Ptr("https://mycluster.kusto.windows.net"),
	// 		AdxRelationshipLifecycleEventsTableName: to.Ptr("myRelationshipLifecycleEventsTable"),
	// 		AdxResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
	// 		AdxTableName: to.Ptr("myPropertyUpdatesTable"),
	// 		AdxTwinLifecycleEventsTableName: to.Ptr("myTwinLifecycleEventsTable"),
	// 		EventHubConsumerGroup: to.Ptr("$Default"),
	// 		EventHubEndpointURI: to.Ptr("sb://myeh.servicebus.windows.net/"),
	// 		EventHubEntityPath: to.Ptr("myeh"),
	// 		EventHubNamespaceResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
	// 		RecordPropertyAndItemRemovals: to.Ptr(armdigitaltwins.RecordPropertyAndItemRemovalsTrue),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsDelete_example.json
func ExampleTimeSeriesDatabaseConnectionsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTimeSeriesDatabaseConnectionsClient().BeginDelete(ctx, "resRg", "myDigitalTwinsService", "myConnection", &armdigitaltwins.TimeSeriesDatabaseConnectionsClientBeginDeleteOptions{CleanupConnectionArtifacts: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TimeSeriesDatabaseConnection = armdigitaltwins.TimeSeriesDatabaseConnection{
	// 	Name: to.Ptr("myConnection"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/timeSeriesDatabaseConnections"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/timeSeriesDatabaseConnections/myConnection"),
	// 	Properties: &armdigitaltwins.AzureDataExplorerConnectionProperties{
	// 		ConnectionType: to.Ptr(armdigitaltwins.ConnectionTypeAzureDataExplorer),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.TimeSeriesDatabaseConnectionStateSucceeded),
	// 		AdxDatabaseName: to.Ptr("myDatabase"),
	// 		AdxEndpointURI: to.Ptr("https://mycluster.kusto.windows.net"),
	// 		AdxResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
	// 		EventHubConsumerGroup: to.Ptr("$Default"),
	// 		EventHubEndpointURI: to.Ptr("sb://myeh.servicebus.windows.net/"),
	// 		EventHubEntityPath: to.Ptr("myeh"),
	// 		EventHubNamespaceResourceID: to.Ptr("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
	// 	},
	// }
}
