//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ManagementGroupsServer is a fake server for instances of the armoperationalinsights.ManagementGroupsClient type.
type ManagementGroupsServer struct {
	// NewListPager is the fake for method ManagementGroupsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, workspaceName string, options *armoperationalinsights.ManagementGroupsClientListOptions) (resp azfake.PagerResponder[armoperationalinsights.ManagementGroupsClientListResponse])
}

// NewManagementGroupsServerTransport creates a new instance of ManagementGroupsServerTransport with the provided implementation.
// The returned ManagementGroupsServerTransport instance is connected to an instance of armoperationalinsights.ManagementGroupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagementGroupsServerTransport(srv *ManagementGroupsServer) *ManagementGroupsServerTransport {
	return &ManagementGroupsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armoperationalinsights.ManagementGroupsClientListResponse]](),
	}
}

// ManagementGroupsServerTransport connects instances of armoperationalinsights.ManagementGroupsClient to instances of ManagementGroupsServer.
// Don't use this type directly, use NewManagementGroupsServerTransport instead.
type ManagementGroupsServerTransport struct {
	srv          *ManagementGroupsServer
	newListPager *tracker[azfake.PagerResponder[armoperationalinsights.ManagementGroupsClientListResponse]]
}

// Do implements the policy.Transporter interface for ManagementGroupsServerTransport.
func (m *ManagementGroupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagementGroupsClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagementGroupsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListPager(resourceGroupNameParam, workspaceNameParam, nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}
