/**
 * A module to expose the NumPy C SIMD vectorization interface "NPYV" for testing purposes.
 *
 * Please keep this module independent from other c-extension modules,
 * since NPYV intrinsics may be involved in their functionality,
 * which increases the degree of complexity in tracking and detecting errors.
 *
 * TODO: Add an independent sphinx doc.
 *
 * Please add any new NPYV intrinsics in '_simd.dispatch.c.src'.
 */
#ifndef _SIMD_SIMD_H_
#define _SIMD_SIMD_H_

#include <Python.h>
#include "numpy/npy_common.h"
#include "npy_cpu_features.h"
#include "npy_cpu_dispatch.h"
#include "numpy/npy_cpu.h"

// autogenerated, required for CPU dispatch macros
#include "_simd.dispatch.h"
/**
 * Create a new module for each required optimization which contains all NPYV intrinsics,
 *
 * If required optimization is not supported by NPYV, the module will still provides
 * access to NPYV constants NPY_SIMD, NPY_SIMD_F64, and NPY_SIMD_WIDTH but without
 * any intrinsics.
 */
NPY_CPU_DISPATCH_DECLARE(NPY_VISIBILITY_HIDDEN PyObject *simd_create_module, (void))
#endif // _SIMD_SIMD_H_
