/*
  Copyright 2020 Statoil ASA.

  This file is part of the Open Porous Media project (OPM).

  OPM is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  OPM is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OPM.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <fmt/format.h>
#include <opm/common/OpmLog/InfoLogger.hpp>
#include <opm/common/OpmLog/OpmLog.hpp>

namespace Opm {

InfoLogger::InfoLogger(const std::string& context_arg, std::size_t info_limit_arg):
    context(context_arg),
    info_limit(info_limit_arg)
{
    this->log_function = &OpmLog::info;
}


void InfoLogger::operator()(const std::string& msg) {
    if (this->info_count == this->info_limit) {
        OpmLog::info(fmt::format("Reporting limit reached for {} - see PRT file for additional messages", this->context));
        this->log_function = &OpmLog::note;
    }
    this->log_function(msg);
    this->info_count += 1;
}

}
