# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mysqlflexibleservers.aio import MySQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMySQLManagementBackupAndExportOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MySQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backup_and_export_begin_create(self, resource_group):
        response = await (
            await self.client.backup_and_export.begin_create(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={
                    "backupSettings": {"backupName": "str", "backupFormat": "str"},
                    "targetDetails": "backup_store_details",
                },
                api_version="2024-12-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_backup_and_export_validate_backup(self, resource_group):
        response = await self.client.backup_and_export.validate_backup(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2024-12-30",
        )

        # please add some check logic here by yourself
        # ...
