# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AssetConversionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the conversion. Terminal states are 'Cancelled', 'Failed', and 'Succeeded'.
    """

    NOT_STARTED = "NotStarted"  #: The conversion was created but hasn't started.
    RUNNING = "Running"  #: The conversion is running.
    CANCELLED = "Cancelled"  #: The conversion was cancelled. This is a terminal state.
    FAILED = "Failed"  #: The conversion has failed. Check the 'error' field for more details. This is a terminal state.
    SUCCEEDED = "Succeeded"  #: The conversion has succeeded. Check the 'output' field for output asset location. This is a terminal state.

class RenderingSessionSize(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The size of the server used for the rendering session. The size impacts the number of polygons
    the server can render. Refer to https://docs.microsoft.com/azure/remote-rendering/reference/vm-
    sizes for details.
    """

    STANDARD = "Standard"  #: Standard rendering session size.
    PREMIUM = "Premium"  #: Premium rendering session size.

class RenderingSessionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the rendering session. Terminal states are 'Error', 'Expired', and 'Stopped'.
    """

    ERROR = "Error"  #: The rendering session has encountered an error, and is unusable. This is a terminal state.
    EXPIRED = "Expired"  #: The rendering session enters the 'Expired' state when it has been in the 'Ready' state longer than its lease time. This is a terminal state.
    STARTING = "Starting"  #: The rendering session is starting, but not accepting incoming connections yet.
    READY = "Ready"  #: The rendering session is ready for incoming connections.
    STOPPED = "Stopped"  #: The rendering session has been stopped with the 'Stop Session' operation. This is a terminal state.
