# generated by datamodel-codegen:
#   filename:  api_constrained.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Annotated, List, Optional, Union

from pydantic import AnyUrl, BaseModel, Field, RootModel


class Pet(BaseModel):
    id: Annotated[int, Field(ge=0, le=9223372036854775807)]
    name: Annotated[str, Field(max_length=256)]
    tag: Annotated[Optional[str], Field(max_length=64)] = None


class Pets(RootModel[List[Pet]]):
    root: Annotated[List[Pet], Field(max_length=10, min_length=1)]


class UID(RootModel[int]):
    root: Annotated[int, Field(ge=0)]


class Phone(RootModel[str]):
    root: Annotated[str, Field(min_length=3)]


class FaxItem(RootModel[str]):
    root: Annotated[str, Field(min_length=3)]


class User(BaseModel):
    id: Annotated[int, Field(ge=0)]
    name: Annotated[str, Field(max_length=256)]
    tag: Annotated[Optional[str], Field(max_length=64)] = None
    uid: UID
    phones: Annotated[Optional[List[Phone]], Field(max_length=10)] = None
    fax: Optional[List[FaxItem]] = None
    height: Annotated[Optional[Union[int, float]], Field(ge=1.0, le=300.0)] = None
    weight: Annotated[Optional[Union[float, int]], Field(ge=1.0, le=1000.0)] = None
    age: Annotated[Optional[int], Field(gt=0, le=200)] = None
    rating: Annotated[Optional[float], Field(gt=0.0, le=5.0)] = None


class Users(RootModel[List[User]]):
    root: List[User]


class Id(RootModel[str]):
    root: str


class Rules(RootModel[List[str]]):
    root: List[str]


class Error(BaseModel):
    code: int
    message: str


class Api(BaseModel):
    apiKey: Annotated[
        Optional[str], Field(description='To be used as a dataset parameter value')
    ] = None
    apiVersionNumber: Annotated[
        Optional[str], Field(description='To be used as a version parameter value')
    ] = None
    apiUrl: Annotated[
        Optional[AnyUrl], Field(description="The URL describing the dataset's fields")
    ] = None
    apiDocumentationUrl: Annotated[
        Optional[AnyUrl], Field(description='A URL to the API console for each API')
    ] = None


class Apis(RootModel[List[Api]]):
    root: List[Api]


class Event(BaseModel):
    name: Optional[str] = None


class Result(BaseModel):
    event: Optional[Event] = None
