% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_overwrite_linter.R
\name{object_overwrite_linter}
\alias{object_overwrite_linter}
\title{Block assigning any variables whose name clashes with a \code{base} R function}
\usage{
object_overwrite_linter(
  packages = c("base", "stats", "utils", "tools", "methods", "graphics", "grDevices"),
  allow_names = character()
)
}
\arguments{
\item{packages}{Character vector of packages to search for names that should
be avoided. Defaults to the most common default packages: base, stats,
utils, tools, methods, graphics, and grDevices.}

\item{allow_names}{Character vector of object names to ignore, i.e., which
are allowed to collide with exports from \code{packages}.}
}
\description{
Re-using existing names creates a risk of subtle error best avoided.
Avoiding this practice also encourages using better, more descriptive names.
}
\examples{
# will produce lints
code <- "function(x) {\n  data <- x\n  data\n}"
writeLines(code)
lint(
  text = code,
  linters = object_overwrite_linter()
)

code <- "function(x) {\n  lint <- 'fun'\n  lint\n}"
writeLines(code)
lint(
  text = code,
  linters = object_overwrite_linter(packages = "lintr")
)

# okay
code <- "function(x) {\n  data('mtcars')\n}"
writeLines(code)
lint(
  text = code,
  linters = object_overwrite_linter()
)

code <- "function(x) {\n  data <- x\n  data\n}"
writeLines(code)
lint(
  text = code,
  linters = object_overwrite_linter(packages = "base")
)

# names in function signatures are ignored
lint(
  text = "function(data) data <- subset(data, x > 0)",
  linters = object_overwrite_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#object-names}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=executing_linters]{executing}, \link[=readability_linters]{readability}, \link[=robustness_linters]{robustness}
}
