% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_values.R
\name{generate_pmj02bn_set}
\alias{generate_pmj02bn_set}
\title{Generate 2D Progressive Multi-Jittered (0, 2) (with blue noise) Set}
\usage{
generate_pmj02bn_set(n, seed = 0)
}
\arguments{
\item{n}{The number of 2D values to extract.}

\item{seed}{Default `0`. The random seed.}
}
\value{
An `n` x `2` matrix with all the calculated values from the set.
}
\description{
Generate a set of values from a Progressive Multi-Jittered (0, 2) (with blue noise) set.
}
\examples{
#Generate a 2D sample:
points2d = generate_pmj02bn_set(n=1000)
plot(points2d, xlim=c(0,1),ylim=c(0,1))

#Generate a longer sequence of values from that set
points2d = generate_pmj02bn_set(n=1500)
plot(points2d, xlim=c(0,1),ylim=c(0,1))

#Generate a new set by changing the seed
points2d = generate_pmj02bn_set(n=1500,seed=10)
plot(points2d, xlim=c(0,1),ylim=c(0,1))

#Integrate the value of pi by counting the number of randomly generated points that fall
#within the unit circle.
pointset = generate_pmj02bn_set(10000)

pi_estimate = 4*sum(pointset[,1] * pointset[,1] + pointset[,2] * pointset[,2] < 1)/10000
pi_estimate
}
