% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_types.R
\name{cols}
\alias{cols}
\alias{col_types}
\alias{cols_only}
\alias{col_logical}
\alias{col_integer}
\alias{col_big_integer}
\alias{col_double}
\alias{col_character}
\alias{col_skip}
\alias{col_number}
\alias{col_guess}
\alias{col_factor}
\alias{col_datetime}
\alias{col_date}
\alias{col_time}
\title{Create column specification}
\usage{
cols(..., .default = col_guess(), .delim = NULL)

cols_only(...)

col_logical(...)

col_integer(...)

col_big_integer(...)

col_double(...)

col_character(...)

col_skip(...)

col_number(...)

col_guess(...)

col_factor(levels = NULL, ordered = FALSE, include_na = FALSE, ...)

col_datetime(format = "", ...)

col_date(format = "", ...)

col_time(format = "", ...)
}
\arguments{
\item{...}{Either column objects created by \verb{col_*()}, or their abbreviated
character names (as described in the \code{col_types} argument of
\code{\link[=vroom]{vroom()}}). If you're only overriding a few columns, it's
best to refer to columns by name. If not named, the column types must match
the column names exactly. In \verb{col_*()} functions these are stored in the
object.}

\item{.default}{Any named columns not explicitly overridden in \code{...}
will be read with this column type.}

\item{.delim}{The delimiter to use when parsing. If the \code{delim} argument
used in the call to \code{vroom()} it takes precedence over the one specified in
\code{col_types}.}

\item{levels}{Character vector of the allowed levels. When \code{levels = NULL}
(the default), \code{levels} are discovered from the unique values of \code{x}, in
the order in which they appear in \code{x}.}

\item{ordered}{Is it an ordered factor?}

\item{include_na}{If \code{TRUE} and \code{x} contains at least one \code{NA}, then \code{NA}
is included in the levels of the constructed factor.}

\item{format}{A format specification, as described below. If set to "",
date times are parsed as ISO8601, dates and times used the date and
time formats specified in the \code{\link[readr:locale]{locale()}}.

Unlike \code{\link[=strptime]{strptime()}}, the format specification must match
the complete string.}
}
\description{
\code{cols()} includes all columns in the input data, guessing the column types
as the default. \code{cols_only()} includes only the columns you explicitly
specify, skipping the rest.
}
\details{
The available specifications are: (long names in quotes and string abbreviations in brackets)\tabular{llll}{
   function \tab long name \tab short name \tab description \cr
   \code{col_logical()} \tab "logical" \tab "l" \tab Logical values containing only \code{T}, \code{F}, \code{TRUE} or \code{FALSE}. \cr
   \code{col_integer()} \tab "integer" \tab "i" \tab Integer numbers. \cr
   \code{col_big_integer()} \tab "big_integer" \tab "I" \tab Big Integers (64bit), requires the \code{bit64} package. \cr
   \code{col_double()} \tab "double", "numeric" \tab "d" \tab 64-bit double floating point numbers. \cr
   \code{col_character()} \tab "character" \tab "c" \tab Character string data. \cr
   \code{col_factor(levels, ordered)} \tab "factor" \tab "f" \tab A fixed set of values. \cr
   \code{col_date(format = "")} \tab "date" \tab "D" \tab Calendar dates formatted with the locale's \code{date_format}. \cr
   \code{col_time(format = "")} \tab "time" \tab "t" \tab Times formatted with the locale's \code{time_format}. \cr
   \code{col_datetime(format = "")} \tab "datetime", "POSIXct" \tab "T" \tab ISO8601 date times. \cr
   \code{col_number()} \tab "number" \tab "n" \tab Human readable numbers containing the \code{grouping_mark} \cr
   \code{col_skip()} \tab "skip", "NULL" \tab "_", "-" \tab Skip and don't import this column. \cr
   \code{col_guess()} \tab "guess", "NA" \tab "?" \tab Parse using the "best" guessed type based on the input. \cr
}
}
\examples{
cols(a = col_integer())
cols_only(a = col_integer())

# You can also use the standard abbreviations
cols(a = "i")
cols(a = "i", b = "d", c = "_")

# Or long names (like utils::read.csv)
cols(a = "integer", b = "double", c = "skip")

# You can also use multiple sets of column definitions by combining
# them like so:

t1 <- cols(
  column_one = col_integer(),
  column_two = col_number())

t2 <- cols(
 column_three = col_character())

t3 <- t1
t3$cols <- c(t1$cols, t2$cols)
t3
}
