#ifndef INCLUDED_CRONDATA_
#define INCLUDED_CRONDATA_

#include <string>
#include <set>
#include <vector>

#include "../cronentry/cronentry.h"

class Options;

class CronData
{
    using SizeSet = std::set<size_t>;

    friend 
        std::ostream &operator<<(std::ostream &out, CronData const &cronData);

    Options const *d_options;

    std::vector<std::string> d_environment;
    std::vector<CronEntry> d_cronEntries;
    size_t d_lastSize = 0;

    CronEntry d_next;

    std::string d_entryName;
    size_t d_entryBegin = 0;
    size_t d_entryEnd = 60;

    SizeSet d_wip;

    std::vector<std::string> d_names;   // names used for time specifications
                                        // at a cron-job line
    size_t d_lineNr;
    bool d_all = false;
    bool  d_info = true;

    static size_t s_values[60];
    static char const *const s_month[12];
    static char const *const s_day[7];

    public:
        CronData();

        void addNr(size_t nr);
        void addRange(size_t first, size_t last, size_t step);
        void setAll(size_t step);
        void addName(std::string const &str);
        void setCommand(std::string const &command);                    // .f
        void process();
        void reset(size_t lineNr = 0);  // 0 means: do not update lineNr

        void messages(bool on = true);                                  // .f

        void setMinutes();
        void setHours();
        void setDayOfMonth();
        void setMonthOfYear();
        void setDayOfWeek();

        void setEnvVar(std::string const &var, std::string const &value);

        size_t lineNr() const;                                          // .f
        size_t size() const;                                            // .f

        std::vector<CronEntry> const &cronEntries() const;              // .f
        CronEntry const &operator[](size_t index) const;                // .f

        std::vector<std::string> const &environment() const;            // .f

    private:
        SizeSet assign();
        SizeSet assign(char const *const *names,
                                                    bool allowEnd = false);

        void invalidRange(size_t first, size_t last) const;             // .ih
        void outOfRange(size_t nr);
        void addCronCommand();
            
        std::ostream &insert(std::ostream &out) const;
};

#include "crondata.f"
        
#endif
