#include "stdafx.h"
#include "Content.h"
#include "RefSource.h"

namespace code {

	Content::Content() : cOwner(null) {}

	const void *Content::address() const {
		return lastAddress;
	}

	nat Content::size() const {
		return lastSize;
	}

	void Content::set(const void *addr, Nat size) {
		lastAddress = addr;
		lastSize = size;

		RefSource *o = owner();
		if (o)
			o->update();
	}

	Str *Content::ownerName() const {
		RefSource *o = owner();
		if (o)
			return o->title();
		else
			return null;
	}

	RefSource *Content::owner() const {
		return atomicRead(cOwner);
	}

	RefSource *Content::stolenBy() const {
		return null;
	}

	StaticContent::StaticContent(const void *addr) {
		set(addr, 0);
	}


}
