/*
 *  Project   : tin - a Usenet reader
 *  Module    : policy.h
 *  Author    : Ralf Doeblitz <doeblitz@gmx.de>
 *  Created   : 1999-01-12
 *  Updated   : 2025-08-27
 *  Notes     : #defines and static data for policy configuration
 *
 * Copyright (c) 1999-2025 Ralf Doeblitz <doeblitz@gmx.de>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * CAUTION: THIS FILE MAY BE OUTDATED!
 * "disable_gnksa_domain_check=OFF" MIGHT RESULT IN FALSE POSITIVES
 */

/*
 * tables for TLD search in misc.c, gnksa domain checking
 */

#ifndef TIN_POLICY_H
#	define TIN_POLICY_H 1
/*
 * known two letter country codes
 *
 * .ac  Ascension Island               .ad  Andorra
 * .ae  United Arab Emirates           .af  Afghanistan
 * .ag  Antigua and Barbuda            .ai  Anguilla
 * .al  Albania                        .am  Armenia
 * .an  Netherlands Antilles           .ao  Angola
 * .aq  Antarctica                     .ar  Argentina
 * .as  American Samoa                 .at  Austria
 * .au  Australia                      .aw  Aruba
 * .ax  Aland                          .az  Azerbaijan
 *
 * .ba  Bosnia and Herzegowina         .bb  Barbados
 * .bd  Bangladesh                     .be  Belgium
 * .bf  Burkina Faso                   .bg  Bulgaria
 * .bh  Bahrain                        .bi  Burundi
 * .bj  Benin                          .bm  Bermuda
 * .bn  Brunei Darussalam              .bo  Bolivia
 * .br  Brazil                         .bs  Bahamas
 * .bt  Bhutan                         .bw  Botswana
 * .by  Belarus                        .bz  Belize
 *
 * .ca  Canada                         .cc  Cocos (Keeling) Islands
 * .cd  Congo, Democratic People's Republic
 * .cf  Central African Republic       .cg  Congo, Republic of
 * .ch  Switzerland                    .ci  Côte d'Ivoire
 * .ck  Cook Islands                   .cl  Chile
 * .cm  Cameroon                       .cn  China
 * .co  Colombia                       .cr  Costa Rica
 * .cu  Cuba                           .cv  Cape Verde
 * .cw  Curacao                        .cx  Christmas Island
 * .cy  Cyprus                         .cz  Czech Republic
 *
 * .de  Germany                        .dj  Djibouti
 * .dk  Denmark                        .dm  Dominica
 * .do  Dominican Republic             .dz  Algeria
 *
 * .ec  Ecuador                        .ee  Estonia
 * .eg  Egypt                          .er  Eritrea
 * .es  Spain                          .et  Ethiopia
 * .eu  European Union
 *
 * .fi  Finland                        .fj  Fiji
 * .fk  Falkland Islands (Malvina)     .fm  Micronesia, Federal State of
 * .fo  Faroe Islands                  .fr  France
 *
 * .ga  Gabon                          .gb  United Kingdom
 * .gd  Grenada                        .ge  Georgia
 * .gf  French Guiana                  .gg  Guernsey
 * .gh  Ghana                          .gi  Gibraltar
 * .gl  Greenland                      .gm  Gambia
 * .gn  Guinea                         .gp  Guadelope
 * .gq  Equatorial Guinea              .gr  Greece
 * .gs  South Georgia and the South Sandwich Islands
 * .gt  Guatemala                      .gu  Guam
 * .gw  Guinea-Bissau                  .gy  Guyana
 *
 * .hk  Hong Kong                      .hm  Heard and McDonald Islands
 * .hn  Honduras                       .hr  Croatia/Hrvatska
 * .ht  Haiti                          .hu  Hungary
 *
 * .id  Indonesia                      .ie  Ireland
 * .il  Israel                         .im  Isle of Man
 * .in  India                          .io  British Indian Ocean Territory
 * .iq  Iraq                           .ir  Iran
 * .is  Iceland                        .it  Italy
 *
 * .je  Jersey                         .jm  Jamaica
 * .jo  Jordan                         .jp  Japan
 *
 * .ke  Kenya                          .kg  Kyrgystan
 * .kh  Cambodia                       .ki  Kiribati
 * .km  Comoros                        .kn  Saint Kitts and Nevis
 * .kp  Korea, Democratic People's Republic
 * .kr  Korea, Republic of             .kw  Kuwait
 * .ky  Cayman Islands                 .kz  Kazakhstan
 *
 * .la  Laos (People's Democratic Republic)
 * .lb  Lebanon                        .lc  Saint Lucia
 * .li  Liechtenstein                  .lk  Sri Lanka
 * .lr  Liberia                        .ls  Lesotho
 * .lt  Lithuania                      .lu  Luxembourg
 * .lv  Latvia                         .ly  Libyan Arab Jamahiriya
 *
 * .ma  Morocco                        .mc  Monaco
 * .md  Moldova, Republic of           .me  Montenegro
 * .mg  Madagascar                     .mh  Marshall Islands
 * .mk  Macedonia                      .ml  Mali
 * .mm  Myanmar                        .mn  Mongolia
 * .mo  Macau                          .mp  Northern Mariana Islands
 * .mq  Martinique                     .mr  Mauritania
 * .ms  Montserrat                     .mt  Malta
 * .mu  Mauritius                      .mv  Maldives
 * .mw  Malawi                         .mx  Mexico
 * .my  Malaysia                       .mz  Mozambique
 *
 * .na  Namibia                        .nc  New Caledonia
 * .ne  Niger                          .nf  Norfolk Island
 * .ng  Nigeria                        .ni  Nicaragua
 * .nl  The Netherlands                .no  Norway
 * .np  Nepal                          .nr  Nauru
 * .nu  Niue                           .nz  New Zealand
 *
 * .om  Oman
 *
 * .pa  Panama                         .pe  Peru
 * .pf  French Polynesia               .pg  Papua New Guinea
 * .ph  Philippines                    .pk  Pakistan
 * .pl  Poland                         .pm  St. Pierre and Miquelon
 * .pn  Pitcairn Island                .pr  Puerto Rico
 * .ps  Palestinian Territories        .pt  Portugal
 * .pw  Palau                          .py  Paraguay
 *
 * .qa  Qatar
 *
 * .re  Reunion                        .ro  Romania
 * .rs  Republic of Serbia             .ru  Russian Federation
 * .rw  Rwanda
 *
 * .sa  Saudi Arabia                   .sb  Solomon Islands
 * .sc  Seychelles                     .sd  Sudan
 * .se  Sweden                         .sg  Singapore
 * .sh  St. Helena                     .si  Slovenia
 * .sk  Slovakia                       .sl  Sierra Leone
 * .sm  San Marino                     .sn  Senegal
 * .so  Somalia                        .sr  Surinam
 * .ss  South Sudan                    .st  Sao Tome and Principe
 * .su  Soviet Union (former)          .sv  El Salvador
 * .sx  Sint Maarten (Dutch side)      .sy  Syrian Arab Republic
 * .sz  Swaziland
 *
 * .tc  The Turks & Caicos Islands     .td  Chad
 * .tf  French Southern Territories    .tg  Togo
 * .th  Thailand                       .tj  Tajikistan
 * .tk  Tokelau                        .tl  Timor-Leste
 * .tm  Turkmenistan                   .tn  Tunisia
 * .to  Tonga                          .tp  East Timor
 * .tr  Turkey                         .tt  Trinidad and Tobago
 * .tv  Tuvalu                         .tw  Taiwan
 * .tz  Tanzania
 *
 * .ua  Ukraine                        .ug  Uganda
 * .uk  United Kingdom
 * .us  United States                  .uy  Uruguay
 * .uz  Uzbekistan
 *
 * .va  Holy See (Vatican City State)  .vc  Saint Vincent and the Grenadines
 * .ve  Venezuela                      .vg  Virgin Islands (British)
 * .vi  Virgin Islands (U.S)           .vn  Vietnam
 * .vu  Vanuatu
 *
 * .wf  Wallis and Futuna Islands      .ws  Western Samoa
 *
 * .ye  Yemen                          .yt  Mayotte
 *
 * .za  South Africa                   .zm  Zambia
 * .zw  Zimbabwe
 *
 *
 * invalid/obsolete TLDs:
 * .an  Netherlands Antilles, becomes .bq, .cw, and .sx
 * .bu  Burma, now .mm
 * .cs  former Czechoslovakia, now .cz and .sk
 * .dd  former German Democratic Republic, now .de
 * .fx  France, Metropolitan
 * .oz  Australian MHSnet
 * .tp  former East Timor, now .tl
 * .um  United States Minor Outlying Islands
 * .yd  Democratic Yemen, now .ye
 * .yu  Yugoslavia, now .rs and .me
 * .wg  West Bank and Gaza, now .ps
 * .zr  former Zaire, now .cd
 *
 * user-assigned code elements:
 * .aa, .qm, .qz, .xa, .xz, .zz
 *
 * unused TLDs:
 * .bl  Saint Barthélemy
 * .bq  Bonaire, Sint Eustatius and Saba
 * .bv  Bouvet Island (Norway)
 * .eh  Western Sahara
 * .gb  United Kingdom, use .uk
 * .mf  Sint Maarten (French side)
 * .sj  Svalbard and Jan Mayen Islands (Norway)
 *
 * requested new TLDs:
 *
 * xccTLDs:
 * .su  former USSR, now .ru
 *
 * differences between ccTLDs and ISO-3166-2 codes:
 * .ac only ccTLD
 *  BL only ISO-3166-2 code: Saint Barthélemy
 *  BQ only ISO-3166-2 code: "Bonaire, Sint Eustatius and Saba"
 *  EH only ISO-3166-2 code: Western Sahara
 * .eu only ccTLD
 *  MF only ISO-3166-2 code: Saint Martin (French part)
 * .su only ccTLD
 * .uk only ccTLD
 *  UM only ISO-3166-2 code: United States Minor Outlying Islands
 */

static char gnksa_country_codes[26*26] = {
/*      A B C D E  F G H I J  K L M N O  P Q R S T  U V W X Y  Z */
/* A */ 0,0,1,1,1, 1,1,0,1,0, 0,1,1,0,1, 0,1,1,1,1, 1,0,1,1,0, 1,
/* B */ 1,1,0,1,1, 1,1,1,1,1, 0,0,1,1,1, 0,0,1,1,1, 0,1,1,0,1, 1,
/* C */ 1,0,1,1,0, 1,1,1,1,0, 1,1,1,1,1, 0,0,1,0,0, 1,1,1,1,1, 1,
/* D */ 0,0,0,0,1, 0,0,0,0,1, 1,0,1,0,1, 0,0,0,0,0, 0,0,0,0,0, 1,
/* E */ 0,0,1,0,1, 0,1,0,0,0, 0,0,0,0,0, 0,0,1,1,1, 1,0,0,0,0, 0,
/* F */ 0,0,0,0,0, 0,0,0,1,1, 1,0,1,0,1, 0,0,1,0,0, 0,0,0,0,0, 0,
/* G */ 1,1,0,1,1, 1,1,1,1,0, 0,1,1,1,0, 1,1,1,1,1, 1,0,1,0,1, 0,
/* H */ 0,0,0,0,0, 0,0,0,0,0, 1,0,1,1,0, 0,0,1,0,1, 1,0,0,0,0, 0,
/* I */ 0,0,0,1,1, 0,0,0,0,0, 0,1,1,1,1, 0,1,1,1,1, 0,0,0,0,0, 0,
/* J */ 0,0,0,0,1, 0,0,0,0,0, 0,0,1,0,1, 1,0,0,0,0, 0,0,0,0,0, 0,
/* K */ 0,0,0,0,1, 0,1,1,1,0, 0,0,1,1,0, 1,0,1,0,0, 0,0,1,0,1, 1,
/* L */ 1,1,1,0,0, 0,0,0,1,0, 1,0,0,0,0, 0,0,1,1,1, 1,1,0,0,1, 0,
/* M */ 1,0,1,1,1, 0,1,1,0,0, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,
/* N */ 1,0,1,0,1, 1,1,0,1,0, 0,1,0,0,1, 1,0,1,0,0, 1,0,0,0,0, 1,
/* O */ 0,0,0,0,0, 0,0,0,0,0, 0,0,1,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,
/* P */ 1,0,0,0,1, 1,1,1,0,0, 1,1,1,1,0, 0,0,1,1,1, 0,0,1,0,1, 0,
/* Q */ 1,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,
/* R */ 0,0,0,0,1, 0,0,0,0,0, 0,0,0,0,1, 0,0,0,1,0, 1,0,1,0,0, 0,
/* S */ 1,1,1,1,1, 0,1,1,1,1, 1,1,1,1,1, 0,0,1,1,1, 1,1,0,1,1, 1,
/* T */ 0,0,1,1,0, 1,1,1,0,1, 1,1,1,1,1, 0,0,1,0,1, 0,1,1,0,0, 1,
/* U */ 1,0,0,0,0, 0,1,0,0,0, 1,0,0,0,0, 0,0,0,1,0, 0,0,0,0,1, 1,
/* V */ 1,0,1,0,1, 0,1,0,1,0, 0,0,0,1,0, 0,0,0,0,0, 1,0,0,0,0, 0,
/* W */ 0,0,0,0,0, 1,0,0,0,0, 0,0,0,0,0, 0,0,0,1,0, 0,0,0,0,0, 0,
/* X */ 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,
/* Y */ 0,0,0,0,1, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,1, 0,0,0,0,0, 0,
/* Z */ 1,0,0,0,0, 0,0,0,0,0, 0,0,1,0,0, 0,0,0,0,0, 0,0,1,0,0, 0,
};

/* THE DATA BELOW MAY BE OUT OF DATE */
static const char *gnksa_domain_list[] = {
	"aaa",
	"abb",
	"abc",
	"aco",
	"ads",
	"aeg",
	"afl",
	"aig",
	"anz",
	"aol",
	"app",
	"art",
	"aws",
	"axa",
	"bar",
	"bbc",
	"bbt",
	"bcg",
	"bcn",
	"bet",
	"bid",
	"bio",
	"biz",
	"bms",
	"bmw",
	"bom",
	"boo",
	"bot",
	"box",
	"buy",
	"bzh",
	"cab",
	"cal",
	"cam",
	"car",
	"cat",
	"cba",
	"cbn",
	"ceo",
	"cfa",
	"cfd",
	"com",
	"cpa",
	"crs",
	"dad",
	"day",
	"dds",
	"dev",
	"dhl",
	"diy",
	"dnp",
	"dog",
	"dot",
	"dtv",
	"dvr",
	"eat",
	"eco",
	"edu",
	"esq",
	"eus",
	"fan",
	"fit",
	"fly",
	"foo",
	"fox",
	"frl",
	"ftr",
	"fun",
	"fyi",
	"gal",
	"gap",
	"gay",
	"gdn",
	"gea",
	"gle",
	"gmo",
	"gmx",
	"goo",
	"gop",
	"got",
	"gov",
	"hbo",
	"hiv",
	"hkt",
	"hot",
	"how",
	"ibm",
	"ice",
	"icu",
	"ifm",
	"inc",
	"ing",
	"ink",
	"int",
	"ist",
	"itv",
	"jcb",
	"jio",
	"jll",
	"jmp",
	"jnj",
	"jot",
	"joy",
	"kfh",
	"kia",
	"kim",
	"kpn",
	"krd",
	"lat",
	"law",
	"lds",
	"llc",
	"llp",
	"lol",
	"lpl",
	"ltd",
	"man",
	"map",
	"mba",
	"med",
	"men",
	"mil",
	"mit",
	"mlb",
	"mls",
	"mma",
	"moe",
	"moi",
	"mom",
	"mov",
	"msd",
	"mtn",
	"mtr",
	"nab",
	"nba",
	"nec",
	"net",
	"new",
	"nfl",
	"ngo",
	"nhk",
	"now",
	"nra",
	"nrw",
	"ntt",
	"nyc",
	"obi",
	"one",
	"ong",
	"onl",
	"ooo",
	"org",
	"ott",
	"ovh",
	"pay",
	"pet",
	"phd",
	"pid",
	"pin",
	"pnc",
	"pro",
	"pru",
	"pub",
	"pwc",
	"red",
	"ren",
	"ril",
	"rio",
	"rip",
	"run",
	"rwe",
	"sap",
	"sas",
	"sbi",
	"sbs",
	"scb",
	"sew",
	"sex",
	"sfr",
	"ski",
	"sky",
	"soy",
	"spa",
	"srl",
	"stc",
	"tab",
	"tax",
	"tci",
	"tdk",
	"tel",
	"thd",
	"tjx",
	"top",
	"trv",
	"tui",
	"tvs",
	"ubs",
	"uno",
	"uol",
	"ups",
	"vet",
	"vig",
	"vin",
	"vip",
	"wed",
	"win",
	"wme",
	"wow",
	"wtc",
	"wtf",
	"xin",
	"xxx",
	"xyz",
	"you",
	"yun",
	"zip",
	"aarp",
	"able",
	"aero",
	"akdn",
	"ally",
	"amex",
	"arab",
	"army",
	"arpa",
	"arte",
	"asda",
	"asia",
	"audi",
	"auto",
	"baby",
	"band",
	"bank",
	"bbva",
	"beer",
	"best",
	"bike",
	"bing",
	"blog",
	"blue",
	"bofa",
	"bond",
	"book",
	"buzz",
	"cafe",
	"call",
	"camp",
	"care",
	"cars",
	"casa",
	"case",
	"cash",
	"cbre",
	"cern",
	"chat",
	"citi",
	"city",
	"club",
	"cool",
	"coop",
	"cyou",
	"data",
	"date",
	"dclk",
	"deal",
	"dell",
	"desi",
	"diet",
	"dish",
	"docs",
	"dvag",
	"erni",
	"fage",
	"fail",
	"fans",
	"farm",
	"fast",
	"fido",
	"film",
	"fire",
	"fish",
	"flir",
	"food",
	"ford",
	"free",
	"fund",
	"game",
	"gbiz",
	"gent",
	"ggee",
	"gift",
	"gmbh",
	"gold",
	"golf",
	"goog",
	"guge",
	"guru",
	"hair",
	"haus",
	"hdfc",
	"help",
	"here",
	"host",
	"hsbc",
	"icbc",
	"ieee",
	"imdb",
	"immo",
	"info",
	"itau",
	"java",
	"jeep",
	"jobs",
	"jprs",
	"kddi",
	"kids",
	"kiwi",
	"kpmg",
	"kred",
	"land",
	"lego",
	"lgbt",
	"lidl",
	"life",
	"like",
	"limo",
	"link",
	"live",
	"loan",
	"love",
	"ltda",
	"luxe",
	"maif",
	"meet",
	"meme",
	"menu",
	"mini",
	"mint",
	"mobi",
	"moda",
	"moto",
	"name",
	"navy",
	"news",
	"next",
	"nico",
	"nike",
	"ollo",
	"open",
	"page",
	"pars",
	"pccw",
	"pics",
	"ping",
	"pink",
	"play",
	"plus",
	"pohl",
	"porn",
	"post",
	"prod",
	"prof",
	"qpon",
	"read",
	"reit",
	"rent",
	"rest",
	"rich",
	"room",
	"rsvp",
	"ruhr",
	"safe",
	"sale",
	"sarl",
	"save",
	"saxo",
	"scot",
	"seat",
	"seek",
	"sexy",
	"shia",
	"shop",
	"show",
	"silk",
	"sina",
	"site",
	"skin",
	"sncf",
	"sohu",
	"song",
	"sony",
	"spot",
	"star",
	"surf",
	"talk",
	"taxi",
	"team",
	"tech",
	"teva",
	"tiaa",
	"tips",
	"town",
	"toys",
	"tube",
	"vana",
	"visa",
	"viva",
	"vivo",
	"vote",
	"voto",
	"wang",
	"weir",
	"wien",
	"wiki",
	"wine",
	"work",
	"xbox",
	"yoga",
	"zara",
	"zero",
	"zone",
	"actor",
	"adult",
	"aetna",
	"amfam",
	"amica",
	"apple",
	"archi",
	"audio",
	"autos",
	"azure",
	"baidu",
	"beats",
	"bible",
	"bingo",
	"black",
	"boats",
	"bosch",
	"build",
	"canon",
	"cards",
	"chase",
	"cheap",
	"cisco",
	"citic",
	"click",
	"cloud",
	"coach",
	"codes",
	"crown",
	"cymru",
	"dance",
	"deals",
	"delta",
	"drive",
	"dubai",
	"earth",
	"edeka",
	"email",
	"epson",
	"faith",
	"fedex",
	"final",
	"forex",
	"forum",
	"gallo",
	"games",
	"gifts",
	"gives",
	"glass",
	"globo",
	"gmail",
	"green",
	"gripe",
	"group",
	"gucci",
	"guide",
	"homes",
	"honda",
	"horse",
	"house",
	"hyatt",
	"ikano",
	"irish",
	"jetzt",
	"koeln",
	"kyoto",
	"lamer",
	"lease",
	"legal",
	"lexus",
	"lilly",
	"loans",
	"locus",
	"lotte",
	"lotto",
	"mango",
	"media",
	"miami",
	"money",
	"movie",
	"music",
	"nexus",
	"nikon",
	"ninja",
	"nokia",
	"nowtv",
	"omega",
	"osaka",
	"paris",
	"parts",
	"party",
	"phone",
	"photo",
	"pizza",
	"place",
	"poker",
	"praxi",
	"press",
	"prime",
	"promo",
	"quest",
	"radio",
	"rehab",
	"reise",
	"ricoh",
	"rocks",
	"rodeo",
	"rugby",
	"salon",
	"sener",
	"seven",
	"sharp",
	"shell",
	"shoes",
	"skype",
	"sling",
	"smart",
	"smile",
	"solar",
	"space",
	"sport",
	"stada",
	"store",
	"study",
	"style",
	"sucks",
	"swiss",
	"tatar",
	"tires",
	"tirol",
	"tmall",
	"today",
	"tokyo",
	"tools",
	"toray",
	"total",
	"tours",
	"trade",
	"trust",
	"tunes",
	"tushu",
	"ubank",
	"vegas",
	"video",
	"vodka",
	"volvo",
	"wales",
	"watch",
	"weber",
	"weibo",
	"works",
	"world",
	"xerox",
	"yahoo",
	"abbott",
	"abbvie",
	"africa",
	"agency",
	"airbus",
	"airtel",
	"alipay",
	"alsace",
	"alstom",
	"amazon",
	"anquan",
	"aramco",
	"author",
	"bayern",
	"beauty",
	"berlin",
	"bharti",
	"bostik",
	"boston",
	"broker",
	"camera",
	"career",
	"casino",
	"center",
	"chanel",
	"chrome",
	"church",
	"circle",
	"claims",
	"clinic",
	"coffee",
	"comsec",
	"condos",
	"coupon",
	"credit",
	"cruise",
	"dating",
	"datsun",
	"dealer",
	"degree",
	"dental",
	"design",
	"direct",
	"doctor",
	"dunlop",
	"dupont",
	"durban",
	"emerck",
	"energy",
	"estate",
	"events",
	"expert",
	"family",
	"flickr",
	"futbol",
	"gallup",
	"garden",
	"george",
	"giving",
	"global",
	"google",
	"gratis",
	"health",
	"hermes",
	"hiphop",
	"hockey",
	"hotels",
	"hughes",
	"imamat",
	"insure",
	"intuit",
	"jaguar",
	"joburg",
	"juegos",
	"kaufen",
	"kindle",
	"kosher",
	"latino",
	"lawyer",
	"lefrak",
	"living",
	"locker",
	"london",
	"luxury",
	"madrid",
	"maison",
	"makeup",
	"market",
	"mattel",
	"mobile",
	"monash",
	"mormon",
	"moscow",
	"museum",
	"nagoya",
	"nissan",
	"nissay",
	"norton",
	"nowruz",
	"office",
	"olayan",
	"online",
	"oracle",
	"orange",
	"otsuka",
	"pfizer",
	"photos",
	"physio",
	"pictet",
	"quebec",
	"racing",
	"realty",
	"reisen",
	"repair",
	"report",
	"review",
	"rogers",
	"ryukyu",
	"safety",
	"sakura",
	"sanofi",
	"school",
	"schule",
	"search",
	"secure",
	"select",
	"shouji",
	"soccer",
	"social",
	"stream",
	"studio",
	"supply",
	"suzuki",
	"swatch",
	"sydney",
	"taipei",
	"taobao",
	"target",
	"tattoo",
	"tennis",
	"tienda",
	"tjmaxx",
	"tkmaxx",
	"toyota",
	"travel",
	"unicom",
	"viajes",
	"viking",
	"villas",
	"virgin",
	"vision",
	"voting",
	"voyage",
	"walter",
	"webcam",
	"xihuan",
	"yachts",
	"yandex",
	"zappos",
	"abogado",
	"academy",
	"agakhan",
	"alibaba",
	"android",
	"athleta",
	"auction",
	"audible",
	"auspost",
	"banamex",
	"bauhaus",
	"bestbuy",
	"booking",
	"brother",
	"capital",
	"caravan",
	"careers",
	"channel",
	"charity",
	"chintai",
	"citadel",
	"clubmed",
	"college",
	"cologne",
	"company",
	"compare",
	"contact",
	"cooking",
	"corsica",
	"country",
	"coupons",
	"courses",
	"cricket",
	"cruises",
	"dentist",
	"digital",
	"domains",
	"exposed",
	"express",
	"farmers",
	"fashion",
	"ferrari",
	"ferrero",
	"finance",
	"fishing",
	"fitness",
	"flights",
	"florist",
	"flowers",
	"forsale",
	"frogans",
	"fujitsu",
	"gallery",
	"genting",
	"godaddy",
	"grocery",
	"guitars",
	"hamburg",
	"hangout",
	"hitachi",
	"holiday",
	"hosting",
	"hotmail",
	"hyundai",
	"ismaili",
	"jewelry",
	"juniper",
	"kitchen",
	"komatsu",
	"lacaixa",
	"lanxess",
	"lasalle",
	"latrobe",
	"leclerc",
	"limited",
	"lincoln",
	"markets",
	"monster",
	"netbank",
	"netflix",
	"network",
	"neustar",
	"okinawa",
	"organic",
	"origins",
	"philips",
	"pioneer",
	"politie",
	"realtor",
	"recipes",
	"rentals",
	"reviews",
	"rexroth",
	"samsung",
	"sandvik",
	"schmidt",
	"schwarz",
	"science",
	"shiksha",
	"singles",
	"staples",
	"storage",
	"support",
	"surgery",
	"systems",
	"temasek",
	"theater",
	"theatre",
	"tickets",
	"toshiba",
	"trading",
	"walmart",
	"wanggou",
	"watches",
	"weather",
	"website",
	"wedding",
	"whoswho",
	"windows",
	"winners",
	"yamaxun",
	"youtube",
	"zuerich",
	"abudhabi",
	"airforce",
	"allstate",
	"attorney",
	"barclays",
	"barefoot",
	"bargains",
	"baseball",
	"boutique",
	"bradesco",
	"broadway",
	"brussels",
	"builders",
	"business",
	"capetown",
	"catering",
	"catholic",
	"cipriani",
	"cleaning",
	"clinique",
	"clothing",
	"commbank",
	"computer",
	"delivery",
	"deloitte",
	"democrat",
	"diamonds",
	"discount",
	"discover",
	"download",
	"engineer",
	"ericsson",
	"exchange",
	"feedback",
	"fidelity",
	"firmdale",
	"football",
	"frontier",
	"goodyear",
	"grainger",
	"graphics",
	"hdfcbank",
	"helsinki",
	"holdings",
	"hospital",
	"infiniti",
	"ipiranga",
	"istanbul",
	"jpmorgan",
	"lighting",
	"lundbeck",
	"marriott",
	"mckinsey",
	"memorial",
	"merckmsd",
	"mortgage",
	"observer",
	"partners",
	"pharmacy",
	"pictures",
	"plumbing",
	"property",
	"reliance",
	"saarland",
	"samsclub",
	"security",
	"services",
	"shopping",
	"softbank",
	"software",
	"stcgroup",
	"supplies",
	"training",
	"vanguard",
	"ventures",
	"verisign",
	"woodside",
	"xn--90ae",
	"xn--node",
	"xn--p1ai",
	"xn--qxam",
	"yokohama",
	"accenture",
	"allfinanz",
	"amsterdam",
	"analytics",
	"aquarelle",
	"barcelona",
	"bloomberg",
	"christmas",
	"community",
	"directory",
	"education",
	"equipment",
	"fairwinds",
	"financial",
	"firestone",
	"fresenius",
	"furniture",
	"goldpoint",
	"hisamitsu",
	"homedepot",
	"homegoods",
	"homesense",
	"institute",
	"insurance",
	"kuokgroup",
	"landrover",
	"lifestyle",
	"marketing",
	"marshalls",
	"melbourne",
	"microsoft",
	"panasonic",
	"richardli",
	"shangrila",
	"solutions",
	"statebank",
	"statefarm",
	"stockholm",
	"travelers",
	"vacations",
	"xn--90ais",
	"xn--c1avg",
	"xn--d1alf",
	"xn--e1a4c",
	"xn--fhbei",
	"xn--j1aef",
	"xn--j1amh",
	"xn--l1acc",
	"xn--ngbrx",
	"xn--nqv7f",
	"xn--p1acf",
	"xn--qxa6a",
	"xn--tckwe",
	"xn--vhquv",
	"yodobashi",
	"accountant",
	"apartments",
	"associates",
	"basketball",
	"bnpparibas",
	"boehringer",
	"capitalone",
	"consulting",
	"creditcard",
	"cuisinella",
	"eurovision",
	"extraspace",
	"foundation",
	"healthcare",
	"immobilien",
	"industries",
	"management",
	"mitsubishi",
	"nextdirect",
	"properties",
	"protection",
	"prudential",
	"realestate",
	"republican",
	"restaurant",
	"schaeffler",
	"tatamotors",
	"technology",
	"university",
	"vlaanderen",
	"xn--30rr7y",
	"xn--3pxu8k",
	"xn--45q11c",
	"xn--4gbrim",
	"xn--55qx5d",
	"xn--5tzm5g",
	"xn--80aswg",
	"xn--90a3ac",
	"xn--9dbq2a",
	"xn--9et52u",
	"xn--c2br7g",
	"xn--cg4bki",
	"xn--czrs0t",
	"xn--czru2d",
	"xn--fiq64b",
	"xn--fiqs8s",
	"xn--fiqz9s",
	"xn--io0a7i",
	"xn--kput3i",
	"xn--mxtq1m",
	"xn--o3cw4h",
	"xn--pssy2u",
	"xn--q7ce6a",
	"xn--unup4y",
	"xn--wgbh1c",
	"xn--wgbl6a",
	"xn--y9a3aq",
	"accountants",
	"barclaycard",
	"blackfriday",
	"blockbuster",
	"bridgestone",
	"calvinklein",
	"contractors",
	"creditunion",
	"engineering",
	"enterprises",
	"investments",
	"kerryhotels",
	"lamborghini",
	"motorcycles",
	"olayangroup",
	"photography",
	"playstation",
	"productions",
	"progressive",
	"redumbrella",
	"williamhill",
	"xn--11b4c3d",
	"xn--1ck2e1b",
	"xn--1qqw23a",
	"xn--2scrj9c",
	"xn--3bst00m",
	"xn--3ds443g",
	"xn--3hcrj9c",
	"xn--42c2d9a",
	"xn--45brj9c",
	"xn--55qw42g",
	"xn--6frz82g",
	"xn--80ao21a",
	"xn--9krt00a",
	"xn--cck2b3b",
	"xn--czr694b",
	"xn--d1acj3b",
	"xn--efvy88h",
	"xn--fct429k",
	"xn--fjq720a",
	"xn--flw351e",
	"xn--g2xx48c",
	"xn--gecrj9c",
	"xn--gk3at1e",
	"xn--h2brj9c",
	"xn--hxt814e",
	"xn--imr513n",
	"xn--j6w193g",
	"xn--jvr189m",
	"xn--kprw13d",
	"xn--kpry57d",
	"xn--mgbbh1a",
	"xn--mgbtx2b",
	"xn--mix891f",
	"xn--nyqy26a",
	"xn--otu796d",
	"xn--pgbs0dh",
	"xn--q9jyb4c",
	"xn--rhqv96g",
	"xn--rovu88b",
	"xn--s9brj9c",
	"xn--ses554g",
	"xn--t60b56a",
	"xn--vuq861b",
	"xn--w4rs40l",
	"xn--xhq521b",
	"xn--zfr164b",
	"construction",
	"lplfinancial",
	"scholarships",
	"versicherung",
	"xn--3e0b707e",
	"xn--45br5cyl",
	"xn--4dbrk0ce",
	"xn--80adxhks",
	"xn--80asehdb",
	"xn--8y0a063a",
	"xn--gckr3f0f",
	"xn--mgb9awbf",
	"xn--mgbab2bd",
	"xn--mgbgu82a",
	"xn--mgbpl2fh",
	"xn--mgbt3dhd",
	"xn--mk1bu44c",
	"xn--ngbc5azd",
	"xn--ngbe9e0a",
	"xn--ogbpf8fl",
	"xn--qcka1pmc",
	"international",
	"lifeinsurance",
	"wolterskluwer",
	"xn--cckwcxetd",
	"xn--eckvdtc9d",
	"xn--fpcrj9c3d",
	"xn--fzc2c9e2c",
	"xn--h2brj9c8c",
	"xn--tiq49xqyj",
	"xn--yfro4i67o",
	"xn--ygbi2ammx",
	"americanfamily",
	"weatherchannel",
	"xn--54b7fta0cc",
	"xn--6qq986b3xl",
	"xn--80aqecdr1a",
	"xn--b4w605ferd",
	"xn--fiq228c5hs",
	"xn--h2breg3eve",
	"xn--jlq480n2rg",
	"xn--mgba3a3ejt",
	"xn--mgbaam7a8h",
	"xn--mgbayh7gpa",
	"xn--mgbbh1a71e",
	"xn--mgbca7dzdo",
	"xn--mgbi4ecexp",
	"xn--mgbx4cd0ab",
	"xn--rvc1e0am3e",
	"americanexpress",
	"kerryproperties",
	"sandvikcoromant",
	"xn--i1b6b1a6a2e",
	"xn--kcrx77d1x4a",
	"xn--lgbbat1ad8j",
	"xn--mgba3a4f16a",
	"xn--mgbc0a9azcg",
	"xn--nqv7fs00ema",
	"xn--fzys8d69uvgm",
	"xn--mgba7c0bbn0a",
	"xn--mgbcpq6gpa1a",
	"xn--xkc2al3hye2a",
	"xn--5su34j936bgsg",
	"xn--bck1b9a5dre4c",
	"xn--mgbah1a3hjkrd",
	"xn--mgbai9azgqp6j",
	"xn--mgberp4a5d4ar",
	"xn--xkc2dl3a5ee0h",
	"travelersinsurance",
	"xn--w4r85el8fhu5dnra",
	"xn--clchc0ea0b2g2a9gcd",
#	if 0		/* $DEAD */
	"nato",
	"uucp",
	"csnet",
	"bitnet",
#	endif /* 0 */
	/* the next five are defined in RFC 2606, RFC 6761 */
	"invalid",
#	if 0
	/* but four of them shouldn't be used on usenet */
	"test",
	"onion",	/* RFC 7686 */
	"example",
	"localhost",
#	endif /* 0 */
#	ifdef TINC_DNS
	"bofh",		/* There Is No Cabal */
#	endif /* TINC_DNS */
	/* sentinel */
	""
};
#endif /* !TIN_POLICY_H */
