/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2011-2012 Freescale Semiconductor, Inc.
 */

#ifndef _ASM_MPC85xx_CONFIG_H_
#define _ASM_MPC85xx_CONFIG_H_

/* SoC specific defines for Freescale MPC85xx (PQ3) and QorIQ processors */

/*
 * This macro should be removed when we no longer care about backwards
 * compatibility with older operating systems.
 */
#define CONFIG_PPC_SPINTABLE_COMPATIBLE

#include <fsl_ddrc_version.h>

#if defined(CONFIG_ARCH_MPC8548)
#define CFG_SYS_FSL_SRIO_MAX_PORTS	1
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_P1010)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	4

/* P1011 is single core version of P1020 */
#elif defined(CONFIG_ARCH_P1011)
#define CONFIG_TSECV2

#elif defined(CONFIG_ARCH_P1020)
#define CONFIG_TSECV2

#elif defined(CONFIG_ARCH_P1021)
#define CONFIG_TSECV2
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_P1023)
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	2
#define CONFIG_SYS_QMAN_NUM_PORTALS	3
#define CONFIG_SYS_BMAN_NUM_PORTALS	3
#define CONFIG_SYS_FM_MURAM_SIZE	0x10000

/* P1024 is lower end variant of P1020 */
#elif defined(CONFIG_ARCH_P1024)
#define CONFIG_TSECV2

/* P1025 is lower end variant of P1021 */
#elif defined(CONFIG_ARCH_P1025)
#define CONFIG_TSECV2
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_P2020)
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_P2041) /* also supports P2040 */
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_P3041)
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_P4080) /* also supports P4040 */
#define CONFIG_SYS_NUM_FMAN		2
#define CONFIG_SYS_NUM_FM1_DTSEC	4
#define CONFIG_SYS_NUM_FM2_DTSEC	4
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_NUM_FM2_10GEC	1
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_SRIO_MSG_UNIT_NUM	2
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xff000000

#elif defined(CONFIG_ARCH_P5040)
#define CONFIG_SYS_NUM_FMAN		2
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_NUM_FM2_DTSEC	5
#define CONFIG_SYS_NUM_FM2_10GEC	1
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_BSC9131)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	3

#elif defined(CONFIG_ARCH_BSC9132)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	3

#elif defined(CONFIG_ARCH_T4240)
#ifdef CONFIG_ARCH_T4240
#define CFG_SYS_FSL_CLUSTER_CLOCKS   { 1, 1, 4 }
#define CONFIG_SYS_NUM_FM1_DTSEC	8
#define CONFIG_SYS_NUM_FM1_10GEC	2
#define CONFIG_SYS_NUM_FM2_DTSEC	8
#define CONFIG_SYS_NUM_FM2_10GEC	2
#else
#define CONFIG_SYS_NUM_FM1_DTSEC	6
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_NUM_FM2_DTSEC	8
#define CONFIG_SYS_NUM_FM2_10GEC	1
#endif
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_FSL_SRDS_2
#define CFG_SYS_FSL_SRDS_3
#define CFG_SYS_FSL_SRDS_4
#define CONFIG_SYS_NUM_FMAN		2
#define CONFIG_SYS_PME_CLK		0
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FM1_CLK		3
#define CONFIG_SYS_FM2_CLK		3
#define CONFIG_SYS_FM_MURAM_SIZE	0x60000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5

#elif defined(CONFIG_ARCH_B4860) || defined(CONFIG_ARCH_B4420)
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_FSL_SRDS_2
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_FM1_CLK		0
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	4
#define CONFIG_SYS_FM_MURAM_SIZE	0x60000

#ifdef CONFIG_ARCH_B4860
#define CONFIG_MAX_DSP_CPUS		12
#define CONFIG_NUM_DSP_CPUS		6
#define CFG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4, 4, 4 }
#define CONFIG_SYS_NUM_FM1_DTSEC	6
#define CONFIG_SYS_NUM_FM1_10GEC	2
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#else
#define CONFIG_MAX_DSP_CPUS		2
#define CFG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4 }
#define CONFIG_SYS_NUM_FM1_DTSEC	4
#define CONFIG_SYS_NUM_FM1_10GEC	0
#endif

#elif defined(CONFIG_ARCH_T1040) || defined(CONFIG_ARCH_T1042)
#define CFG_SYS_FSL_CLUSTER_CLOCKS   { 1, 1, 1, 1 }
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_PME_PLAT_CLK_DIV		2
#define CONFIG_SYS_PME_CLK		CONFIG_PME_PLAT_CLK_DIV
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_FM_PLAT_CLK_DIV	1
#define CONFIG_SYS_FM1_CLK		CONFIG_FM_PLAT_CLK_DIV
#define CONFIG_SYS_FM_MURAM_SIZE	0x30000
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_T1024)
#define CFG_SYS_FSL_CLUSTER_CLOCKS  { 1, 1, 1, 1 }
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	4
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_FSL_FM_10GEC_REGULAR_NOTATION
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FM1_CLK		0
#define CONFIG_QBMAN_CLK_DIV		1
#define CONFIG_SYS_FM_MURAM_SIZE	0x30000
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_T2080)
#define CONFIG_SYS_NUM_FMAN		1
#define CFG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4, 4, 4 }
#define CONFIG_SYS_FSL_SRDS_1
#if defined(CONFIG_ARCH_T2080)
#define CONFIG_SYS_NUM_FM1_DTSEC	8
#define CONFIG_SYS_NUM_FM1_10GEC	4
#define CONFIG_SYS_FSL_SRDS_2
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#endif
#define CONFIG_PME_PLAT_CLK_DIV		1
#define CONFIG_SYS_PME_CLK		CONFIG_PME_PLAT_CLK_DIV
#define CONFIG_SYS_FM1_CLK		0
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE


#elif defined(CONFIG_ARCH_C29X)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2_1
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CFG_SYS_FSL_SEC_IDX_OFFSET	0x20000

#endif

#endif /* _ASM_MPC85xx_CONFIG_H_ */
