/*
 * common.h
 *
 * defines constants common to all files in ripperx
 *
 * TODO: move the includes to the files where they are used (ralf)
 *
 * Ralf Engels  10/06/1999  commented extern int errno out
 *                          moved include <errno> to files where needed
 */
#ifndef COMMON_H
#define COMMON_H

#include "../config.h"
#include "main_data.h"

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include "err_dialog_handler.h"

#include <stdexcept>
#include <string>

#ifndef TRUE
#define TRUE		1
#endif
#ifndef FALSE
#define FALSE		0
#endif

/* =====================================================
 * Constants
 * ===================================================*/

/* Global constants */
#define MAX_OPTIONS_LENGTH             300
#define MAX_SINGLE_OPTION_LENGTH       50

#define MAX_COMMAND_LENGTH             2048
#define MAX_ARGS                       50

#define MAX_FILE_PER_DIR               1024
#define MAX_FILE_PATH_LENGTH           512
#define MAX_FILE_NAME_LENGTH           512
// #define MAX_TOTAL_PATH_LENGTH       (MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH)

// #define MAX_TITLE_LENGTH               1024
#define MAX_GENRE_LENGTH               50	// 1024
// #define MAX_CDDB_LENGTH                1024      // the maximum length of a CDDB element

#define CD_SECTORS_PER_SEC             (float) 75.018
#define CD_SECTORS_PER_FRAME           (float) 1.959

#define MIN_NICE_LEVEL                 19
#define MAX_NICE_LEVEL                 0

#define MIN_MP2_BITRATE                32
#define MAX_MP2_BITRATE                320
#define MIN_MP2_VBR_QUALITY            -50.0
#define MAX_MP2_VBR_QUALITY            50.0

#define MIN_MP3_BITRATE                32
#define MAX_MP3_BITRATE                320
#define MIN_MP3_VBR_QUALITY            0
#define MAX_MP3_VBR_QUALITY            9.99

#define MIN_FLAC_COMPRESSION_LEVEL     0        // --fast
#define MAX_FLAC_COMPRESSION_LEVEL     8        // --best

#define MIN_OGG_VBR_QUALITY            -1.0
#define MAX_OGG_VBR_QUALITY            10.0
#define MIN_OGG_BITRATE                48
#define MAX_OGG_BITRATE                512

#define MIN_MUSEPACK_VBR_QUALITY       0.00
#define MAX_MUSEPACK_VBR_QUALITY       10.00

#define MIN_OPUS_BITRATE               16
#define MAX_OPUS_BITRATE               256

#define MAIN_FRAME_BORDER_WIDTH        7       //10
#define VBOX_BORDER_WIDTH              7       //05
#define VBOX_SPACING                   3

/* =====================================================
 * Structures
 * ===================================================*/

struct encoder_common_data
{
    CommonEncoderType type;
    std::string encoder;
    std::string plugin;
    std::string full_command;
    int enabled;
};

/* Configuration Structure */
typedef struct
{
    float wav_ratio;
    float mp3_ratio;
    std::string shell_for_execution;
    std::string wav_path;
    std::string mp3_path;
    std::string cddb_path;
    std::string wav_file_name_format;
    std::string encoded_file_name_format;
    char prepend_char;
    int encode_from_existing_wav;
    int ask_when_file_exists;
    int auto_append_extension;
    int keep_wav;
    int eject_disk_when_finished;
    int last_config_page;

    struct _ripper
    {
        std::string ripper;
        std::string plugin;
    } ripper;

    struct _encoder
    {
        int priority;
        // old changed values: use_varbitrate, vbr_qual, use_high_qual;

        struct _mp2
        {
            CommonEncoderType type;
            std::string encoder;
            std::string plugin;
            std::string full_command;
            int enabled;

            int bitrate;
            int use_vbr;
            float vbr_quality;
            int use_crc;
            std::string extra_options;    // TODO: Confirm if it needs extra options, UPGRADE to twolame
        } mp2;

        struct _mp3
        {
            CommonEncoderType type;
            std::string encoder;
            std::string plugin;
            std::string full_command;
            int enabled;

            int bitrate;
            int use_vbr;
            float vbr_quality;
            int use_high_quality;
            int use_crc;
            std::string extra_options;
        } mp3;

        struct _ogg
        {
            CommonEncoderType type;
            std::string encoder;
            std::string plugin;
            std::string full_command;
            int enabled;

            int use_quality;
            float vbr_quality;
            int bitrate;        // Average
            //int min_bitrate;    // --managed options
            //int max_bitrate;
            std::string extra_options;
        } ogg;

        struct _flac
        {
            CommonEncoderType type;
            std::string encoder;
            std::string plugin;
            std::string full_command;
            int enabled;

            int compression_level;
            std::string extra_options;
        } flac;

        struct _musepack
        {
            CommonEncoderType type;
            std::string encoder;
            std::string plugin;
            std::string full_command;
            int enabled;

            // int use_vbr;        // Always vbr
            float vbr_quality;
            std::string extra_options;
        } musepack;

        struct _opus
        {
            CommonEncoderType type;
            std::string encoder;
            std::string plugin;
            std::string full_command;
            int enabled;

            int bitrate;
            std::string extra_options;
        } opus;
    } encoder;

    void getencoder_common_data(encoder_common_data &ecommon, CommonEncoderType type)
    {
        ecommon.type = type;

        switch (type)
        {
            case MP3:
            {
                ecommon.enabled = encoder.mp3.enabled;
                ecommon.encoder = encoder.mp3.encoder;
                ecommon.plugin = encoder.mp3.plugin;
                ecommon.full_command = encoder.mp3.full_command;
                break;
            }
            case OGG:
            {
                ecommon.enabled = encoder.ogg.enabled;
                ecommon.encoder = encoder.ogg.encoder;
                ecommon.plugin = encoder.ogg.plugin;
                ecommon.full_command = encoder.ogg.full_command;
                break;
            }
            case FLAC:
            {
                ecommon.enabled = encoder.flac.enabled;
                ecommon.encoder = encoder.flac.encoder;
                ecommon.plugin = encoder.flac.plugin;
                ecommon.full_command = encoder.flac.full_command;
                break;
            }
            case MUSE:
            {
                ecommon.enabled = encoder.musepack.enabled;
                ecommon.encoder = encoder.musepack.encoder;
                ecommon.plugin = encoder.musepack.plugin;
                ecommon.full_command = encoder.musepack.full_command;
                break;
            }
            case OPUS:
            {
                ecommon.enabled = encoder.opus.enabled;
                ecommon.encoder = encoder.opus.encoder;
                ecommon.plugin = encoder.opus.plugin;
                ecommon.full_command = encoder.opus.full_command;
                break;
            }
            case MP2:
            {
                ecommon.enabled = encoder.mp2.enabled;
                ecommon.encoder = encoder.mp2.encoder;
                ecommon.plugin = encoder.mp2.plugin;
                ecommon.full_command = encoder.mp2.full_command;
                break;
            }
            case WAV:
            case CD:
            case NO_TYPE:
            {
                ecommon.enabled = 1;
                ecommon.encoder = "";
                ecommon.plugin = "";
                ecommon.full_command = "";
                break;
            }

            default: throw std::out_of_range("type");
        }
    }

    struct _player
    {
        std::string command;
    } wav_player, mp3_player;

    struct _cd_player
    {
        std::string play_command;
        std::string stop_command;
    } cd_player;

    struct _cddb_config
    {
        std::string server;
        int port;
        int use_http;
        int convert_spaces;
        int make_directories;
        int create_id3;
        int create_playlist;
        int split_title;
        int auto_lookup;
        std::string format_string;
        std::string dir_format_string;
        std::string proxy_server;
        int proxy_port;
    } cddb_config;
} _config;

extern _config config;

typedef MainData _main_data;

struct StatByType 
{
    int track;
    time_t time_elapsed, time_remain;
    float progress;
    CommonEncoderType type;
};

typedef struct
{
    StatByType wav, mp3;
    std::string src_file_name;
    std::string dest_file_name;
    time_t total_time_elapsed;
    time_t total_time_remain;
    float total_progress;
    int tracks_done;
    int tracks_remain;
    int ripping;
    int encoding;
} _stat;

enum CommonLocation
{
    SELECT_FRAME,
    STATUS_FRAME,
    CONFIG_WINDOW
};

extern enum CommonLocation where_now;

#endif
