/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.vcs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.diff.collectors.FileRevision;
import com.intellij.swagger.core.diff.collectors.SwFileHistoryCollector;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/swagger/core/diff/vcs/VcsFileRevisionCollector;", "Lcom/intellij/swagger/core/diff/collectors/SwFileHistoryCollector;", "<init>", "()V", "isAvailableFor", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "collectFileSnapshots", "", "Lcom/intellij/swagger/core/diff/collectors/FileRevision;", "getDiffProvider", "Lcom/intellij/openapi/vcs/diff/DiffProvider;", "intellij.swagger.core"})
public final class VcsFileRevisionCollector
implements SwFileHistoryCollector {
    @Override
    public boolean isAvailableFor(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.getDiffProvider(psiFile) != null;
    }

    @Override
    @NotNull
    public Collection<FileRevision> collectFileSnapshots(@NotNull PsiFile psiFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        DiffProvider diffProvider = this.getDiffProvider(psiFile);
        if (diffProvider == null) {
            return CollectionsKt.emptyList();
        }
        DiffProvider diffProvider2 = diffProvider;
        ItemLatestState itemLatestState = diffProvider2.getLastRevision(psiFile.getVirtualFile());
        if (itemLatestState == null || (itemLatestState = itemLatestState.getNumber()) == null) {
            return CollectionsKt.emptyList();
        }
        ItemLatestState lastRevision = itemLatestState;
        ContentRevision contentRevision = diffProvider2.createFileContent((VcsRevisionNumber)lastRevision, psiFile.getVirtualFile());
        if (contentRevision == null) {
            return CollectionsKt.emptyList();
        }
        ContentRevision revision = contentRevision;
        try {
            string = revision.getContent();
        }
        catch (VcsException ex) {
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String content = string2;
        String string3 = revision.getRevisionNumber().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        FileType fileType = revision.getFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return CollectionsKt.listOf((Object)new FileRevision(content, string3, fileType));
    }

    private final DiffProvider getDiffProvider(PsiFile psiFile) {
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)psiFile.getProject()).getVcsFor(psiFile.getVirtualFile());
        return abstractVcs != null ? abstractVcs.getDiffProvider() : null;
    }
}

