/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonSchemaSpellcheckerClient;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JsonSpellcheckerStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final Pattern CODE_LIKE_PATTERN = Pattern.compile("\"" + String.valueOf(CODE_IDENTIFIER_LIKE) + "\"");
    private final Tokenizer<JsonStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonStringLiteral>(){

        public void tokenize(@NotNull JsonStringLiteral element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element.textContains('\\')) {
                List fragments = element.getTextFragments();
                for (Pair fragment : fragments) {
                    TextRange fragmentRange = (TextRange)fragment.getFirst();
                    String escaped = (String)fragment.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer.consumeToken((PsiElement)element, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), (Splitter)textSplitter);
                }
            } else {
                consumer.consumeToken((PsiElement)element, (Splitter)textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/json/JsonSpellcheckerStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    protected boolean isLiteral(@NotNull PsiElement element) {
        if (element == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(0);
        }
        return super.isLiteral(element) || !super.isComment(element) && !CODE_LIKE_PATTERN.matcher(element.getText()).matches();
    }

    @NotNull
    public Tokenizer<?> getTokenizer(PsiElement element) {
        if (element instanceof JsonStringLiteral) {
            if (JsonSpellcheckerStrategy.isInjectedLanguageFragment((PsiElement)element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JsonSpellcheckerStrategy.$$$reportNull$$$0(1);
                }
                return tokenizer;
            }
            Tokenizer<JsonStringLiteral> tokenizer = new JsonSchemaSpellcheckerClientForJson((JsonStringLiteral)element).matchesNameFromSchema() ? EMPTY_TOKENIZER : this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonSpellcheckerStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(3);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/JsonSpellcheckerStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/JsonSpellcheckerStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class JsonSchemaSpellcheckerClientForJson
    extends JsonSchemaSpellcheckerClient {
        @NotNull
        private final JsonStringLiteral element;

        private JsonSchemaSpellcheckerClientForJson(@NotNull JsonStringLiteral element) {
            if (element == null) {
                JsonSchemaSpellcheckerClientForJson.$$$reportNull$$$0(0);
            }
            this.element = element;
        }

        @NotNull
        protected JsonStringLiteral getElement() {
            JsonStringLiteral jsonStringLiteral = this.element;
            if (jsonStringLiteral == null) {
                JsonSchemaSpellcheckerClientForJson.$$$reportNull$$$0(1);
            }
            return jsonStringLiteral;
        }

        @Override
        @NotNull
        protected String getValue() {
            String string = this.element.getValue();
            if (string == null) {
                JsonSchemaSpellcheckerClientForJson.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/json/JsonSpellcheckerStrategy$JsonSchemaSpellcheckerClientForJson";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/json/JsonSpellcheckerStrategy$JsonSchemaSpellcheckerClientForJson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

