/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.presentation;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramNodeRenderer;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.EditEdgeHandler;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.find.FindUtil;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.graph.EdgeRealizerProvider;
import com.intellij.openapi.graph.GraphLayoutOrientation;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.layout.CanonicMultiStageLayouter;
import com.intellij.openapi.graph.layout.EdgeLabelModel;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.PreferredPlacementDescriptor;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphNodeRealizerService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.CreateEdgeMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DRenderer;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphBuilderDisplay;
import com.intellij.openapi.graph.view.HotSpotMode;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.MovePortMode;
import com.intellij.openapi.graph.view.MoveSelectionMode;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.OrthogonalMoveBendsMode;
import com.intellij.openapi.graph.view.Port;
import com.intellij.openapi.graph.view.SmartEdgeLabelModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.core.actions.DeleteNodeContentAction;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.core.actions.UmlNewAction;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.core.actions.ordering.DiagramChangeOrderingActionGroup;
import com.intellij.uml.core.actions.popup.AddElementsFromPopupAction;
import com.intellij.uml.core.actions.scopes.UmlScopesActionGroup;
import com.intellij.uml.core.actions.visibility.UmlVisibilityActionGroup;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.editors.DiagramNodeCellEditor;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.messages.MessageBusListener;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class DiagramPresentationModelImpl
extends DiagramPresentationModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiagramProvider<?> myProvider;
    @GuardedBy(value="myActionsLock")
    @NotNull
    private final DefaultActionGroup myElementProvidersActions;
    @GuardedBy(value="myActionsLock")
    @NotNull
    private final DefaultActionGroup myExtraActions;
    @NotNull
    private final Object myActionsLock;
    @NotNull
    private final NotNullLazyValue<NodeCellRenderer> myRenderer;
    @Nullable
    private final UmlNodeHighlighter myNodeHighlighter;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    protected final SimpleModificationTracker myUpdateTracker;
    @NotNull
    protected final NotNullLazyValue<ModificationTracker> myModificationTrackerOfViewUpdates;
    @NotNull
    protected final NotNullLazyValue<ModificationTracker> myZoomChangedModTracker;

    public DiagramPresentationModelImpl(@NotNull Graph2D graph, @NotNull Project project, @NotNull DiagramProvider<?> provider) {
        if (graph == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(2);
        }
        super(graph);
        this.myElementProvidersActions = new DefaultActionGroup();
        this.myExtraActions = new DefaultActionGroup();
        this.myActionsLock = new Object();
        this.myRenderer = NotNullLazyValue.atomicLazy(() -> this.createRenderer());
        this.myUpdateTracker = new SimpleModificationTracker();
        this.myModificationTrackerOfViewUpdates = NotNullLazyValue.atomicLazy(this::createModificationTrackerOfViewUpdates);
        this.myZoomChangedModTracker = NotNullLazyValue.atomicLazy(this::createZoomChangedModificationTracker);
        this.myAlarm = new Alarm((Disposable)this);
        this.myProject = project;
        this.myProvider = provider;
        DiagramExtras<?> extras = provider.getExtras();
        this.myNodeHighlighter = extras.getNodeHighlighter();
        MessageBusListener<?> listener = DiagramPresentationModelImpl.getMessageBusListener(project, graph);
        project.getMessageBus().connect((Disposable)this).subscribe(listener.getTopic(), listener.getListener());
    }

    @Override
    @NotNull
    public DiagramBuilder getDiagramBuilder() {
        DiagramBuilder diagramBuilder = (DiagramBuilder)super.getGraphBuilder();
        if (diagramBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(3);
        }
        return diagramBuilder;
    }

    public void setGraphBuilder(@NotNull GraphBuilder<DiagramNode<?>, DiagramEdge<?>> graphBuilder) {
        if (graphBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(4);
        }
        graphBuilder.addGraphBuilderListener((GraphBuilderListener)this, (Disposable)this);
        super.setGraphBuilder(graphBuilder);
    }

    @NotNull
    protected DiagramProvider<?> getProvider() {
        DiagramProvider<?> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(5);
        }
        return diagramProvider;
    }

    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable DiagramNode node) {
        GenericNodeRealizer realizer = GraphNodeRealizerService.getInstance().createGenericNodeRealizer("UmlNodeInfoRenderer", (NodeCellRenderer)this.getRenderer());
        if (node != null) {
            realizer.setFillColor(this.getProvider().getColorManager().getNodeSloppyBackgroundColor(this.getBuilder(), node, false));
        }
        GenericNodeRealizer genericNodeRealizer = realizer;
        if (genericNodeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(6);
        }
        return genericNodeRealizer;
    }

    @NotNull
    public NodeRealizer getNodeRealizer(@NotNull GraphBuilder<DiagramNode<?>, DiagramEdge<?>> builder, @Nullable DiagramNode<?> node) {
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(7);
        }
        DiagramBuilder diagramBuilder = DiagramBuilderFactory.getInstance().fromGraphBuilder(builder, this.getBuilder());
        GenericNodeRealizer realizer = GraphNodeRealizerService.getInstance().createGenericNodeRealizer("UmlNodeInfoRenderer", this.createRenderer(diagramBuilder));
        if (node != null) {
            realizer.setFillColor(this.getProvider().getColorManager().getNodeSloppyBackgroundColor(this.getBuilder(), node, false));
        }
        GenericNodeRealizer genericNodeRealizer = realizer;
        if (genericNodeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(8);
        }
        return genericNodeRealizer;
    }

    @NotNull
    protected NodeCellRenderer createRenderer(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(9);
        }
        return new DefaultUmlRenderer(builder, this.getModificationTrackerOfViewUpdates());
    }

    @NotNull
    protected NodeCellRenderer createRenderer() {
        return new DefaultUmlRenderer(this.getBuilder(), this.getModificationTrackerOfViewUpdates());
    }

    @Override
    @NotNull
    public DiagramNodeRenderer getRenderer() {
        DiagramNodeRenderer diagramNodeRenderer = (DiagramNodeRenderer)this.myRenderer.getValue();
        if (diagramNodeRenderer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(10);
        }
        return diagramNodeRenderer;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTrackerOfViewUpdates() {
        ModificationTracker modificationTracker = (ModificationTracker)this.myModificationTrackerOfViewUpdates.getValue();
        if (modificationTracker == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(11);
        }
        return modificationTracker;
    }

    @NotNull
    protected ModificationTracker createModificationTrackerOfViewUpdates() {
        return new ModificationTracker(){
            final ModificationTracker modificationTracker;
            long myCount;
            {
                this.modificationTracker = DiagramPresentationModelImpl.this.getBuilder().getDataModel().getModificationTracker();
                this.myCount = this.modificationTracker.getModificationCount();
            }

            public long getModificationCount() {
                long count = this.modificationTracker.getModificationCount();
                if (this.myCount != count) {
                    this.myCount = count;
                    DiagramPresentationModelImpl.this.scheduleDataModelRefresh();
                }
                return count + DiagramPresentationModelImpl.this.myUpdateTracker.getModificationCount();
            }
        };
    }

    private void scheduleDataModelRefresh() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this::refreshModelWhenSmart, 300);
    }

    protected void refreshModelWhenSmart() {
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.getBuilder()).runAsync().thenRunAsync(() -> {
            this.update();
            this.stopCurrentCellEditor();
        }, this.getBuilder().getGraphBuilder().getActionExecutor().getGraphExecutor()));
    }

    protected void stopCurrentCellEditor() {
        if (DiagramNodeEditingManager.getInstance().isEditing()) {
            DiagramNodeEditingManager.getInstance().stopEditing(this.getBuilder());
        }
    }

    @NotNull
    private ModificationTracker createZoomChangedModificationTracker() {
        GraphBuilder<DiagramNode<?>, DiagramEdge<?>> builder = Objects.requireNonNull(this.getBuilder().getGraphBuilder(), "Cannot create ZoomChangedModificationTracker until GraphBuilder has been set");
        final SimpleModificationTracker modTracker = new SimpleModificationTracker();
        builder.addGraphBuilderListener(new GraphBuilderListener(){

            public void beforeActionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphBuilderEvent event) {
                if (builder == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void actionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphBuilderEvent event) {
                if (builder == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (GraphBuilderEvent.ZOOM_CHANGED.equals((Object)event)) {
                    modTracker.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        SimpleModificationTracker simpleModificationTracker = modTracker;
        if (simpleModificationTracker == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(12);
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTrackerOfZoomChanged() {
        ModificationTracker modificationTracker = (ModificationTracker)this.myZoomChangedModTracker.getValue();
        if (modificationTracker == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(13);
        }
        return modificationTracker;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable DiagramEdge edge) {
        EdgeRealizer edgeRealizer = this.getEdgeRealizer(this.getSettings().getCurrentEdgeRealizerProvider(), edge);
        if (edgeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(14);
        }
        return edgeRealizer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(@NotNull EdgeRealizerProvider provider, @Nullable DiagramEdge<?> edge) {
        if (provider == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(15);
        }
        EdgeRealizer edgeRealizer = provider.createEdgeRealizer();
        if (edge != null) {
            DiagramRelationshipInfo info = edge.getRelationship();
            DiagramLineType lineType = info.getLineType();
            DiagramColorManager colorManager = this.getProvider().getColorManager();
            Color lineColor = edge instanceof DiagramNoteEdge ? ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.4) : colorManager.getEdgeColor(this.getBuilder(), edge);
            Port sourcePort = GraphManager.getGraphManager().createPort();
            Port targetPort = GraphManager.getGraphManager().createPort();
            sourcePort.setColor(colorManager.getPortColor(this.getBuilder()));
            targetPort.setColor(colorManager.getPortColor(this.getBuilder()));
            edgeRealizer.setLineColor(lineColor);
            edgeRealizer.setBendsColor(colorManager.getBendColor(this.getBuilder()));
            edgeRealizer.setLineType(DiagramPresentationModelImpl.toGraphLineType(info.getWidth(), lineType != null ? lineType : DiagramLineType.SOLID));
            edgeRealizer.setSourceArrow(DiagramRelationshipInfo.Arrows.getArrow(info.getSourceArrow()));
            edgeRealizer.setTargetArrow(DiagramRelationshipInfo.Arrows.getArrow(info.getTargetArrow()));
            edgeRealizer.setSourcePort(sourcePort);
            edgeRealizer.setTargetPort(targetPort);
        } else {
            edgeRealizer.setTargetArrow(Arrow.STANDARD);
            edgeRealizer.setLineColor((Color)new JBColor(Color.BLACK, Color.WHITE));
            edgeRealizer.setLineType(LineType.Statics.getLineType((int)2, (byte)LineType.LINE_1.getLineStyle()));
        }
        EdgeRealizer edgeRealizer2 = edgeRealizer;
        if (edgeRealizer2 == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(16);
        }
        return edgeRealizer2;
    }

    @Nullable
    private EdgeLabel createEdgeLabel(@Nullable DiagramRelationshipInfo.Label label, @NotNull PreferredPlacementDescriptor placementDescriptor) {
        if (placementDescriptor == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(17);
        }
        if (label == null) {
            return null;
        }
        EdgeLabel edgeLabel = GraphManager.getGraphManager().createEdgeLabel(label.getText());
        SmartEdgeLabelModel model = GraphManager.getGraphManager().createSmartEdgeLabelModel();
        edgeLabel.setLabelModel((EdgeLabelModel)model, model.getDefaultParameter());
        edgeLabel.setPreferredPlacementDescriptor(placementDescriptor);
        edgeLabel.setTextColor(Optional.ofNullable(label.getColor()).orElseGet(() -> this.getBuilder().getColorScheme().getDefaultForeground()));
        return edgeLabel;
    }

    public NodeLabel @NotNull [] getNodeLabels(@Nullable DiagramNode<?> node, @NotNull String nodeName) {
        if (nodeName == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(18);
        }
        NodeLabel[] nodeLabelArray = node == null ? NodeLabel.EMPTY_ARRAY : (NodeLabel[])node.getLabels().toArray(NodeLabel[]::new);
        if (nodeLabelArray == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(19);
        }
        return nodeLabelArray;
    }

    public EdgeLabel @NotNull [] getEdgeLabels(@Nullable DiagramEdge umlEdge, @NotNull String edgeName) {
        if (edgeName == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(20);
        }
        if (umlEdge == null) {
            if (EMPTY_LABELS == null) {
                DiagramPresentationModelImpl.$$$reportNull$$$0(21);
            }
            return EMPTY_LABELS;
        }
        DiagramRelationshipInfo relationship = umlEdge.getRelationship();
        EdgeLabel[] edgeLabelArray = (EdgeLabel[])Stream.of(this.createEdgeLabel(relationship.getUpperCenterLabel(), GraphEdgeRealizerService.getInstance().getUpperCenterDescriptor()), this.createEdgeLabel(relationship.getBottomCenterLabel(), GraphEdgeRealizerService.getInstance().getBottomCenterDescriptor()), this.createEdgeLabel(relationship.getUpperSourceLabel(), GraphEdgeRealizerService.getInstance().getUpperSourceDescriptor()), this.createEdgeLabel(relationship.getBottomSourceLabel(), GraphEdgeRealizerService.getInstance().getBottomSourceDescriptor()), this.createEdgeLabel(relationship.getUpperTargetLabel(), GraphEdgeRealizerService.getInstance().getUpperTargetDescriptor()), this.createEdgeLabel(relationship.getBottomTargetLabel(), GraphEdgeRealizerService.getInstance().getBottomTargetDescriptor())).filter(it -> it != null).toArray(EdgeLabel[]::new);
        if (edgeLabelArray == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(22);
        }
        return edgeLabelArray;
    }

    public boolean editNode(@Nullable DiagramNode node) {
        DiagramBuilder builder = this.getBuilder();
        if (node == null) {
            return false;
        }
        if (node instanceof DiagramNoteNode) {
            this.editNote(builder, (DiagramNoteNode)node);
            return true;
        }
        DiagramExtras extras = node.getProvider().getExtras();
        EditNodeHandler editHandler = extras.getEditNodeHandler();
        if (editHandler != null) {
            editHandler.doEdit(node, this);
            return true;
        }
        if (this.getBuilder().isPopupMode()) {
            Object element = node.getIdentifyingElement();
            if (element instanceof Navigatable) {
                OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{(Navigatable)element});
                return true;
            }
        } else {
            Node nodeObj = builder.getNode(node);
            return nodeObj == null || DiagramPresentationModelImpl.isNodeWithoutBody(builder, nodeObj);
        }
        return super.editNode((Object)node);
    }

    private void editNote(@NotNull DiagramBuilder builder, @NotNull DiagramNoteNode note) {
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(23);
        }
        if (note == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(24);
        }
        String oldText = note.getTooltip();
        String newText = Messages.showMultilineInputDialog((Project)this.myProject, (String)DiagramBundle.message("dialog.message.note.text", new Object[0]), (String)DiagramBundle.message("dialog.title.edit.note", new Object[0]), (String)oldText, (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
        if (newText != null && !newText.equals(oldText)) {
            Runnable editNote = () -> {
                NodeRealizer oldNoteRealizer = builder.getGraph().getRealizer(builder.getNode(note));
                double oldNoteX = oldNoteRealizer.getX();
                double oldNoteY = oldNoteRealizer.getY();
                Object originalNode = note.getIdentifyingElement();
                DiagramDataModel<?> dataModel = builder.getDataModel();
                dataModel.removeNote(note);
                DiagramNoteNode newNoteNode = dataModel.addNote((DiagramNode<?>)originalNode, newText);
                DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(builder).withNodeSizeUpdate(newNoteNode).runAsync().thenRunAsync(() -> DiagramPresentationModelImpl.lambda$editNote$7(builder, dataModel, (DiagramNode)originalNode, oldNoteX, oldNoteY), builder.getGraphBuilder().getActionExecutor().getGraphExecutor());
            };
            DiagramAction.performCommand(builder, editNote, DiagramBundle.message("command.edit.note", new Object[0]), null, new PsiElement[0]);
        }
    }

    private static boolean isNodeWithoutBody(@NotNull DiagramBuilder builder, @NotNull Node node) {
        NodeRealizer realizer;
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(25);
        }
        if (node == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(26);
        }
        if ((realizer = builder.getGraph().getRealizer(node)) == null) {
            return false;
        }
        return realizer.getHeight() < 30.0;
    }

    public boolean editEdge(@Nullable DiagramEdge edge) {
        if (edge == null) {
            return false;
        }
        EditEdgeHandler<?> handler = this.getBuilder().getProvider().getExtras().getEditEdgeHandler();
        DiagramNode src = edge.getSource();
        DiagramNode trg = edge.getTarget();
        if (handler != null && !(src instanceof DiagramNoteNode) && !(trg instanceof DiagramNoteNode) && handler.doEdit(edge, this)) {
            return true;
        }
        PsiElement[] navigationElements = edge.getNavigationElements();
        if (navigationElements.length == 0) {
            return super.editEdge((Object)edge);
        }
        FindUtil.showInUsageView(null, (PsiElement[])navigationElements, (String)DiagramBundle.message("diagram.edge.origins", new Object[0]), (Project)this.myProject);
        return true;
    }

    @Nullable
    public String getNodeTooltip(@Nullable DiagramNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof DiagramNoteNode) {
            return "Note for " + ((DiagramNode)node.getIdentifyingElement()).getTooltip();
        }
        return this.getProvider().getElementManager().getNodeTooltip(node.getIdentifyingElement());
    }

    @Nullable
    public String getEdgeTooltip(@Nullable DiagramEdge edge) {
        return edge != null ? edge.getName() : null;
    }

    public void customizeSettings(@NotNull GraphBuilder<DiagramNode<?>, DiagramEdge<?>> builder) {
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(27);
        }
        super.customizeSettings(builder);
        final DiagramBuilder diagramBuilder = DiagramBuilderFactory.getInstance().fromGraphBuilder(builder, this.getBuilder());
        Graph2DView view = builder.getView();
        view.setFitContentOnResize(false);
        view.setGridVisible(DiagramConfiguration.getInstance().doShowGridByDefault());
        view.setGraph2DRenderer((Graph2DRenderer)GraphManager.getGraphManager().createLayeredGraph2DRenderer());
        view.getCanvasComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof DiagramNodeBodyComponent)) {
                    DiagramNodeEditingManager.getInstance().stopEditing(diagramBuilder);
                }
            }
        });
        EdgeRealizer.Statics.setSelectionStroke((LineType)LineType.LINE_3);
        EditMode editMode = builder.getEditMode();
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(true);
        UmlActions.registerCustomShortcuts(diagramBuilder);
        UmlActions.install(diagramBuilder);
        for (DiagramNodeIntentionAction<?> action : diagramBuilder.getProvider().getNodeIntentionActions()) {
            ShortcutSet shortcut;
            if (!(action instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action).getShortcut()) == null) continue;
            action.registerCustomShortcutSet(shortcut, builder.getView().getCanvasComponent(), (Disposable)builder);
        }
        DiagramPresentationModelImpl.applyDiagramConfigurationTo(builder);
        DiagramExtras<?> extras = diagramBuilder.getProvider().getExtras();
        GraphAnimationService.getInstance().setZoomAnimationEnabledFor(builder, extras.isZoomAnimationsEnabled());
        GraphLayoutService.getInstance().setEdgeLabelingEnabledFor(builder, extras.doEdgeLabeling());
        DiagramPresentationModelImpl.updateColorsOf(diagramBuilder);
        DiagramPresentationModelImpl.setupInitialLayouterFor(diagramBuilder);
        editMode.setOrthogonalEdgeRouting(GraphLayoutService.getInstance().doesImplyOrthogonalEdgeRouting(builder.getGraphPresentationModel().getSettings().getCurrentLayouter()));
    }

    protected static void applyDiagramConfigurationTo(@NotNull GraphBuilder<DiagramNode<?>, DiagramEdge<?>> builder) {
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(28);
        }
        builder.getGraphPresentationModel().getSettings().setShowGrid(DiagramConfiguration.getInstance().doShowGridByDefault());
        builder.getGraphPresentationModel().getSettings().setFitContentAfterLayout(DiagramConfiguration.getInstance().doFitContentAfterLayout());
        boolean isAnimationsEnabled = DiagramConfiguration.getInstance().isAnimationsEnabled() && !AppMode.isRemoteDevHost();
        GraphAnimationService.getInstance().setAnimationEnabledGlobally(isAnimationsEnabled);
        GraphAnimationService.getInstance().setLayoutAnimationDuration(DiagramConfiguration.getInstance().getLayoutAnimationDurationMillis());
    }

    public static void updateColorsOf(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(29);
        }
        Graph2DView view = builder.getView();
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        view.setGridColor(colorManager.getFineGridColor(builder));
        view.setCoarseGridColor(colorManager.getCoarseGridColor(builder));
        view.getJComponent().putClientProperty("selectionbox.fillcolor", colorManager.getSelectionBoxBackgroundColor(builder));
        view.getJComponent().putClientProperty("selectionbox.linecolor", colorManager.getSelectionBoxBorderColor(builder));
        view.getJComponent().putClientProperty("magnifier.linecolor", colorManager.getSelectionBoxBorderColor(builder));
        DiagramPresentationModelImpl.setSnappingColor(builder.getGraphBuilder().getEditMode(), colorManager.getSnappingColor(builder));
    }

    private static void setSnappingColor(@NotNull EditMode editMode, @NotNull Color color) {
        if (editMode == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(30);
        }
        if (color == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(31);
        }
        if (editMode.getHotSpotMode() instanceof HotSpotMode) {
            ((HotSpotMode)editMode.getHotSpotMode()).getSnapContext().setSnapLineColor(color);
        } else if (editMode.getMoveSelectionMode() instanceof MoveSelectionMode) {
            ((MoveSelectionMode)editMode.getMoveSelectionMode()).getSnapContext().setSnapLineColor(color);
        } else if (editMode.getOrthogonalMoveBendsMode() instanceof OrthogonalMoveBendsMode) {
            ((OrthogonalMoveBendsMode)editMode.getOrthogonalMoveBendsMode()).getSnapContext().setSnapLineColor(color);
        } else if (editMode.getCreateEdgeMode() instanceof CreateEdgeMode) {
            ((CreateEdgeMode)editMode.getCreateEdgeMode()).getSnapContext().setSnapLineColor(color);
        } else if (editMode.getMovePortMode() instanceof MovePortMode) {
            ((MovePortMode)editMode.getMovePortMode()).getSnapContext().setSnapLineColor(color);
        }
    }

    private static void setupInitialLayouterFor(@NotNull DiagramBuilder builder) {
        DiagramExtras<?> extras;
        if (builder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(32);
        }
        if ((extras = builder.getProvider().getExtras()).useDefaultLayouter()) {
            return;
        }
        GraphSettings settings = builder.getPresentationModel().getSettings();
        Layouter layouter = extras.getCustomLayouter(settings, builder.getProject());
        if (layouter == null) {
            layouter = DiagramConfiguration.getInstance().getDefaultLayout().getPredefinedLayouter(settings);
        }
        settings.setCurrentLayouter(layouter);
        if (layouter instanceof CanonicMultiStageLayouter) {
            settings.setCurrentLayoutOrientation(GraphLayoutOrientation.fromCode((byte)((CanonicMultiStageLayouter)layouter).getLayoutOrientation()));
        }
    }

    @NotNull
    public EdgeCreationPolicy<DiagramNode<?>> getEdgeCreationPolicy() {
        final DiagramEdgeCreationPolicy<?> policy = this.getProvider().getEdgeCreationPolicy();
        if (policy == null) {
            EdgeCreationPolicy edgeCreationPolicy = EdgeCreationPolicy.NOTHING_ACCEPTED_POLICY;
            if (edgeCreationPolicy == null) {
                DiagramPresentationModelImpl.$$$reportNull$$$0(33);
            }
            return edgeCreationPolicy;
        }
        return new EdgeCreationPolicy<DiagramNode<?>>(){

            public boolean acceptSource(@NotNull DiagramNode source) {
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                return policy.acceptSource(source);
            }

            public boolean acceptTarget(@NotNull DiagramNode target) {
                if (target == null) {
                    4.$$$reportNull$$$0(1);
                }
                return policy.acceptTarget(target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptTarget";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public NodeCellEditor getCustomNodeCellEditor(@Nullable DiagramNode umlNode) {
        return new DiagramNodeCellEditor(this.getBuilder());
    }

    @NotNull
    public DefaultActionGroup getNodeActionGroup(@Nullable DiagramNode info) {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(34);
        }
        return defaultActionGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected DefaultActionGroup getCommonActionGroup() {
        DefaultActionGroup actions = new DefaultActionGroup();
        DiagramExtras<?> extras = this.getBuilder().getProvider().getExtras();
        AnAction handler = this.getBuilder().getProvider().getExtras().getAddElementHandler();
        if (!extras.isSourceActionsImplemented() && handler != null && !this.getBuilder().isPopupMode()) {
            actions.add(handler);
        }
        if (extras.isSourceActionsImplemented()) {
            actions.add(this.getSourceActionGroup());
            actions.add((AnAction)this.getChangeDiagramContentActionGroup());
            actions.addSeparator();
        }
        Object object = this.myActionsLock;
        synchronized (object) {
            if (this.myElementProvidersActions.getChildrenCount() > 0) {
                actions.addAll((ActionGroup)this.myElementProvidersActions);
                actions.addSeparator();
            }
            if (this.myExtraActions.getChildrenCount() > 0) {
                actions.addAll((ActionGroup)this.myExtraActions);
                actions.addSeparator();
            }
        }
        if (extras.isExpandCollapseActionsImplemented()) {
            actions.add(ActionManager.getInstance().getAction("Uml.CollapseNodes"));
            actions.add(ActionManager.getInstance().getAction("Uml.ExpandNodes"));
            actions.addSeparator();
        }
        if (extras.isDeleteActionImplemented()) {
            actions.add(ActionManager.getInstance().getAction("Diagram.DeleteSelection"));
            actions.addSeparator();
        }
        actions.add(ActionManager.getInstance().getAction("UML.DefaultGraphPopup"));
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(35);
        }
        return defaultActionGroup;
    }

    @NotNull
    protected AnAction getSourceActionGroup() {
        AnAction anAction = ActionManager.getInstance().getAction("UML.SourceActionsGroup");
        if (anAction == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(36);
        }
        return anAction;
    }

    @NotNull
    private DefaultActionGroup getChangeDiagramContentActionGroup() {
        DiagramScopeManager<?> scopeManager;
        UmlVisibilityActionGroup visibility;
        DiagramChangeOrderingActionGroup orderingGroup;
        DefaultActionGroup categories;
        DefaultActionGroup actions = new DefaultActionGroup(DiagramBundle.message("group.change.content.name", new Object[0]), true);
        AnAction handler = this.getBuilder().getProvider().getExtras().getAddElementHandler();
        if (handler != null && !this.getBuilder().isPopupMode()) {
            actions.add(handler);
        }
        if (!this.getBuilder().isPopupMode()) {
            actions.add((AnAction)new ActionGroup(DiagramBundle.message("group.action.text.new", new Object[0]), true){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    if (e == null) {
                        if (EMPTY_ARRAY == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return EMPTY_ARRAY;
                    }
                    AnAction[] anActionArray = new UmlNewAction().getGroup(e.getDataContext()).getChildren(e);
                    if (anActionArray == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return anActionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/presentation/DiagramPresentationModelImpl$5", "getChildren"));
                }
            });
        }
        if (this.allowChangeVisibleCategories() && (categories = UmlActions.getCategoriesActions(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)categories);
        }
        if ((orderingGroup = new DiagramChangeOrderingActionGroup(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)orderingGroup);
        }
        if (this.getBuilder().getDataModel().isDependencyDiagramSupported()) {
            actions.add((AnAction)new UmlShowDependencies());
        }
        if ((visibility = new UmlVisibilityActionGroup(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)visibility);
        }
        if ((scopeManager = this.getBuilder().getDataModel().getScopeManager()) != null) {
            UmlScopesActionGroup actionGroup = new UmlScopesActionGroup(this.getBuilder(), scopeManager);
            actions.add((AnAction)actionGroup);
        }
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(37);
        }
        return defaultActionGroup;
    }

    @GuardedBy(value="myActionsLock")
    private void registerElementProvidersActions() {
        for (DiagramElementsProvider<?> elementsProvider : this.getProvider().getExtras().getElementsProviders()) {
            this.myElementProvidersActions.add((AnAction)new AddElementsFromPopupAction(elementsProvider, this.getBuilder()));
        }
    }

    @GuardedBy(value="myActionsLock")
    private void registerExtraActions() {
        for (AnAction action : this.getProvider().getExtras().getExtraActions()) {
            this.myExtraActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerActions() {
        Object object = this.myActionsLock;
        synchronized (object) {
            this.myElementProvidersActions.removeAll();
            this.myExtraActions.removeAll();
            this.registerElementProvidersActions();
            this.registerExtraActions();
        }
        new DeleteNodeContentAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), this.getBuilder().getView().getCanvasComponent());
    }

    @Override
    public void update() {
        this.myUpdateTracker.incModificationCount();
    }

    public boolean isAutoRotateLabels() {
        return true;
    }

    private static LineType toGraphLineType(int width, DiagramLineType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DiagramLineType.DASHED -> LineType.Statics.getLineType((int)width, (byte)LineType.DASHED_1.getLineStyle());
            case DiagramLineType.DOTTED -> LineType.Statics.getLineType((int)width, (byte)LineType.DOTTED_2.getLineStyle());
            case DiagramLineType.DASHED_DOTTED -> LineType.Statics.getLineType((int)width, (byte)LineType.DASHED_DOTTED_1.getLineStyle());
            case DiagramLineType.SOLID -> LineType.Statics.getLineType((int)width, (byte)LineType.LINE_1.getLineStyle());
        };
    }

    public void onSelectionChanged(@NotNull Graph2DSelectionEvent e) {
        List selectedNodes;
        if (e == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(38);
        }
        if ((selectedNodes = DiagramSelectionService.getInstance().getSelectedNodes(this.getBuilder())).isEmpty()) {
            DiagramNodeEditingManager.getInstance().dropLastActiveNodeEditor();
        }
        this.dropHighlightingFlag();
        if (this.myNodeHighlighter != null) {
            this.myNodeHighlighter.selectionChanged(this.getBuilder());
            selectedNodes.removeIf(it -> it instanceof DiagramNoteNode);
            if (!selectedNodes.isEmpty()) {
                List nodesToHighlight = this.myNodeHighlighter.onNodeSelected(selectedNodes, this.getBuilder().getDataModel());
                for (DiagramNode umlNode : nodesToHighlight) {
                    umlNode.putUserData(DiagramNode.SELECTED_NODE_KEY, true);
                }
            }
        }
    }

    private void dropHighlightingFlag() {
        for (DiagramNode<?> node : this.getBuilder().getNodeObjects()) {
            node.putUserData(DiagramNode.SELECTED_NODE_KEY, null);
        }
    }

    @Nullable
    public VirtualFile getStructureViewTargetFile() {
        return Optional.ofNullable((DiagramNode)GraphSelectionService.getInstance().getSingleSelectedModelNode(this.getBuilder().getGraphBuilder())).filter(__ -> this.getSettings().isShowStructureViewForSelectedNode()).map(it -> (PsiElement)ObjectUtils.tryCast(it.getIdentifyingElement(), PsiElement.class)).map(it -> it.getContainingFile()).map(it -> it.getVirtualFile()).orElse(null);
    }

    @NotNull
    public DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = (DiagramBuilder)this.getGraphBuilder();
        if (diagramBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(39);
        }
        return diagramBuilder;
    }

    @NotNull
    public GraphBuilderDisplay getGraphViewDisplay() {
        GraphBuilderDisplay graphBuilderDisplay = Optional.ofNullable(this.getBuilder().getEditor()).map(it -> (UmlFileEditorImpl)ObjectUtils.tryCast((Object)it, UmlFileEditorImpl.class)).orElseThrow();
        if (graphBuilderDisplay == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(40);
        }
        return graphBuilderDisplay;
    }

    @NotNull
    private static MessageBusListener<?> getMessageBusListener(final @NotNull Project project, final @NotNull Graph2D graph) {
        if (project == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(41);
        }
        if (graph == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(42);
        }
        return new MessageBusListener<PsiDocumentTransactionListener>(){

            @NotNull
            public Topic<PsiDocumentTransactionListener> getTopic() {
                Topic topic = PsiDocumentTransactionListener.TOPIC;
                if (topic == null) {
                    6.$$$reportNull$$$0(0);
                }
                return topic;
            }

            @NotNull
            public PsiDocumentTransactionListener getListener() {
                return new PsiDocumentTransactionListener(){

                    public void transactionStarted(@NotNull Document doc, @NotNull PsiFile psiFile) {
                        if (doc == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (psiFile == null) {
                            1.$$$reportNull$$$0(1);
                        }
                    }

                    public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile psiFile) {
                        if (doc == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (psiFile == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        for (VirtualFile vf : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                            if (!FileTypeRegistry.getInstance().isFileOfType(vf, (FileType)DiagramFileType.INSTANCE)) continue;
                            graph.updateViews();
                            return;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "doc";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "psiFile";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl$6$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "transactionStarted";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "transactionCompleted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/presentation/DiagramPresentationModelImpl$6", "getTopic"));
            }
        };
    }

    private static /* synthetic */ void lambda$editNote$7(DiagramBuilder builder, DiagramDataModel dataModel, DiagramNode originalNode, double oldNoteX, double oldNoteY) {
        NodeRealizer newNoteRealizer = builder.getGraph().getRealizer(builder.getNode(dataModel.getNotes().get(originalNode)));
        newNoteRealizer.setX(oldNoteX);
        newNoteRealizer.setY(oldNoteY);
        builder.getGraph().updateViews();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 10, 11, 12, 13, 14, 16, 19, 21, 22, 33, 34, 35, 36, 37, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/presentation/DiagramPresentationModelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphBuilder";
                break;
            }
            case 7: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placementDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagramBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTrackerOfViewUpdates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createZoomChangedModificationTracker";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTrackerOfZoomChanged";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLabels";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeCreationPolicy";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActionGroup";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonActionGroup";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceActionGroup";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeDiagramContentActionGroup";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphViewDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGraphBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRealizer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeRealizer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEdgeLabel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNodeLabels";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeLabels";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "editNote";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isNodeWithoutBody";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyDiagramConfigurationTo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateColorsOf";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setSnappingColor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupInitialLayouterFor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "onSelectionChanged";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getMessageBusListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 10, 11, 12, 13, 14, 16, 19, 21, 22, 33, 34, 35, 36, 37, 39, 40 -> new IllegalStateException(string);
        };
    }
}

