/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/python/scientific/cells/PyCellInspectionExtension;", "Lcom/jetbrains/python/inspections/PyInspectionExtension;", "<init>", "()V", "ignoreNoEffectStatement", "", "expressionStatement", "Lcom/jetbrains/python/psi/PyExpressionStatement;", "isLastStatementInCellOrFile", "statement", "intellij.python.scientific"})
public final class PyCellInspectionExtension
extends PyInspectionExtension {
    public boolean ignoreNoEffectStatement(@NotNull PyExpressionStatement expressionStatement) {
        Intrinsics.checkNotNullParameter((Object)expressionStatement, (String)"expressionStatement");
        if (PlatformUtils.isDataSpell() ? !(expressionStatement.getParent() instanceof PyFile) : !(expressionStatement.getParent() instanceof PyFile) || !PyCellUtil.hasCells((PsiFile)expressionStatement.getContainingFile())) {
            return false;
        }
        return this.isLastStatementInCellOrFile(expressionStatement);
    }

    private final boolean isLastStatementInCellOrFile(PyExpressionStatement statement) {
        Sequence sequence = PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)statement), (boolean)false, (boolean)false, (int)1, null);
        TokenSet tokenSet = TokenSet.WHITE_SPACE;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACE");
        PsiElement nextExpression = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNot((Sequence)PsiTreeUtilKt.skipTokens((Sequence)sequence, (TokenSet)tokenSet), PyCellInspectionExtension::isLastStatementInCellOrFile$lambda$0));
        return nextExpression == null || PyCellUtil.isBlockCell((PsiElement)nextExpression);
    }

    private static final boolean isLastStatementInCellOrFile$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiComment && !PyCellUtil.isBlockCell((PsiElement)it);
    }
}

