/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQNewCommand
extends HgCommitTypeCommand {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yy_MM_dd_HH-mm-ss");

    public HgQNewCommand(@NotNull Project project, @NotNull HgRepository repository, String message, boolean amend) {
        if (project == null) {
            HgQNewCommand.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            HgQNewCommand.$$$reportNull$$$0(1);
        }
        super(project, repository, message, amend);
    }

    @Override
    protected void executeChunked(@NotNull List<List<String>> chunkedCommits) throws VcsException {
        if (chunkedCommits == null) {
            HgQNewCommand.$$$reportNull$$$0(2);
        }
        if (chunkedCommits.isEmpty()) {
            this.executeQNewInCurrentThread(ContainerUtil.emptyList());
        } else {
            int size = chunkedCommits.size();
            int i = 0;
            if (!this.myAmend) {
                this.executeQNewInCurrentThread(chunkedCommits.get(0));
                i = 1;
            }
            while (i < size) {
                this.executeQRefreshInCurrentThread(chunkedCommits.get(i));
                ++i;
            }
        }
        this.myRepository.update();
        ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
    }

    private void executeQRefreshInCurrentThread(@NotNull List<String> chunkFiles) throws VcsException {
        if (chunkFiles == null) {
            HgQNewCommand.$$$reportNull$$$0(3);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-l");
        args.add(this.saveCommitMessage().getAbsolutePath());
        args.add("-s");
        args.addAll(chunkFiles);
        HgCommandResult result = new HgCommandExecutor(this.myProject).executeInCurrentThread(this.myRepository.getRoot(), "qrefresh", args);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(this.myProject).notifyError("hg.qrefresh.error", result, HgBundle.message("action.hg4idea.QRefresh.error", new Object[0]), HgBundle.message("action.hg4idea.QRefresh.error.msg", new Object[0]));
        }
    }

    private void executeQNewInCurrentThread(@NotNull List<String> chunkFiles) throws VcsException {
        if (chunkFiles == null) {
            HgQNewCommand.$$$reportNull$$$0(4);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-l");
        args.add(this.saveCommitMessage().getAbsolutePath());
        args.add("-UD");
        String patchName = DATE_FORMAT.format(new Date()).concat(".diff");
        args.add(patchName);
        args.addAll(chunkFiles);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        HgCommandResult result = executor.executeInCurrentThread(this.myRepository.getRoot(), "qnew", args);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(this.myProject).notifyError("hg.qnew.error", result, HgBundle.message("action.hg4idea.QNew.error", new Object[0]), HgBundle.message("action.hg4idea.QNew.error.msg", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkedCommits";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkFiles";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/mq/HgQNewCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeChunked";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeQRefreshInCurrentThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeQNewInCurrentThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

