/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceExport;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.ecmascript6.resolve.JSModuleExportsProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flow.FlowJSStubElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExportScopeProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSExportScope;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.EXPORT_DECLARATION});
    private static final TokenSet EXPORT_DEFAULT_DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.EXPORT_DEFAULT_ASSIGNMENT, FlowJSStubElementTypes.DECLARE_EXPORT_DECLARATION});
    public static final String DEFAULT_NAME = "default";

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(elements, el -> {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(el);
            if (assignment != null) {
                return assignment;
            }
            return el;
        });
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(2);
        }
        return (JSElement)ContainerUtil.getFirstItem(ES6PsiUtil.findDefaultExports(scopeElement, true));
    }

    @NotNull
    public static Collection<JSElement> findDefaultExports(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(3);
        }
        return ES6PsiUtil.findDefaultExports(scopeElement, false);
    }

    @NotNull
    private static Collection<JSElement> findDefaultExports(@NotNull PsiElement scopeElement, boolean firstOnly) {
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(4);
        }
        Stream<JSExportAssignment> stream = JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(scopeElement, EXPORT_DEFAULT_DECLARATIONS, JSExportAssignment.class);
        if (firstOnly) {
            Optional<JSExportAssignment> candidate = stream.findAny();
            if (candidate.isPresent()) {
                Set<JSElement> set = Collections.singleton((JSElement)candidate.get());
                if (set == null) {
                    ES6PsiUtil.$$$reportNull$$$0(5);
                }
                return set;
            }
        } else {
            List<JSElement> exportDefaultAssignments = stream.collect(Collectors.toList());
            if (!exportDefaultAssignments.isEmpty()) {
                List<JSElement> list = exportDefaultAssignments;
                if (list == null) {
                    ES6PsiUtil.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        final Ref resultElement = Ref.create();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(DEFAULT_NAME){

            public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element2 instanceof ES6ExportSpecifierAlias || element2 instanceof ES6ExportSpecifier || element2 instanceof ES6NamespaceExport || element2 instanceof ES6ExportedDefaultBinding) {
                    resultElement.set((Object)element2);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(scopeElement, processor, false);
        PsiElement result2 = (PsiElement)resultElement.get();
        if (!(result2 instanceof JSElement)) {
            List<JSElement> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (result2 instanceof ES6ExportSpecifier) {
            ResolveResult[] resultResultsForSpecifier = ((ES6ExportSpecifier)result2).multiResolve(false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(resultResultsForSpecifier));
            List list = ContainerUtil.createMaybeSingletonList((Object)(item instanceof JSElement ? (JSElement)item : null));
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)((JSElement)result2));
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static boolean isAsyncFunction(@Nullable JSFunction function) {
        return function != null && function.isAsync();
    }

    @Contract(value="null -> false")
    public static boolean isAwaitExpression(@Nullable PsiElement expression) {
        JSPrefixExpression prefixExpression;
        JSPrefixExpression jSPrefixExpression = prefixExpression = expression instanceof JSPrefixExpression ? (JSPrefixExpression)expression : null;
        if (prefixExpression != null) {
            return prefixExpression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
        }
        return false;
    }

    public static boolean processExportAllDeclarations(@NotNull PsiElement owner, @NotNull JSModuleElementsProcessor processor, Collection<PsiElement> visited) {
        PsiElement[] children;
        if (owner == null) {
            ES6PsiUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(11);
        }
        if (!ES6PsiUtil.isExternalModule(owner) || !(owner instanceof JSElement)) {
            return true;
        }
        for (PsiElement child : children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS)) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof JSElement) || element2.isEquivalentTo(owner)) continue;
                if (visited == null) {
                    visited = new HashSet<PsiElement>();
                }
                if (ES6PsiUtil.processExportDeclarationInScope(element2, processor, null, false, visited)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            ES6PsiUtil.$$$reportNull$$$0(12);
        }
        Collection<PsiElement> elements = clause.resolveReferencedElements();
        return ES6PsiUtil.convertWithExportAssignments(elements, (PsiElement)clause);
    }

    @NotNull
    public static Collection<PsiElement> convertWithExportAssignments(@NotNull Collection<PsiElement> elements, @NotNull PsiElement place) {
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(13);
        }
        if (place == null) {
            ES6PsiUtil.$$$reportNull$$$0(14);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements.size());
        boolean isFromJavaScript = DialectDetector.isJavaScript(place);
        for (PsiElement element2 : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element2);
            if (assignment == null) {
                result2.add(element2);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            for (PsiElement psiElement : typeResolveResult.getElements()) {
                if (!(psiElement instanceof TypeScriptModule) && !(psiElement instanceof JSVariable) && !isFromJavaScript) continue;
                result2.add(psiElement);
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            ES6PsiUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveDefaultExport(@Nullable ES6ImportExportDeclaration declaration) {
        Collection<Object> scopes;
        if (declaration == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        ES6FromClause clause = declaration.getFromClause();
        Collection<Object> collection = scopes = clause != null ? clause.resolveReferencedElements() : ContainerUtil.emptyList();
        if (scopes.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        return ES6PsiUtil.resolveDefaultExport(scopes, (PsiElement)declaration);
    }

    @NotNull
    private static Collection<PsiElement> resolveDefaultExport(@NotNull Collection<PsiElement> scopes, @NotNull PsiElement context2) {
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(18);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(19);
        }
        boolean isTypeScript = DialectDetector.isTypeScript(context2);
        SmartList result2 = new SmartList();
        for (PsiElement scope2 : scopes) {
            if (scope2 instanceof JSElement) {
                boolean allowDefaultImports;
                Collection<JSElement> exports = ES6PsiUtil.findDefaultExports(scope2);
                if (!exports.isEmpty()) {
                    result2.addAll(exports);
                    continue;
                }
                TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(scope2);
                if (assignment != null) {
                    TypeScriptConfig config = !isTypeScript ? null : TypeScriptConfigUtil.getConfigForPsiFile(scope2.getContainingFile());
                    VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context2);
                    if (isTypeScript && config != null && !config.allowSyntheticDefaultImports() && (file == null || !TypeScriptUtil.isDefinitionFile(file))) continue;
                    result2.add(assignment);
                    continue;
                }
                if (!isTypeScript && scope2 instanceof JSFile) {
                    JSFile jsFile = (JSFile)scope2;
                    List<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements(jsFile);
                    if (!exportedElements.isEmpty()) {
                        result2.addAll(exportedElements);
                        continue;
                    }
                    JSModuleStatusOwner.ModuleStatus status = jsFile.getModuleStatus();
                    if (status != JSModuleStatusOwner.ModuleStatus.COMMONJS && status != JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS && (status != JSModuleStatusOwner.ModuleStatus.ES6 || !TypeScriptUtil.isDefinitionFile(jsFile))) continue;
                    result2.add(scope2);
                    continue;
                }
                if (!ES6PsiUtil.isExternalModule(scope2) || scope2 instanceof TypeScriptModule && ((TypeScriptModule)scope2).isAugmentation()) continue;
                PsiFile file = scope2.getContainingFile();
                TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(file);
                boolean bl = allowDefaultImports = config == null || config.allowSyntheticDefaultImports() || scope2 instanceof JSEmbeddedContent && scope2 instanceof JSExportScopeProvider;
                if (isTypeScript && (!allowDefaultImports || scope2 instanceof PsiFile && !TypeScriptUtil.isDefinitionFile(file))) continue;
                result2.add(scope2);
                continue;
            }
            result2.add(scope2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ES6PsiUtil.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    public static ResolveResult @NotNull [] resolveSymbolInModule(@NotNull String name, @NotNull PsiElement context2, @NotNull JSElement scope2) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(22);
        }
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(23);
        }
        return ES6PsiUtil.resolveSymbolInModules(name, context2, Collections.singleton(scope2), null);
    }

    public static ResolveResult @NotNull [] resolveSymbolInModules(@NotNull String name, @NotNull PsiElement context2, @NotNull Collection<PsiElement> scopes) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(25);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(26);
        }
        return ES6PsiUtil.resolveSymbolInModules(name, context2, scopes, null);
    }

    public static ResolveResult @NotNull [] resolveSymbolInModules(@NotNull String name, @NotNull PsiElement context2, @NotNull Collection<PsiElement> scopes, @Nullable Collection<PsiElement> visited) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(27);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(28);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(29);
        }
        if (scopes.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(30);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (StringUtil.equals((CharSequence)name, (CharSequence)DEFAULT_NAME)) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(ES6PsiUtil.resolveDefaultExport(scopes, context2));
            if (resolveResultArray == null) {
                ES6PsiUtil.$$$reportNull$$$0(31);
            }
            return resolveResultArray;
        }
        ResolveResultSink sink = new ResolveResultSink(context2, name, true);
        ES6PsiUtil.processExportedSymbols(context2, scopes, sink, visited);
        ResolveResult[] results = sink.getResultsAsResolveResults();
        if (results == null) {
            ES6PsiUtil.$$$reportNull$$$0(32);
        }
        return results;
    }

    public static ResolveResult @NotNull [] resolveSymbolForSpecifier(@NotNull ES6ImportExportSpecifier specifier, boolean strictTypeContainer) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(33);
        }
        Object[] results = ES6PsiUtil.resolveSymbolForSpecifier(specifier);
        Object[] objectArray = strictTypeContainer ? (ResolveResult[])((StreamEx)StreamEx.of((Object[])results).filter(el -> TypeScriptPsiUtil.isNamedTypeContainerDefinition(el.getElement()))).nonNull().toArray(ResolveResult[]::new) : results;
        if (objectArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(34);
        }
        return objectArray;
    }

    public static ResolveResult @NotNull [] resolveSymbolForSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(35);
        }
        return ES6PsiUtil.resolveSymbolForSpecifier(specifier, null);
    }

    public static ResolveResult @NotNull [] resolveSymbolForSpecifier(@NotNull ES6ImportExportSpecifier specifier, @Nullable Collection<PsiElement> visited) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(36);
        }
        String name = specifier.getReferenceName();
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (name == null || declaration == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(37);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            return ES6PsiUtil.resolveSymbolInModules(name, (PsiElement)specifier, ES6PsiUtil.getFromClauseResolvedReferences(clause), visited);
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)specifier, name, true);
        ES6PsiUtil.processSpecifier(specifier, sink, visited);
        ResolveResult[] resolveResultArray = sink.getResultsAsResolveResults();
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(38);
        }
        return resolveResultArray;
    }

    public static void processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(39);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(40);
        }
        ES6PsiUtil.processSpecifier(specifier, sink, null);
    }

    public static void processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink, @Nullable Collection<PsiElement> visited) {
        JSElement scope2;
        ES6ImportExportDeclaration declaration;
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(41);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(42);
        }
        if ((declaration = specifier.getDeclaration()) == null) {
            return;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            ES6PsiUtil.processExportedSymbols((PsiElement)specifier, ES6PsiUtil.getFromClauseResolvedReferences(clause), sink, visited);
            return;
        }
        if (specifier instanceof ES6ExportSpecifier && (scope2 = ES6PsiUtil.getExportScope((PsiElement)specifier)) != null) {
            final QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor((PsiElement)specifier, (PsiElement)scope2, sink);
            JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor.getName()){

                public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (element2 instanceof ES6ExportSpecifier || element2 instanceof ES6ExportSpecifierAlias) {
                        return true;
                    }
                    return processor.execute(element2, state);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope2, delegatingProcessor, true);
        }
    }

    public static void processExportedSymbols(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> scopes, @NotNull ResultSink sink) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(43);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(44);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(45);
        }
        ES6PsiUtil.processExportedSymbols(context2, scopes, sink, null);
    }

    public static void processExportedSymbols(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> scopes, @NotNull ResultSink sink, @Nullable Collection<PsiElement> visited) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(46);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(47);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(48);
        }
        JSDialectSpecificHandlersFactory factory = JSDialectSpecificHandlersFactory.forElement(context2);
        QualifiedItemProcessor<ResultSink> processor = factory.createQualifiedItemProcessor(sink, context2);
        processor.setLocalResolve(true);
        for (PsiElement psiElement : scopes) {
            if (psiElement instanceof JSFile || psiElement instanceof TypeScriptModule) {
                ES6PsiUtil.processExportDeclarationInScope(psiElement, processor, visited);
                if (!(psiElement instanceof JSFile)) continue;
                JSFile jsFile = (JSFile)psiElement;
                List<? extends PsiElement> moduleExports = JSResolveUtil.getExportedElements(jsFile);
                for (PsiElement psiElement2 : moduleExports) {
                    JSCompleteTypeEvaluationProcessor.evaluateTypes(psiElement2, context2.getContainingFile(), processor, true);
                }
                continue;
            }
            JSType type2 = JSResolveUtil.getElementJSType(psiElement);
            if (type2 == null) continue;
            processor.process(type2, new JSEvaluateContext(context2.getContainingFile()));
        }
    }

    public static void processDeclarationInJsonElement(@NotNull JsonElement element2, @NotNull JSResolveProcessor processor) {
        if (element2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(50);
        }
        JsonValue value = null;
        if (element2 instanceof JsonFile) {
            JsonFile file = (JsonFile)element2;
            value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> file.getTopLevelValue());
        } else if (element2 instanceof JsonProperty) {
            value = ((JsonProperty)element2).getValue();
        }
        if (!(value instanceof JsonObject)) {
            return;
        }
        JsonObject object = (JsonObject)value;
        List list = object.getPropertyList();
        for (JsonProperty property : list) {
            if (processor.execute((PsiElement)property, ResolveState.initial())) continue;
            return;
        }
    }

    @NotNull
    public static QualifiedItemProcessor<?> createSpecifierResolveProcessor(@NotNull PsiElement context2, @NotNull PsiElement scope2, @NotNull ResultSink sink) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(51);
        }
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(52);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(53);
        }
        QualifiedItemProcessor<ResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scope2).createQualifiedItemProcessor(sink, context2);
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        QualifiedItemProcessor<ResultSink> qualifiedItemProcessor = processor;
        if (qualifiedItemProcessor == null) {
            ES6PsiUtil.$$$reportNull$$$0(54);
        }
        return qualifiedItemProcessor;
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(55);
        }
        return JSDialectSpecificHandlersFactory.forElement(element2).getExportScope(element2);
    }

    @Nullable
    public static JSElement getNonStrictExportScope(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        return (JSElement)PsiTreeUtil.findFirstContext((PsiElement)element2, (boolean)false, ES6PsiUtil::isExportScope);
    }

    public static boolean isExportScope(@Nullable PsiElement scope2) {
        return scope2 instanceof TypeScriptModule || scope2 instanceof JSFile || ES6PsiUtil.isEmbeddedBlock(scope2) || scope2 instanceof JSExportScope;
    }

    public static boolean isEmbeddedBlock(@Nullable PsiElement scope2) {
        return scope2 instanceof JSEmbeddedContent && JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(((JSEmbeddedContent)scope2).getIElementType());
    }

    public static boolean isEmbeddedModule(@Nullable PsiElement scope2) {
        return scope2 instanceof JSEmbeddedContent && JSExtendedLanguagesTokenSetProvider.MODULE_EMBEDDED_CONTENTS.contains(((JSEmbeddedContent)scope2).getIElementType());
    }

    public static boolean processExportDeclarationInScope(@NotNull PsiElement scope2, @NotNull JSModuleElementsProcessor processor) {
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(57);
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope2, processor, null);
    }

    public static boolean processExportDeclarationInScope(@NotNull PsiElement scope2, @NotNull JSModuleElementsProcessor processor, @Nullable Collection<PsiElement> visited) {
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(58);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(59);
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope2, processor, null, false, visited);
    }

    public static boolean processExportDeclarationInScope(@NotNull PsiElement scope2, @NotNull JSModuleElementsProcessor processor, @Nullable JSEvaluateContext evaluateContext, boolean isFromRequire, @Nullable Collection<PsiElement> visited) {
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(61);
        }
        if (visited == null) {
            visited = new HashSet<PsiElement>();
        }
        if (!visited.add(scope2)) {
            return true;
        }
        ProgressManager.checkCanceled();
        boolean isTypeScript = DialectDetector.isTypeScript(scope2);
        boolean useWeakResolve = !isTypeScript || evaluateContext != null && !evaluateContext.isStrict();
        boolean processingResult = true;
        for (JSModuleExportsProvider provider : JSModuleExportsProvider.EP_NAME.getExtensionList()) {
            if (!provider.processExports(scope2, processor, useWeakResolve || isFromRequire)) {
                processingResult = false;
            }
            Collection<PsiElement> scopes = provider.getAdditionalScopes(scope2, visited);
            for (PsiElement additionalScope : scopes) {
                if (ES6PsiUtil.processExportDeclarationInScope(additionalScope, processor, evaluateContext, isFromRequire, visited)) continue;
                processingResult = false;
            }
        }
        return processingResult;
    }

    public static boolean isElementCanBeExported(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(62);
        }
        return element2 instanceof JSAttributeListOwner && !(element2 instanceof TypeScriptTypeMember) && !(element2 instanceof JSParameter) && !(element2 instanceof JSProperty) && !(element2 instanceof JSField) && !(element2 instanceof TypeScriptType);
    }

    @Contract(value="null->false")
    public static boolean isExternalModule(@Nullable PsiElement element2) {
        if (element2 instanceof JSModuleStatusOwner) {
            return ((JSModuleStatusOwner)element2).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.ES6;
        }
        if (ES6PsiUtil.isEmbeddedModule(element2)) {
            return true;
        }
        return element2 instanceof TypeScriptModule && !((TypeScriptModule)element2).isInternal();
    }

    @Nullable
    public static PsiElement findExternalModule(@NotNull PsiElement context2) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(63);
        }
        return ES6PsiUtil.findExternalModule(context2, true);
    }

    @Nullable
    public static PsiElement findExternalModule(@NotNull PsiElement context2, boolean strict) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(64);
        }
        if (!strict && ES6PsiUtil.isExternalModule(context2)) {
            return context2;
        }
        JSElement container = ES6PsiUtil.getExportScope(context2);
        while (container != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)container)) {
                return container;
            }
            if (container instanceof PsiFile) {
                return null;
            }
            container = ES6PsiUtil.getExportScope((PsiElement)container);
        }
        return null;
    }

    @Nullable
    public static ES6Decorator findDecoratorByName(@NotNull JSAttributeListOwner owner, String ... names) {
        JSAttributeList attributeList;
        if (owner == null) {
            ES6PsiUtil.$$$reportNull$$$0(65);
        }
        Object[] decorators = (attributeList = owner.getAttributeList()) != null ? attributeList.getDecorators() : ES6Decorator.EMPTY_ARRAY;
        return (ES6Decorator)ContainerUtil.find((Object[])decorators, decorator -> {
            JSReferenceExpression referenceExpression;
            JSExpression expr = decorator.getExpression();
            if (expr instanceof JSCallExpression) {
                expr = ((JSCallExpression)expr).getMethodExpression();
            }
            return (referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr, JSReferenceExpression.class)) != null && JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, names);
        });
    }

    @Nullable
    public static PsiElement computeFromFileForImportExport(@Nullable PsiElement element2) {
        ES6ImportExportDeclaration importDeclaration = (ES6ImportExportDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{ES6ImportExportDeclaration.class});
        if (importDeclaration == null) {
            return null;
        }
        ES6FromClause fromClause = importDeclaration.getFromClause();
        if (fromClause == null) {
            if (element2 instanceof ES6ExportSpecifier) {
                return element2.getContainingFile();
            }
            return null;
        }
        Collection<PsiElement> elements = fromClause.resolveReferencedElements();
        if (elements.size() != 1) {
            return null;
        }
        return elements.iterator().next();
    }

    @Nullable
    public static PsiElement getDefaultElement(PsiElement element2) {
        PsiElement exportElement = null;
        if (element2 instanceof JSExportAssignment || ES6PsiUtil.isDefaultExportThroughSpecifier(element2)) {
            exportElement = element2;
        } else {
            PsiElement parent = element2.getContext();
            if (parent instanceof JSExportAssignment) {
                exportElement = parent;
            }
        }
        return exportElement;
    }

    private static boolean isDefaultExportThroughSpecifier(PsiElement element2) {
        return element2 instanceof ES6ExportSpecifier && DEFAULT_NAME.equals(((ES6ExportSpecifier)element2).getDeclaredName()) || element2 instanceof ES6ExportSpecifierAlias && DEFAULT_NAME.equals(((ES6ExportSpecifierAlias)element2).getName());
    }

    public static boolean isLocalClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            ES6PsiUtil.$$$reportNull$$$0(66);
        }
        return !jsClass.isExportedWithDefault() && !jsClass.isNamespaceExplicitlyDeclared();
    }

    public static void buildSignatureForDestructuringContainer(@NotNull JSDestructuringContainer target2, @NotNull StringBuilder builder2, boolean withInitializer) {
        if (target2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(67);
        }
        if (builder2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(68);
        }
        if (target2 instanceof JSDestructuringObject) {
            builder2.append('{');
            JSDestructuringProperty[] properties2 = ((JSDestructuringObject)target2).getProperties();
            boolean isFirst = true;
            for (JSDestructuringProperty property : properties2) {
                if (!isFirst) {
                    builder2.append(", ");
                }
                isFirst = false;
                if (property.isRest()) {
                    builder2.append("...");
                } else if (!(property instanceof JSDestructuringShorthandedProperty)) {
                    builder2.append(property.getName()).append(": ");
                }
                JSInitializerOwner element2 = property.getDestructuringElement();
                if (element2 == null) continue;
                ES6PsiUtil.buildSignatureForInitializerOwner(element2, builder2, withInitializer);
            }
            builder2.append('}');
        } else {
            builder2.append('[');
            boolean isFirst = true;
            for (JSInitializerOwner owner : ((JSDestructuringArray)target2).getElements()) {
                if (!isFirst) {
                    builder2.append(", ");
                }
                isFirst = false;
                if (owner == null) continue;
                ES6PsiUtil.buildSignatureForInitializerOwner(owner, builder2, withInitializer);
            }
            JSDestructuringArrayRestElement restElement = ((JSDestructuringArray)target2).getRestElement();
            if (restElement != null) {
                JSDestructuringElement pattern;
                if (!isFirst) {
                    builder2.append(", ");
                }
                builder2.append("...");
                JSVariable variable = restElement.getVariable();
                if (variable != null) {
                    ES6PsiUtil.buildSignatureForInitializerOwner(variable, builder2, withInitializer);
                }
                if ((pattern = restElement.getPattern()) != null) {
                    ES6PsiUtil.buildSignatureForInitializerOwner(pattern, builder2, withInitializer);
                }
            }
            builder2.append(']');
        }
    }

    private static void buildSignatureForInitializerOwner(@NotNull JSInitializerOwner initializerOwner, @NotNull StringBuilder builder2, boolean withInitializer) {
        JSDestructuringContainer target2;
        if (initializerOwner == null) {
            ES6PsiUtil.$$$reportNull$$$0(69);
        }
        if (builder2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(70);
        }
        if (initializerOwner instanceof JSVariable) {
            builder2.append(initializerOwner.getName());
            String initializer = ((JSVariable)initializerOwner).getLiteralOrReferenceInitializerText();
            if (withInitializer && initializer != null) {
                builder2.append(" = ").append(initializer);
            } else {
                JSType type2 = ((JSVariable)initializerOwner).getJSType();
                if (type2 instanceof JSPrimitiveLiteralType) {
                    builder2.append(" = ").append(((JSPrimitiveLiteralType)type2).getValueAsString());
                }
            }
        } else if (initializerOwner instanceof JSDestructuringElement && (target2 = ((JSDestructuringElement)initializerOwner).getTarget()) != null) {
            ES6PsiUtil.buildSignatureForDestructuringContainer(target2, builder2, withInitializer);
        }
    }

    @Nullable
    public static String getInitializerReference(@NotNull JSExportAssignment exportAssignment) {
        JSExpression expression;
        if (exportAssignment == null) {
            ES6PsiUtil.$$$reportNull$$$0(71);
        }
        if ((expression = JSUtils.unparenthesize(exportAssignment.getExpression())) instanceof JSReferenceExpression) {
            JSQualifiedName name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)expression));
            return name != null ? name.getQualifiedName() : null;
        }
        return null;
    }

    @NotNull
    public static JSQualifiedNameResolver createResolver(@NotNull PsiElement context2) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(72);
        }
        return DialectDetector.isTypeScript(context2) ? new TypeScriptQualifiedNameResolver(context2, true) : new ES6QualifiedNameResolver(context2, true, true);
    }

    @NotNull
    public static Collection<PsiElement> expandElements(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> elements) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(73);
        }
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(74);
        }
        JSQualifiedNameResolver resolver = ES6PsiUtil.createResolver(context2);
        Collection<PsiElement> collection = resolver.expandElements(elements);
        if (collection == null) {
            ES6PsiUtil.$$$reportNull$$$0(75);
        }
        return collection;
    }

    public static boolean checkNamesEquivalent(@NotNull JSElement first, @NotNull JSElement second) {
        if (first == null) {
            ES6PsiUtil.$$$reportNull$$$0(76);
        }
        if (second == null) {
            ES6PsiUtil.$$$reportNull$$$0(77);
        }
        String nameOne = first.getName();
        String nameTwo = second.getName();
        if (nameOne == null && nameTwo == null && first instanceof JSComputedPropertyNameOwner && second instanceof JSComputedPropertyNameOwner) {
            ES6ComputedName computedOne = ((JSComputedPropertyNameOwner)first).getComputedPropertyName();
            ES6ComputedName computedTwo = ((JSComputedPropertyNameOwner)first).getComputedPropertyName();
            if (computedOne != null && computedTwo != null) {
                return Objects.equals(computedOne.getExpressionAsReferenceName(), computedTwo.getExpressionAsReferenceName());
            }
            return false;
        }
        return Objects.equals(nameOne, nameTwo);
    }

    @Contract(value="null -> false")
    public static boolean isInsideDecorator(@Nullable PsiElement expression) {
        JSElement functionOrDecorator = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{ES6Decorator.class, JSFunction.class});
        while (functionOrDecorator != null) {
            if (functionOrDecorator instanceof ES6Decorator) {
                return true;
            }
            if (!((JSFunction)functionOrDecorator).isArrowFunction()) {
                return false;
            }
            functionOrDecorator = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)functionOrDecorator, (Class[])new Class[]{ES6Decorator.class, JSFunction.class});
        }
        return false;
    }

    @NotNull
    public static JSModuleStatusOwner.ModuleStatus getModuleStatus(@NotNull PsiElement element2) {
        JSModuleStatusOwner module;
        if (element2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(78);
        }
        JSModuleStatusOwner.ModuleStatus moduleStatus = (module = ES6PsiUtil.getModuleStatusOwner(element2)) != null ? module.getModuleStatus() : JSModuleStatusOwner.ModuleStatus.NONE;
        if (moduleStatus == null) {
            ES6PsiUtil.$$$reportNull$$$0(79);
        }
        return moduleStatus;
    }

    @Nullable
    public static JSModuleStatusOwner getModuleStatusOwner(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(80);
        }
        return (JSModuleStatusOwner)PsiTreeUtil.getContextOfType((PsiElement)element2, JSModuleStatusOwner.class, (boolean)false);
    }

    @Contract(value="null -> null")
    public static JSClass getES6ConstructorClass(@Nullable PsiElement element2) {
        if (!(element2 instanceof JSFunction)) {
            return null;
        }
        if (JSResolveUtil.isConstructorFunction(element2) && "constructor".equals(((JSFunction)element2).getName())) {
            return JSUtils.getMemberContainingClass(element2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8, 9, 15, 16, 17, 20, 30, 31, 32, 34, 37, 38, 54, 75, 79 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 54: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 10: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 11: 
            case 50: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: 
            case 26: 
            case 29: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 43: 
            case 46: 
            case 51: 
            case 63: 
            case 64: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 52: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 49: 
            case 55: 
            case 62: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportAssignment";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingAllPossibleExports";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefaultExports";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWithExportAssignments";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDefaultExport";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolInModules";
                break;
            }
            case 34: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolForSpecifier";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpecifierResolveProcessor";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBindingAllPossibleExports";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 54: 
            case 75: 
            case 79: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultExport";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultExports";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processExportAllDeclarations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFromClauseResolvedReferences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertWithExportAssignments";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveDefaultExport";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModule";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModules";
                break;
            }
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolForSpecifier";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifier";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processExportedSymbols";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationInJsonElement";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createSpecifierResolveProcessor";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getExportScope";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processExportDeclarationInScope";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeExported";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findDecoratorByName";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isLocalClass";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "buildSignatureForDestructuringContainer";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "buildSignatureForInitializerOwner";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerReference";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createResolver";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "expandElements";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "checkNamesEquivalent";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getModuleStatus";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getModuleStatusOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8, 9, 15, 16, 17, 20, 30, 31, 32, 34, 37, 38, 54, 75, 79 -> new IllegalStateException(string);
        };
    }

    public static final class ES6ExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public ES6ExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(0);
            }
            super(delegateProcessor instanceof JSResolveProcessor ? ((JSResolveProcessor)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
            if (element2 == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(2);
            }
            if (element2 instanceof ES6NamespaceExport) {
                return this.myDelegate.execute(element2, state);
            }
            if (element2 instanceof ES6ExportSpecifier) {
                return this.myDelegate.execute(element2, state);
            }
            if (ES6ImportHandler.isExportedDirectly(element2)) {
                return this.myDelegate.execute(element2, state);
            }
            if (this.myDelegate instanceof JSCandidateResultProcessor) {
                JSResolveResult.ProblemKind kind;
                JSResolveResult.ProblemKind problemKind = element2 instanceof JSPsiElementBase && ((JSPsiElementBase)element2).isExportedWithDefault() ? JSResolveResult.ProblemKind.JS_DEFAULT_INSTEAD_NAMED : (kind = JSUseScopeProvider.isLexicalScopeElement(element2) ? JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED : null);
                if (kind != null) {
                    ((JSCandidateResultProcessor)this.myDelegate).executeCandidateResult(element2, kind);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

