/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.php;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.api.EnvironmentVariablesUsagesProvider;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;

final class PhpunitEnvironmentVariablesUsagesProvider
implements EnvironmentVariablesUsagesProvider {
    PhpunitEnvironmentVariablesUsagesProvider() {
    }

    @Override
    public boolean acceptFile(VirtualFile file) {
        return file.getFileType().equals(XmlFileType.INSTANCE) && file.getName().equals("phpunit.xml");
    }

    @Override
    @NotNull
    public Collection<KeyUsagePsiElement> getUsages(PsiFile psiFile) {
        if (!(psiFile instanceof XmlFile)) {
            List<KeyUsagePsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpunitEnvironmentVariablesUsagesProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (!(psiFile.getFirstChild() instanceof XmlDocument)) {
            List<KeyUsagePsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpunitEnvironmentVariablesUsagesProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        XmlTag rootTag = ((XmlDocument)psiFile.getFirstChild()).getRootTag();
        if (rootTag == null) {
            List<KeyUsagePsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpunitEnvironmentVariablesUsagesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        XmlTag phpTag = rootTag.findFirstSubTag("php");
        if (phpTag == null) {
            List<KeyUsagePsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpunitEnvironmentVariablesUsagesProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        HashSet<KeyUsagePsiElement> collectedItems = new HashSet<KeyUsagePsiElement>();
        for (XmlTag tag : phpTag.getSubTags()) {
            XmlAttribute attribute;
            if (!tag.getName().equals("server") && !tag.getName().equals("env") || (attribute = tag.getAttribute("name")) == null || attribute.getValueElement() == null) continue;
            collectedItems.add(new KeyUsagePsiElement(attribute.getValue(), (PsiElement)attribute.getValueElement()));
        }
        HashSet<KeyUsagePsiElement> hashSet = collectedItems;
        if (hashSet == null) {
            PhpunitEnvironmentVariablesUsagesProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/adelf/idea/dotenv/php/PhpunitEnvironmentVariablesUsagesProvider", "getUsages"));
    }
}

