// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief e+ e- > K+K-
  class SND_2016_I1484677 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(SND_2016_I1484677);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      for (size_t ix=0; ix<2; ++ix) {
        book(_nkaon[ix], 1+ix, 1, 1);
        for (const string& en : _nkaon[ix].binning().edges<0>()) {
          const double eval = stod(en)*GeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs[ix] = en; break;
          }
        }
      }
      raiseBeamErrorIf(_sqs[0].empty() && _sqs[1].empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if (fs.particles().size()!=2) vetoEvent;
      for (const Particle& p : fs.particles()) {
        if (p.abspid() != PID::KPLUS) vetoEvent;
      }
      for (size_t ix=0; ix<2; ++ix) _nkaon[ix]->fill(_sqs[ix]);
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_nkaon, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _nkaon[2];
    string _sqs[2];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(SND_2016_I1484677);
}
