/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.RemoteNativeClientLocation;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ClientHomesPanel
extends Composite {
    private static final Log log = Log.getLog(ClientHomesPanel.class);
    public static final String WIKI_CONFIGURE_CLIENT = "Local-Client-Configuration";
    private static String lastHomeDirectory;
    private final Table homesTable;
    private final Text idText;
    private final Text pathText;
    private final Text nameText;
    private final Text productNameText;
    private final Text productVersionText;
    private final Button removeButton;
    private DBPDriver driver;

    public ClientHomesPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Composite listGroup = UIUtils.createPlaceholder((Composite)this, (int)1, (int)5);
        listGroup.setLayoutData((Object)new GridData(1040));
        ((GridData)listGroup.getLayoutData()).minimumWidth = 200;
        this.homesTable = new Table(listGroup, 68356);
        this.homesTable.setLayoutData((Object)new GridData(1808));
        this.homesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = ClientHomesPanel.this.homesTable.getSelection();
                if (ArrayUtils.isEmpty((Object[])selection)) {
                    ClientHomesPanel.this.selectHome(null);
                } else {
                    ClientHomesPanel.this.selectHome((HomeInfo)selection[0].getData());
                }
            }
        });
        Composite buttonsGroup = UIUtils.createPlaceholder((Composite)listGroup, (int)2, (int)5);
        buttonsGroup.setLayoutData((Object)new GridData(896));
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(UIConnectionMessages.controls_client_homes_panel_button_add_home);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientHomesPanel.this.addClientHome();
            }
        });
        this.removeButton = new Button(buttonsGroup, 8);
        this.removeButton.setText(UIConnectionMessages.controls_client_homes_panel_button_remove_home);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = ClientHomesPanel.this.homesTable.getSelection();
                if (!ArrayUtils.isEmpty((Object[])selection)) {
                    ClientHomesPanel.this.removeClientHome();
                }
            }
        });
        Composite infoGroup = UIUtils.createTitledComposite((Composite)this, (String)UIConnectionMessages.controls_client_homes_panel_group_information, (int)2, (int)770, (int)0);
        ((GridData)infoGroup.getLayoutData()).minimumWidth = 300;
        this.idText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.controls_client_homes_panel_label_id, null, (int)2056);
        this.pathText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.controls_client_homes_panel_label_path, null, (int)2056);
        this.nameText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.controls_client_homes_panel_label_name, null, (int)2056);
        this.productNameText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.controls_client_homes_panel_label_product_name, null, (int)2056);
        this.productVersionText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.controls_client_homes_panel_label_product_version, null, (int)2056);
        Composite infoPanel = new Composite(parent, 0);
        infoPanel.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createLink((Composite)infoPanel, (String)UIConnectionMessages.controls_client_homes_panel_link_message, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)ClientHomesPanel.WIKI_CONFIGURE_CLIENT));
            }
        });
        GridData gridData = new GridData(4, 0x1000008, true, true);
        gridData.horizontalSpan = 2;
        infoPanel.setLayoutData((Object)gridData);
    }

    private void removeClientHome() {
        int selIndex = this.homesTable.getSelectionIndex();
        HomeInfo info = (HomeInfo)this.homesTable.getItem(selIndex).getData();
        if (!info.isProvided && UIUtils.confirmAction((Shell)this.getShell(), (String)UIConnectionMessages.controls_client_homes_panel_confirm_remove_home_title, (String)NLS.bind((String)UIConnectionMessages.controls_client_homes_panel_confirm_remove_home_text, (Object)info.location.getName()))) {
            this.homesTable.remove(selIndex);
            if (this.homesTable.getItemCount() > 0) {
                this.selectHome((HomeInfo)this.homesTable.getItem(selIndex - 1).getData());
                this.homesTable.setSelection(selIndex - 1);
            } else {
                this.selectHome(null);
            }
        }
    }

    private void addClientHome() {
        String homeId;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        if (lastHomeDirectory != null) {
            directoryDialog.setFilterPath(lastHomeDirectory);
        }
        if ((homeId = directoryDialog.open()) == null) {
            return;
        }
        lastHomeDirectory = homeId;
        DBPNativeClientLocationManager clientManager = this.driver.getNativeClientManager();
        if (clientManager != null) {
            this.createHomeItem(clientManager, (DBPNativeClientLocation)new LocalNativeClientLocation(homeId, homeId), false);
        }
    }

    private void selectHome(HomeInfo home) {
        DBPNativeClientLocationManager nativeClientLocationManager;
        this.removeButton.setEnabled(home != null && !home.isProvided);
        this.idText.setText(home == null ? "" : CommonUtils.notEmpty((String)home.location.getName()));
        this.pathText.setText(home == null ? "" : home.location.getPath().getAbsolutePath());
        this.nameText.setText(home == null ? "" : CommonUtils.notEmpty((String)home.location.getDisplayName()));
        if (home != null && !home.isValidated) {
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    try {
                        homeInfo.location.validateFilesPresence(monitor);
                        homeInfo.isValidated = true;
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Client download", "Failed to download client files", e.getTargetException());
            }
        }
        if ((nativeClientLocationManager = this.driver.getNativeClientManager()) != null) {
            this.productNameText.setText(home == null ? "" : CommonUtils.notEmpty((String)nativeClientLocationManager.getProductName(home.location)));
            this.productVersionText.setText(home == null ? "" : CommonUtils.notEmpty((String)nativeClientLocationManager.getProductVersion(home.location)));
        }
    }

    public Collection<DBPNativeClientLocation> getLocalLocations() {
        ArrayList<DBPNativeClientLocation> homes = new ArrayList<DBPNativeClientLocation>();
        TableItem[] tableItemArray = this.homesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            HomeInfo homeInfo = (HomeInfo)item.getData();
            if (!homeInfo.isProvided) {
                homes.add(homeInfo.location);
            }
            ++n2;
        }
        return homes;
    }

    public void loadHomes(DBPDriver driver) {
        this.homesTable.removeAll();
        this.driver = driver;
        this.selectHome(null);
        DBPNativeClientLocationManager clientManager = this.driver.getNativeClientManager();
        if (clientManager == null) {
            log.debug((Object)("Client manager is not supported by driver '" + driver.getName() + "'"));
        }
        LinkedHashSet providedHomes = new LinkedHashSet();
        if (clientManager != null) {
            providedHomes.addAll(clientManager.findLocalClientLocations());
        }
        LinkedHashSet allHomes = new LinkedHashSet();
        allHomes.addAll(driver.getNativeClientLocations());
        allHomes.addAll(providedHomes);
        Iterator iterator = allHomes.iterator();
        while (iterator.hasNext()) {
            DBPNativeClientLocation home;
            TableItem item = this.createHomeItem(clientManager, home, (home = (DBPNativeClientLocation)iterator.next()) instanceof RemoteNativeClientLocation || providedHomes.contains(home));
            HomeInfo homeInfo = (HomeInfo)item.getData();
            if (!homeInfo.isDefault) continue;
            this.homesTable.setSelection(this.homesTable.indexOf(item));
            this.selectHome(homeInfo);
        }
    }

    private TableItem createHomeItem(@NotNull DBPNativeClientLocationManager clientManager, @NotNull DBPNativeClientLocation clientLocation, boolean provided) {
        List driverLocations;
        DBPNativeClientLocation defaultLocalClientLocation = clientManager.getDefaultLocalClientLocation();
        if (defaultLocalClientLocation == null && !CommonUtils.isEmpty((Collection)(driverLocations = this.driver.getNativeClientLocations()))) {
            defaultLocalClientLocation = (DBPNativeClientLocation)driverLocations.get(0);
        }
        HomeInfo homeInfo = new HomeInfo(clientLocation);
        homeInfo.isProvided = provided;
        homeInfo.isDefault = defaultLocalClientLocation != null && clientLocation.getName().equals(defaultLocalClientLocation.getName());
        TableItem homeItem = new TableItem(this.homesTable, 0);
        homeItem.setText(clientLocation.getDisplayName());
        homeItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.HOME));
        homeItem.setData((Object)homeInfo);
        if (!homeInfo.isProvided) {
            homeItem.setFont(BaseThemeSettings.instance.treeAndTableFontItalic);
        } else if (homeInfo.isDefault) {
            homeItem.setFont(BaseThemeSettings.instance.treeAndTableFontBold);
        }
        return homeItem;
    }

    private String getSelectedHome() {
        Object[] selection = this.homesTable.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return null;
        }
        return ((HomeInfo)selection[0].getData()).location.getName();
    }

    static String chooseClientHome(Shell parent, DBPDriver driver) {
        ChooserDialog dialog = new ChooserDialog(parent, driver);
        if (dialog.open() == 0) {
            return dialog.selectedHome;
        }
        return null;
    }

    private static class ChooserDialog
    extends Dialog {
        private final DBPDriver driver;
        private ClientHomesPanel panel;
        private String selectedHome;

        ChooserDialog(Shell parentShell, DBPDriver driver) {
            super(parentShell);
            this.driver = driver;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(UIConnectionMessages.controls_client_homes_panel_dialog_title);
            this.panel = new ClientHomesPanel(parent, 0);
            GridData gd = new GridData(1808);
            this.panel.setLayoutData(gd);
            this.panel.loadHomes(this.driver);
            return parent;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.selectedHome = this.panel.getSelectedHome();
                DBPDriver dBPDriver = this.driver;
                if (dBPDriver instanceof DriverDescriptor) {
                    DriverDescriptor descriptor = (DriverDescriptor)dBPDriver;
                    descriptor.setNativeClientLocations(this.panel.getLocalLocations());
                    try {
                        descriptor.getProviderDescriptor().getRegistry().saveDrivers();
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("Save error", "Error saving drivers", (Throwable)e);
                        return;
                    }
                }
            }
            super.buttonPressed(buttonId);
        }
    }

    static class HomeInfo {
        DBPNativeClientLocation location;
        boolean isProvided;
        boolean isDefault;
        public boolean isValidated;

        HomeInfo(DBPNativeClientLocation location) {
            this.location = location;
        }
    }
}

