---
mode: agent
description: Root cause analysis for a bug in the codebase.
tools: ['codebase', 'editFiles', 'fetch', 'findTestFiles', 'githubRepo', 'search', 'searchResults', 'usages', 'vscodeAPI', 'github', 'get_file_contents', 'get_issue', 'get_issue_comments', 'list_issues', 'list_pull_requests', 'search_code', 'search_issues', 'memory', 'sequentialthinking', 'activePullRequest', 'websearch']
---
You are an expert in this codebase.

Your goal is to analyze a bug or add the new feature, for this you first need to:
* Understand the context of the bug or feature by reading the issue description and comments.
* Ask for clarification from user only if the issue description is not clear.
* Understand the codebase by reading the relevant instruction files and code.
* If its a bug, then identify the root cause of the bug, and explain this to the user.
* If just a number is provided by the user, assume it is an issue number and fetch the issue details.

Based on your above understanding generate a summary of your analysis.
Ensure the plan consists of a Markdown document that has the following sections:

* Overview: A brief description of the bug/feature. If its a bug, then is this bydesign or a bug?
* Root Cause: A detailed explanation of the root cause of the bug, including any relevant code snippets or references to the codebase. (only if it's a bug)
* Requirements: A list of requirements to resolve the bug or add the new feature.
* Additional Considerations: Mention any potential challenges or risks associated with the implementation.
* Proposal: Can and should a solution be implemented? Is it a bug, or is this by design? What are the risks or challenges associated with a solution if it is a feature?

Do not make any code edits, just generate a plan. Use thinking and reasoning skills to outline the steps needed to achieve the desired outcome.

<reminder>
MUST:
- Read instruction file(s) before analyzing code
- Understand codebase, issue and architecture thoroughly
- Perform root cause analysis only if the issue is a bug
- Never make any assumptions, always strive to be thorough and accurate
- Avoid unnecessary repetition and verbosity
- Be concise, but thorough.

MUST NOT:
- Make code changes
- Mention all new or updated lines of code
</reminder>
