/*
    SPDX-FileCopyrightText: 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "selectcontrollerfactory.hpp"

// lib
#include "selectcontroller.hpp"

namespace Kasten {

SelectControllerFactory::SelectControllerFactory() = default;

SelectControllerFactory::~SelectControllerFactory() = default;

std::unique_ptr<AbstractXmlGuiController> SelectControllerFactory::create(KXMLGUIClient* guiClient) const
{
    return std::make_unique<SelectController>(guiClient);
}

}
