// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// AWS credentials structure containing temporary access credentials The scoped-down, 15 minute duration AWS credentials. Scoping down will be based on CLI policy (CLI team needs to create it). Similar to cloud shell implementation.
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct AccessToken {
    /// AWS access key ID for temporary credentials
    pub access_key_id: ::std::string::String,
    /// AWS secret access key for temporary credentials
    pub secret_access_key: ::std::string::String,
    /// AWS session token for temporary credentials
    pub session_token: ::std::string::String,
}
impl AccessToken {
    /// AWS access key ID for temporary credentials
    pub fn access_key_id(&self) -> &str {
        use std::ops::Deref;
        self.access_key_id.deref()
    }
    /// AWS secret access key for temporary credentials
    pub fn secret_access_key(&self) -> &str {
        use std::ops::Deref;
        self.secret_access_key.deref()
    }
    /// AWS session token for temporary credentials
    pub fn session_token(&self) -> &str {
        use std::ops::Deref;
        self.session_token.deref()
    }
}
impl ::std::fmt::Debug for AccessToken {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("AccessToken");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl AccessToken {
    /// Creates a new builder-style object to manufacture [`AccessToken`](crate::types::AccessToken).
    pub fn builder() -> crate::types::builders::AccessTokenBuilder {
        crate::types::builders::AccessTokenBuilder::default()
    }
}

/// A builder for [`AccessToken`](crate::types::AccessToken).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct AccessTokenBuilder {
    pub(crate) access_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) secret_access_key: ::std::option::Option<::std::string::String>,
    pub(crate) session_token: ::std::option::Option<::std::string::String>,
}
impl AccessTokenBuilder {
    /// AWS access key ID for temporary credentials
    /// This field is required.
    pub fn access_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.access_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// AWS access key ID for temporary credentials
    pub fn set_access_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.access_key_id = input;
        self
    }
    /// AWS access key ID for temporary credentials
    pub fn get_access_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.access_key_id
    }
    /// AWS secret access key for temporary credentials
    /// This field is required.
    pub fn secret_access_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.secret_access_key = ::std::option::Option::Some(input.into());
        self
    }
    /// AWS secret access key for temporary credentials
    pub fn set_secret_access_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.secret_access_key = input;
        self
    }
    /// AWS secret access key for temporary credentials
    pub fn get_secret_access_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.secret_access_key
    }
    /// AWS session token for temporary credentials
    /// This field is required.
    pub fn session_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_token = ::std::option::Option::Some(input.into());
        self
    }
    /// AWS session token for temporary credentials
    pub fn set_session_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_token = input;
        self
    }
    /// AWS session token for temporary credentials
    pub fn get_session_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_token
    }
    /// Consumes the builder and constructs a [`AccessToken`](crate::types::AccessToken).
    /// This method will fail if any of the following fields are not set:
    /// - [`access_key_id`](crate::types::builders::AccessTokenBuilder::access_key_id)
    /// - [`secret_access_key`](crate::types::builders::AccessTokenBuilder::secret_access_key)
    /// - [`session_token`](crate::types::builders::AccessTokenBuilder::session_token)
    pub fn build(self) -> ::std::result::Result<crate::types::AccessToken, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::AccessToken {
            access_key_id: self.access_key_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "access_key_id",
                    "access_key_id was not specified but it is required when building AccessToken",
                )
            })?,
            secret_access_key: self.secret_access_key.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "secret_access_key",
                    "secret_access_key was not specified but it is required when building AccessToken",
                )
            })?,
            session_token: self.session_token.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "session_token",
                    "session_token was not specified but it is required when building AccessToken",
                )
            })?,
        })
    }
}
impl ::std::fmt::Debug for AccessTokenBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("AccessTokenBuilder");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
