/*
    SPDX-FileCopyrightText: 2008 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_INVERTBYTEARRAYFILTER_HPP
#define KASTEN_INVERTBYTEARRAYFILTER_HPP

//
#include "nobytearrayfilterparameterset.hpp"
//
#include <abstractbytearrayfilter.hpp>

class InvertByteArrayFilter : public AbstractByteArrayFilter
{
    Q_OBJECT

public:
    InvertByteArrayFilter();

    ~InvertByteArrayFilter() override;

public: // AbstractByteArrayFilter API
    [[nodiscard]]
    bool filter(Okteta::Byte* result, Okteta::AbstractByteArrayModel* model, const Okteta::AddressRange& range) const override;
    [[nodiscard]]
    AbstractByteArrayFilterParameterSet* parameterSet() override;

private:
    NoByteArrayFilterParameterSet mNoParameterSet;
};

#endif
