/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools;

import android.app.TabActivity;
import android.content.Context;
import android.os.Bundle;
import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.support.ConnectionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmLiteBaseTabActivity<H extends OrmLiteSqliteOpenHelper>
extends TabActivity {
    private volatile H helper;
    private volatile boolean created = false;
    private volatile boolean destroyed = false;

    public H getHelper() {
        if (this.helper == null) {
            if (!this.created) {
                throw new IllegalStateException("A call has not been made to onCreate() yet so the helper is null");
            }
            if (this.destroyed) {
                throw new IllegalStateException("A call to onDestroy has already been made and the helper cannot be used after that point");
            }
            throw new IllegalStateException("Helper is null for some unknown reason");
        }
        return this.helper;
    }

    public ConnectionSource getConnectionSource() {
        return ((OrmLiteSqliteOpenHelper)((Object)this.getHelper())).getConnectionSource();
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.helper == null) {
            this.helper = this.getHelperInternal((Context)this);
            this.created = true;
        }
        super.onCreate(savedInstanceState);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.releaseHelper(this.helper);
        this.destroyed = true;
    }

    protected H getHelperInternal(Context context) {
        OrmLiteSqliteOpenHelper newHelper = OpenHelperManager.getHelper(context);
        return (H)((Object)newHelper);
    }

    protected void releaseHelper(H helper) {
        OpenHelperManager.releaseHelper();
        this.helper = null;
    }
}

