// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file resources.proto (package rs.tokio.console.resources, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3, protoInt64, Timestamp } from "@bufbuild/protobuf";
import { Attribute, Id, Location, MetaId } from "./common_pb.js";

/**
 * A resource state update.
 *
 * Each `ResourceUpdate` contains any resource data that has changed since the last
 * update. This includes:
 * - any new resources that were created since the last update
 * - the current stats for any resource whose stats changed since the last update
 * - any new poll ops that have been invoked on a resource
 *
 * @generated from message rs.tokio.console.resources.ResourceUpdate
 */
export class ResourceUpdate extends Message<ResourceUpdate> {
  /**
   * A list of new resources that were created since the last `ResourceUpdate` was
   * sent.
   *
   * @generated from field: repeated rs.tokio.console.resources.Resource new_resources = 1;
   */
  newResources: Resource[] = [];

  /**
   * Any resource stats that have changed since the last update.
   *
   * @generated from field: map<uint64, rs.tokio.console.resources.Stats> stats_update = 2;
   */
  statsUpdate: { [key: string]: Stats } = {};

  /**
   * A list of all new poll ops that have been invoked on resources since the last update.
   *
   * @generated from field: repeated rs.tokio.console.resources.PollOp new_poll_ops = 3;
   */
  newPollOps: PollOp[] = [];

  /**
   * A count of how many resource events (e.g. polls, creation, etc) were not
   * recorded because the application's event buffer was at capacity.
   *
   * If everything is working normally, this should be 0. If it is greater
   * than 0, that may indicate that some data is missing from this update, and
   * it may be necessary to increase the number of events buffered by the
   * application to ensure that data loss is avoided.
   *
   * If the application's instrumentation ensures reliable delivery of events,
   * this will always be 0.
   *
   * @generated from field: uint64 dropped_events = 4;
   */
  droppedEvents = protoInt64.zero;

  constructor(data?: PartialMessage<ResourceUpdate>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.resources.ResourceUpdate";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "new_resources", kind: "message", T: Resource, repeated: true },
    { no: 2, name: "stats_update", kind: "map", K: 4 /* ScalarType.UINT64 */, V: {kind: "message", T: Stats} },
    { no: 3, name: "new_poll_ops", kind: "message", T: PollOp, repeated: true },
    { no: 4, name: "dropped_events", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceUpdate {
    return new ResourceUpdate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceUpdate {
    return new ResourceUpdate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceUpdate {
    return new ResourceUpdate().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceUpdate | PlainMessage<ResourceUpdate> | undefined, b: ResourceUpdate | PlainMessage<ResourceUpdate> | undefined): boolean {
    return proto3.util.equals(ResourceUpdate, a, b);
  }
}

/**
 * Static data recorded when a new resource is created.
 *
 * @generated from message rs.tokio.console.resources.Resource
 */
export class Resource extends Message<Resource> {
  /**
   * The resources's ID.
   *
   * This uniquely identifies this resource across all *currently live*
   * resources. This is also the primary way any operations on a resource
   * are associated with it
   *
   * @generated from field: rs.tokio.console.common.Id id = 1;
   */
  id?: Id;

  /**
   * The numeric ID of the resources's `Metadata`.
   *
   * @generated from field: rs.tokio.console.common.MetaId metadata = 2;
   */
  metadata?: MetaId;

  /**
   * The resources's concrete rust type.
   *
   * @generated from field: string concrete_type = 3;
   */
  concreteType = "";

  /**
   * The kind of resource (e.g timer, mutex)
   *
   * @generated from field: rs.tokio.console.resources.Resource.Kind kind = 4;
   */
  kind?: Resource_Kind;

  /**
   * The location in code where the resource was created.
   *
   * @generated from field: rs.tokio.console.common.Location location = 5;
   */
  location?: Location;

  /**
   * The ID of the parent resource.
   *
   * @generated from field: rs.tokio.console.common.Id parent_resource_id = 6;
   */
  parentResourceId?: Id;

  /**
   * Is the resource an internal component of another resource?
   *
   * For example, a `tokio::time::Interval` resource might contain a 
   * `tokio::time::Sleep` resource internally.
   *
   * @generated from field: bool is_internal = 7;
   */
  isInternal = false;

  constructor(data?: PartialMessage<Resource>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.resources.Resource";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Id },
    { no: 2, name: "metadata", kind: "message", T: MetaId },
    { no: 3, name: "concrete_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "kind", kind: "message", T: Resource_Kind },
    { no: 5, name: "location", kind: "message", T: Location },
    { no: 6, name: "parent_resource_id", kind: "message", T: Id },
    { no: 7, name: "is_internal", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Resource {
    return new Resource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Resource {
    return new Resource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Resource {
    return new Resource().fromJsonString(jsonString, options);
  }

  static equals(a: Resource | PlainMessage<Resource> | undefined, b: Resource | PlainMessage<Resource> | undefined): boolean {
    return proto3.util.equals(Resource, a, b);
  }
}

/**
 * The kind of resource (e.g. timer, mutex).
 *
 * @generated from message rs.tokio.console.resources.Resource.Kind
 */
export class Resource_Kind extends Message<Resource_Kind> {
  /**
   * Every resource is either a known kind or an other (unknown) kind.
   *
   * @generated from oneof rs.tokio.console.resources.Resource.Kind.kind
   */
  kind: {
    /**
     * `known` signals that this kind of resource is known to the console API.
     *
     * @generated from field: rs.tokio.console.resources.Resource.Kind.Known known = 1;
     */
    value: Resource_Kind_Known;
    case: "known";
  } | {
    /**
     * `other` signals that this kind of resource is unknown to the console API.
     *
     * @generated from field: string other = 2;
     */
    value: string;
    case: "other";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<Resource_Kind>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.resources.Resource.Kind";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "known", kind: "enum", T: proto3.getEnumType(Resource_Kind_Known), oneof: "kind" },
    { no: 2, name: "other", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "kind" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Resource_Kind {
    return new Resource_Kind().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Resource_Kind {
    return new Resource_Kind().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Resource_Kind {
    return new Resource_Kind().fromJsonString(jsonString, options);
  }

  static equals(a: Resource_Kind | PlainMessage<Resource_Kind> | undefined, b: Resource_Kind | PlainMessage<Resource_Kind> | undefined): boolean {
    return proto3.util.equals(Resource_Kind, a, b);
  }
}

/**
 * `Known` collects the kinds of resources that are known in this version of the API.
 *
 * @generated from enum rs.tokio.console.resources.Resource.Kind.Known
 */
export enum Resource_Kind_Known {
  /**
   * `TIMER` signals that this is a timer resource, e.g. waiting for a sleep to finish.
   *
   * @generated from enum value: TIMER = 0;
   */
  TIMER = 0,
}
// Retrieve enum metadata with: proto3.getEnumType(Resource_Kind_Known)
proto3.util.setEnumType(Resource_Kind_Known, "rs.tokio.console.resources.Resource.Kind.Known", [
  { no: 0, name: "TIMER" },
]);

/**
 * Task runtime stats of a resource.
 *
 * @generated from message rs.tokio.console.resources.Stats
 */
export class Stats extends Message<Stats> {
  /**
   * Timestamp of when the resource was created.
   *
   * @generated from field: google.protobuf.Timestamp created_at = 1;
   */
  createdAt?: Timestamp;

  /**
   * Timestamp of when the resource was dropped.
   *
   * @generated from field: google.protobuf.Timestamp dropped_at = 2;
   */
  droppedAt?: Timestamp;

  /**
   * State attributes of the resource. These are dependent on the type of the resource.
   * For example, a timer resource will have a duration while a semaphore resource may
   * have permits as an attribute. These values may change over time as the state of
   * the resource changes. Therefore, they live in the runtime stats rather than the
   * static data describing the resource.
   *
   * @generated from field: repeated rs.tokio.console.common.Attribute attributes = 3;
   */
  attributes: Attribute[] = [];

  constructor(data?: PartialMessage<Stats>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.resources.Stats";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "created_at", kind: "message", T: Timestamp },
    { no: 2, name: "dropped_at", kind: "message", T: Timestamp },
    { no: 3, name: "attributes", kind: "message", T: Attribute, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Stats {
    return new Stats().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Stats {
    return new Stats().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Stats {
    return new Stats().fromJsonString(jsonString, options);
  }

  static equals(a: Stats | PlainMessage<Stats> | undefined, b: Stats | PlainMessage<Stats> | undefined): boolean {
    return proto3.util.equals(Stats, a, b);
  }
}

/**
 * A `PollOp` describes each poll operation that completes within the async
 * application.
 *
 * @generated from message rs.tokio.console.resources.PollOp
 */
export class PollOp extends Message<PollOp> {
  /**
   * The numeric ID of the op's `Metadata`.
   *
   * This identifies the `Metadata` that describes the `tracing` span
   * corresponding to this op. The metadata for this ID will have been sent
   * in a prior `RegisterMetadata` message.
   *
   * @generated from field: rs.tokio.console.common.MetaId metadata = 2;
   */
  metadata?: MetaId;

  /**
   * The resources's ID.
   *
   * @generated from field: rs.tokio.console.common.Id resource_id = 3;
   */
  resourceId?: Id;

  /**
   * the name of this op (e.g. poll_elapsed, new_timeout, reset, etc.)
   *
   * @generated from field: string name = 4;
   */
  name = "";

  /**
   * Identifies the task context that this poll op has been called from.
   *
   * @generated from field: rs.tokio.console.common.Id task_id = 5;
   */
  taskId?: Id;

  /**
   * Identifies the async op ID that this poll op is part of.
   *
   * @generated from field: rs.tokio.console.common.Id async_op_id = 6;
   */
  asyncOpId?: Id;

  /**
   * Whether this poll op has returned with ready or pending.
   *
   * @generated from field: bool is_ready = 7;
   */
  isReady = false;

  constructor(data?: PartialMessage<PollOp>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "rs.tokio.console.resources.PollOp";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 2, name: "metadata", kind: "message", T: MetaId },
    { no: 3, name: "resource_id", kind: "message", T: Id },
    { no: 4, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "task_id", kind: "message", T: Id },
    { no: 6, name: "async_op_id", kind: "message", T: Id },
    { no: 7, name: "is_ready", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PollOp {
    return new PollOp().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PollOp {
    return new PollOp().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PollOp {
    return new PollOp().fromJsonString(jsonString, options);
  }

  static equals(a: PollOp | PlainMessage<PollOp> | undefined, b: PollOp | PlainMessage<PollOp> | undefined): boolean {
    return proto3.util.equals(PollOp, a, b);
  }
}

