/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import net.eyde.personalblog.beans.BlogProperty;
import net.eyde.personalblog.beans.CalendarAction;
import net.eyde.personalblog.beans.Category;
import net.eyde.personalblog.beans.Comment;
import net.eyde.personalblog.beans.Post;
import net.eyde.personalblog.beans.Referrer;
import net.eyde.personalblog.service.CacheManager;
import net.eyde.personalblog.service.InitializationException;
import net.eyde.personalblog.service.PropertyManager;
import net.eyde.personalblog.service.ServiceException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonalBlogService {
    public static final String INSTALLATION_STATE = "installation_state";
    public static final String STATE_UNDEFINED = "undefined";
    public static final String STATE_NO_HIBERNATE_FILE = "no_hibernate_file";
    public static final String STATE_DATABASE_OFF = "database_off";
    public static final String STATE_HIBERNATE_FILE_INVALID = "hibernate_file_invalid";
    public static final String STATE_TABLES_NOT_CREATED = "tables_not_created_yet";
    public static final String STATE_MISSING_PROPERTIES = "missing_properties";
    public static final String STATE_OK = "ok";
    private static Log log = LogFactory.getLog(PersonalBlogService.class);
    private static PersonalBlogService service = null;
    public static final String WEBLOG_TITLE = "weblog.title";
    public static final String WEBLOG_DESCRIPTION = "weblog.description";
    public static final String WEBLOG_PICTURE = "weblog.ownerpicture";
    public static final String WEBLOG_OWNER_NICK_NAME = "weblog.ownernickname";
    public static final String WEBLOG_URL = "weblog.url";
    public static final String WEBLOG_OWNER = "weblog.owner";
    public static final String WEBLOG_EMAIL = "weblog.email";
    public static final String LINK_POST = "links.post";
    public static final String EMOTICON_VALUES = "emoticon.values";
    public static final String EMOTICON_IMAGES = "emoticon.images";
    public static final String LOGON_ID = "logon.id";
    public static final String LOGON_PASSWORD = "logon.password";
    public static final String EDITOR = "weblog.editor";
    public static final String EMAIL_HOST = "mail.smtp.host";
    public static final String EMAIL_TRANSPORT = "mail.transport";
    public static final String EMAIL_USERNAME = "mail.username";
    public static final String EMAIL_PASSWORD = "mail.password";
    public static final String CATEGORY_TITLES = "category.titles";
    public static final String CATEGORY_VALUES = "category.values";
    public static final String CATEGORY_IMAGES = "category.images";
    Configuration cfg;
    SessionFactory sf;
    int adjustHours;
    PropertyManager pm;
    CacheManager cache;
    Locale myLocale = Locale.US;
    String dburl;
    String dbuser;
    String dbpassword;
    SimpleDateFormat qf = new SimpleDateFormat("yyyy-MM-dd", this.myLocale);
    SimpleDateFormat monthNav = new SimpleDateFormat("yyyyMM", this.myLocale);

    protected PersonalBlogService(Properties conn) throws InitializationException {
        log.debug((Object)"initialization - constructor");
        try {
            this.cfg = new Configuration().addClass(Post.class).addClass(Comment.class).addClass(Referrer.class).addClass(BlogProperty.class);
            if (conn != null) {
                this.cfg.setProperties(conn);
                this.pm = new PropertyManager(conn);
            } else {
                this.pm = new PropertyManager();
            }
            this.sf = this.cfg.buildSessionFactory();
        }
        catch (Exception e) {
            log.error((Object)"Error initializing PersonalBlog Service", (Throwable)e);
            throw new InitializationException(e);
        }
    }

    public static PersonalBlogService getInstance() throws ServiceException {
        if (service == null) {
            try {
                log.debug((Object)"Initializing PersonalBlog Service (WITHOUT CONNECTION PARMS)");
                service = new PersonalBlogService(null);
            }
            catch (ServiceException e) {
                log.error((Object)"Error getting instance of PersonalBlog Service", (Throwable)e);
                throw e;
            }
        }
        return service;
    }

    public static PersonalBlogService getInstance(Properties conn) throws ServiceException {
        if (service == null) {
            try {
                log.debug((Object)"Initializing PersonalBlog Service (WITH CONNECTION PARMS)");
                service = new PersonalBlogService(conn);
            }
            catch (Exception e) {
                log.error((Object)"Error getting instance of PersonalBlog Service", (Throwable)e);
            }
        }
        return service;
    }

    public PropertyManager getPropertyManager() {
        return this.pm;
    }

    public List<?> getPosts() throws ServiceException {
        Session session = null;
        List posts = null;
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        String startdate = this.qf.format(cal.getTime());
        try {
            session = this.sf.openSession();
        }
        catch (Exception e) {
            log.error((Object)"error opening session", (Throwable)e);
            throw new ServiceException(e);
        }
        try {
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.created > '" + startdate + "' order by post.created desc");
        }
        catch (Exception e) {
            log.error((Object)"error reading posts", (Throwable)e);
            throw new ServiceException(e);
        }
        try {
            session.close();
        }
        catch (Exception e) {
            log.error((Object)"error closing session", (Throwable)e);
            throw new ServiceException(e);
        }
        return posts;
    }

    public List<?> getPostsByDate(String dateParm) throws ServiceException {
        Session session = null;
        List posts = null;
        Calendar cal = Calendar.getInstance();
        if (!dateParm.equals("")) {
            cal.set(1, Integer.parseInt(dateParm.substring(0, 4)));
            cal.set(2, Integer.parseInt(dateParm.substring(5, 7)) - 1);
            cal.set(5, Integer.parseInt(dateParm.substring(8, 10)));
        }
        cal.add(5, 1);
        String end = this.qf.format(cal.getTime());
        cal.set(5, 1);
        String start = this.qf.format(cal.getTime());
        try {
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.created >= '" + start + "' and post.created <= '" + end + "' order by post.created desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading posts | dateParam:" + dateParm), (Throwable)e);
            throw new ServiceException(e);
        }
        return posts;
    }

    public List<?> getPostsByMonth(String monthParm) throws ServiceException {
        Session session = null;
        List posts = null;
        Calendar cal = Calendar.getInstance();
        if (!monthParm.equals("")) {
            cal.set(1, Integer.parseInt(monthParm.substring(0, 4)));
            cal.set(2, Integer.parseInt(monthParm.substring(5, 7)) - 1);
            cal.set(5, 1);
        } else {
            cal.set(5, 1);
        }
        String start = this.qf.format(cal.getTime());
        cal.add(2, 1);
        cal.add(5, -1);
        String end = this.qf.format(cal.getTime());
        try {
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.created >= '" + start + "' and post.created <= '" + end + "' order by post.created desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading posts |dateParam:" + monthParm), (Throwable)e);
            throw new ServiceException(e);
        }
        return posts;
    }

    public List<?> getPostsByCategory(String cat) throws ServiceException {
        Session session = null;
        List posts = null;
        try {
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.category like '%" + cat + "%' order by post.created desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading posts | cat:" + cat), (Throwable)e);
            throw new ServiceException(e);
        }
        return posts;
    }

    public List<?> getPostsBySearch(String searchTxt) throws ServiceException {
        Session session = null;
        List posts = null;
        searchTxt = searchTxt.replace('\'', ' ');
        searchTxt = searchTxt.replace(';', ' ');
        try {
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.content like '%" + searchTxt + "%' " + "   or post.title   like '%" + searchTxt + "%' " + "order by post.created desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading posts | searchTxt:" + searchTxt), (Throwable)e);
            throw new ServiceException(e);
        }
        return posts;
    }

    public void createPost(Post inPost) throws ServiceException {
        Session session = null;
        try {
            session = this.sf.openSession();
            inPost.setCreated(new Date());
            inPost.setModified(inPost.getCreated());
            session.save((Object)inPost);
            session.flush();
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while creating post | postId:" + inPost.getId()), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public void updatePost(String postId, String title, String content, String cat) throws ServiceException {
        Session session = null;
        try {
            session = this.sf.openSession();
            Post post = (Post)session.load(Post.class, (Serializable)((Object)postId));
            post.setTitle(title);
            post.setContent(content);
            post.setCategory(cat);
            post.setModified(new Date());
            session.update((Object)post);
            session.flush();
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while updating post | postId:" + postId), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public void updatePost(Post inPost) throws ServiceException {
        Session session = null;
        try {
            session = this.sf.openSession();
            inPost.setModified(new Date());
            session.update((Object)inPost, (Serializable)((Object)inPost.getId()));
            session.flush();
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while updating post | postId:" + inPost.getId()), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public void deletePost(String postId) throws ServiceException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.delete(session.load(Post.class, (Serializable)((Object)postId)));
            session.flush();
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while deleting post| postId:" + postId), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public Post getPost(String postId) throws ServiceException {
        Session session = null;
        Post post = null;
        try {
            session = this.sf.openSession();
            post = (Post)session.load(Post.class, (Serializable)((Object)postId));
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading post id:" + postId), (Throwable)e);
            throw new ServiceException("Error while reading post id:" + postId, e);
        }
        return post;
    }

    public List<?> getOldPost(String oldReference) throws ServiceException {
        Session session = null;
        List posts = null;
        try {
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.reference like '" + oldReference + "%' " + "order by post.created desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading posts | ref:" + oldReference), (Throwable)e);
            throw new ServiceException(e);
        }
        return posts;
    }

    public void createComment(Comment newComment, String postId) throws ServiceException {
        Session session = null;
        try {
            session = this.sf.openSession();
            Post currentPost = (Post)session.load(Post.class, (Serializable)((Object)postId));
            newComment.setCreated(new Date());
            currentPost.addComment(newComment);
            session.update((Object)currentPost, (Serializable)((Object)currentPost.getId()));
            session.flush();
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while creating comment | postId:" + postId), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public void createComment(Comment newComment, Post post) throws ServiceException {
        Session session = null;
        try {
            session = this.sf.openSession();
            newComment.setCreated(new Date());
            post.addComment(newComment);
            session.update((Object)post, (Serializable)((Object)post.getId()));
            session.flush();
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("Error while creating comment | postId:" + post.getId()), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public List<?> getRecentComments() throws ServiceException {
        Session session = null;
        List comments = null;
        try {
            session = this.sf.openSession();
            comments = session.find("from comment in class net.eyde.personalblog.beans.Comment order by comment.created desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while reading comment", (Throwable)e);
            throw new ServiceException(e);
        }
        log.debug((Object)("qty comments returned:" + comments.size()));
        return comments;
    }

    public Post getLinks() throws ServiceException {
        Session session = null;
        Post post = null;
        String link = null;
        try {
            session = this.sf.openSession();
            link = this.getPropertyManager().getProperty(LINK_POST);
            post = (Post)session.load(Post.class, (Serializable)((Object)link));
            session.close();
        }
        catch (ObjectNotFoundException e) {
            log.info((Object)("couldn't find object:" + link));
            post = this.initializeLinks();
        }
        catch (Exception e) {
            log.error((Object)"Error while reading links", (Throwable)e);
            throw new ServiceException(e);
        }
        return post;
    }

    public Post initializeLinks() throws ServiceException {
        Session session = null;
        log.debug((Object)"Creating links post");
        Post post = new Post();
        post.setContent("Blogroll");
        post.setEmailComments(Boolean.FALSE);
        post.setTitle("Blogroll");
        this.createPost(post);
        try {
            List posts = null;
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.title = 'Blogroll'");
            Iterator postsit = posts.iterator();
            if (postsit.hasNext()) {
                post = (Post)postsit.next();
            }
            session.close();
        }
        catch (ObjectNotFoundException e) {
            log.info((Object)"couldn't find link object");
        }
        catch (Exception e) {
            log.error((Object)"Error while reading links", (Throwable)e);
            throw new ServiceException(e);
        }
        this.pm.updateProperty(LINK_POST, post.getId());
        return post;
    }

    public List<?> getReferrers() throws ServiceException {
        Session session = null;
        List referrers = null;
        Calendar cal = Calendar.getInstance();
        try {
            session = this.sf.openSession();
            referrers = session.find("from referrer in class net.eyde.personalblog.beans.Referrer where referrer.date > '" + this.qf.format(cal.getTime()) + "' " + "order by referrer.counter desc");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while reading Referrers", (Throwable)e);
            throw new ServiceException(e);
        }
        return referrers;
    }

    public List<?> getCategories() {
        log.info((Object)"Retrieving Categories");
        ArrayList<Category> categories = new ArrayList<Category>();
        StringTokenizer catTitles = null;
        StringTokenizer catValues = null;
        StringTokenizer catImages = null;
        try {
            catTitles = new StringTokenizer(this.getPropertyManager().getProperty(CATEGORY_TITLES), ",");
            catValues = new StringTokenizer(this.getPropertyManager().getProperty(CATEGORY_VALUES), ",");
            catImages = new StringTokenizer(this.getPropertyManager().getProperty(CATEGORY_IMAGES), ",");
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing Categories ", (Throwable)e);
        }
        while (catTitles.hasMoreTokens()) {
            Category item = new Category();
            item.setName(catTitles.nextToken());
            item.setValue(catValues.nextToken().charAt(0));
            item.setImage(catImages.nextToken());
            log.info((Object)("Category '" + item.getName() + "' parsed."));
            categories.add(item);
        }
        return categories;
    }

    public List<?> getEmoticons() {
        log.info((Object)"Retrieving Emoticons");
        ArrayList<Category> emoticons = new ArrayList<Category>();
        StringTokenizer emotValues = null;
        StringTokenizer emotImages = null;
        try {
            emotValues = new StringTokenizer(this.getPropertyManager().getProperty(EMOTICON_VALUES), ",");
            emotImages = new StringTokenizer(this.getPropertyManager().getProperty(EMOTICON_IMAGES), ",");
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing Emoticons", (Throwable)e);
        }
        while (emotValues.hasMoreTokens()) {
            Category item = new Category();
            item.setValue(emotValues.nextToken().charAt(0));
            item.setImage(emotImages.nextToken());
            emoticons.add(item);
        }
        return emoticons;
    }

    protected String cleanNull(String val) {
        if (val == null || val.trim().equals("")) {
            return "";
        }
        return val;
    }

    protected Date adjustDate(Date date) {
        GregorianCalendar adjust = new GregorianCalendar();
        adjust.setTime(date);
        ((Calendar)adjust).add(10, this.adjustHours);
        date = adjust.getTime();
        return date;
    }

    public void checkReferer(String refUrl) throws ServiceException {
        Session session = null;
        log.debug((Object)("referer URL:" + refUrl));
        Referrer ref = null;
        try {
            if (!(refUrl == null || refUrl.startsWith(PersonalBlogService.getInstance().getPropertyManager().getProperty(WEBLOG_URL)) || refUrl.startsWith("http://127.0.0.1") || refUrl.startsWith("http://localhost") || refUrl.indexOf(":5335") >= 0)) {
                Calendar cal = Calendar.getInstance();
                session = this.sf.openSession();
                Date today = new Date();
                List referrerList = session.find("from referrer in class net.eyde.personalblog.beans.Referrer where referrer.referrer = '" + refUrl + "' " + "and referrer.date > '" + this.qf.format(cal.getTime()) + "' ");
                Iterator referrers = referrerList.iterator();
                if (referrers.hasNext()) {
                    ref = (Referrer)referrers.next();
                }
                if (ref == null) {
                    ref = new Referrer();
                    ref.setDate(today);
                    ref.setCreated(new Date());
                    ref.setReferrer(refUrl);
                    ref.setCounter(1);
                    session.save((Object)ref);
                } else {
                    ref.setCounter(ref.getCounter() + 1);
                    session.update((Object)ref, (Serializable)((Object)ref.getId()));
                }
                session.flush();
                session.close();
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)("refUrl:" + refUrl), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    public String getCurrMonth(String referenceDate) {
        return this.calcMonth(referenceDate, 0);
    }

    public String calcMonth(String referenceDate, int offset) {
        Calendar cal = Calendar.getInstance();
        if (!referenceDate.equals("")) {
            cal.set(1, Integer.parseInt(referenceDate.substring(0, 4)));
            cal.set(2, Integer.parseInt(referenceDate.substring(5, 7)) - 1);
            cal.set(5, 1);
        } else {
            cal.set(5, 1);
        }
        cal.add(2, offset);
        return this.qf.format(cal.getTime());
    }

    public String getPrevMonth(String referenceDate) {
        return this.calcMonth(referenceDate, -1);
    }

    public String getNextMonth(String referenceDate) {
        return this.calcMonth(referenceDate, 1);
    }

    public List<?> getCalendarActions(String dateParm) throws ServiceException {
        Session session = null;
        ArrayList<CalendarAction> actions = new ArrayList<CalendarAction>();
        List posts = null;
        Calendar cal = Calendar.getInstance();
        if (!dateParm.equals("")) {
            cal.set(1, Integer.parseInt(dateParm.substring(0, 4)));
            cal.set(2, Integer.parseInt(dateParm.substring(5, 7)) - 1);
            cal.set(5, 1);
        }
        cal.set(5, 1);
        String start = this.qf.format(cal.getTime());
        cal.add(2, 1);
        cal.add(5, -1);
        String end = this.qf.format(cal.getTime());
        try {
            session = this.sf.openSession();
            posts = session.find("from post in class net.eyde.personalblog.beans.Post where post.created >= '" + start + "' and post.created <= '" + end + "'");
            session.close();
        }
        catch (Exception e) {
            log.error((Object)("dataParam=" + dateParm), (Throwable)e);
            throw new ServiceException("dateParam" + dateParm, e);
        }
        for (Post post : posts) {
            CalendarAction calAction = new CalendarAction();
            calAction.setDay(post.getCreated().getDate());
            calAction.setUrl("index.do?caldate=" + this.qf.format(post.getCreated()));
            if (actions.contains(calAction)) continue;
            actions.add(calAction);
        }
        return actions;
    }

    public boolean checkLogIn(String inUser, String inPassword) {
        log.debug((Object)("Checking Login: " + inUser + "/" + inPassword));
        try {
            return inUser != null && inPassword != null && inUser.equals(this.getPropertyManager().getProperty(LOGON_ID)) && inPassword.equals(this.getPropertyManager().getProperty(LOGON_PASSWORD));
        }
        catch (Exception e) {
            log.info((Object)inPassword, (Throwable)e);
            return false;
        }
    }

    public void importOldData() throws ServiceException {
        Session session = null;
        SimpleDateFormat datef = new SimpleDateFormat("yyyyMMdd", this.myLocale);
        SimpleDateFormat timef = new SimpleDateFormat("HHmmss", this.myLocale);
        String sql = "select * from personalblog where parentId = 0 order by created desc";
        try {
            Class.forName("org.gjt.mm.mysql.Driver");
            Connection conn = DriverManager.getConnection(String.valueOf(this.dburl) + "?user=" + this.dbuser + "&password=" + this.dbpassword);
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                session = this.sf.openSession();
                Post xyz = new Post();
                Timestamp created = rs.getTimestamp("created");
                xyz.setContent(rs.getString("content"));
                xyz.setCategory(rs.getString("category"));
                xyz.setCreated(rs.getDate("created"));
                xyz.setModified(rs.getDate("modified"));
                xyz.setTitle(rs.getString("title"));
                xyz.setReference(String.valueOf(datef.format(created)) + "#" + timef.format(created));
                session.save((Object)xyz);
                session.flush();
                session.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while importing data", (Throwable)e);
            throw new ServiceException(e);
        }
    }
}

