# RentalVehicle

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **String** | Unique identifier of the rental vehicle | 
**provider_id** | **String** | Unique identifier of the rental provider | 
**provider_group_id** | **String** | Unique identifier of the rental provider group | 
**type_id** | **String** | Vehicle type ID (unique within the provider) | 
**lat** | **f64** | latitude | 
**lon** | **f64** | longitude | 
**form_factor** | [**models::RentalFormFactor**](RentalFormFactor.md) |  | 
**propulsion_type** | [**models::RentalPropulsionType**](RentalPropulsionType.md) |  | 
**return_constraint** | [**models::RentalReturnConstraint**](RentalReturnConstraint.md) |  | 
**station_id** | Option<**String**> | Station ID if the vehicle is currently at a station | [optional]
**home_station_id** | Option<**String**> | Station ID where the vehicle must be returned, if applicable | [optional]
**is_reserved** | **bool** | true if the vehicle is currently reserved by a customer, false otherwise | 
**is_disabled** | **bool** | true if the vehicle is out of service, false otherwise | 
**rental_uri_android** | Option<**String**> | Rental URI for Android (deep link to the specific vehicle) | [optional]
**rental_uri_ios** | Option<**String**> | Rental URI for iOS (deep link to the specific vehicle) | [optional]
**rental_uri_web** | Option<**String**> | Rental URI for web (deep link to the specific vehicle) | [optional]

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


