/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.detect;

import com.intellij.ide.ProjectGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.ProjectDetector;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.detect.EclipseProjectDetectorUsagesCollector;

@ApiStatus.Internal
public final class EclipseProjectDetector
extends ProjectDetector {
    private static final Logger LOG = Logger.getInstance(EclipseProjectDetector.class);

    void collectProjectPaths(List<String> projects) {
        String home = System.getProperty("user.home");
        Path path = Path.of(home, ".eclipse/org.eclipse.oomph.setup/setups/locations.setup");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> workspaceUrls = EclipseProjectDetector.parseOomphLocations(Files.readString(path));
                for (String url : workspaceUrls) {
                    EclipseProjectDetector.scanForProjects(URI.create(url).getPath(), projects);
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        for (String appLocation : this.getStandardAppLocations()) {
            EclipseProjectDetector.collectProjects(projects, Path.of(appLocation, new String[0]));
        }
        if (PropertiesComponent.getInstance().getBoolean("eclipse.scan.home.directory", true)) {
            EclipseProjectDetector.visitFiles(new File(home), file1 -> EclipseProjectDetector.scanForProjects(file1.getPath(), projects), 2);
        }
    }

    String[] getStandardAppLocations() {
        Object[] folders;
        if (SystemInfo.isMac) {
            return new String[]{"/Applications/Eclipse.app/Contents/Eclipse/configuration/.settings/org.eclipse.ui.ide.prefs"};
        }
        if (SystemInfo.isWindows && (folders = Path.of(System.getProperty("user.home"), "eclipse").toFile().listFiles()) != null) {
            return (String[])ContainerUtil.map2Array((Object[])folders, String.class, file -> file.getPath());
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void detectProjects(Consumer<? super List<String>> onFinish) {
        AppJavaExecutorUtil.executeOnPooledIoThread(() -> {
            try {
                RecentProjectsManagerBase manager = (RecentProjectsManagerBase)RecentProjectsManager.getInstance();
                @Nls String groupName = EclipseBundle.message("eclipse.projects", new Object[0]);
                ProjectGroup group = (ProjectGroup)ContainerUtil.find((Iterable)manager.getGroups(), g -> groupName.equals(g.getName()));
                String property = "eclipse.projects.detected";
                if (group == null && PropertiesComponent.getInstance().isValueSet(property)) {
                    return;
                }
                ArrayList<String> projects = new ArrayList<String>();
                new EclipseProjectDetector().collectProjectPaths(projects);
                HashSet<String> set = new HashSet<String>(projects);
                if (!PropertiesComponent.getInstance().isValueSet(property)) {
                    EclipseProjectDetectorUsagesCollector.logProjectsDetected(set.size());
                    PropertiesComponent.getInstance().setValue(property, "");
                }
                projects.removeAll(manager.getRecentPaths());
                if (projects.isEmpty()) {
                    return;
                }
                if (group == null) {
                    group = new ProjectGroup(groupName);
                    group.setBottomGroup(true);
                    group.setProjects(new ArrayList<String>(set));
                    manager.addGroup(group);
                } else {
                    group.getProjects().retainAll(set);
                }
                ProjectGroup finalGroup = group;
                ApplicationManager.getApplication().invokeLater(() -> onFinish.accept(finalGroup.getProjects()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public void logRecentProjectOpened(@Nullable ProjectGroup projectGroup) {
        if (projectGroup != null && EclipseBundle.message("eclipse.projects", new Object[0]).equals(projectGroup.getName())) {
            EclipseProjectDetectorUsagesCollector.logProjectOpened(false);
        }
    }

    static void collectProjects(List<String> projects, Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            String[] workspaces;
            String prefs = FileUtil.loadFile((File)file);
            for (String workspace : workspaces = EclipseProjectDetector.getWorkspaces(prefs)) {
                EclipseProjectDetector.scanForProjects(workspace, projects);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    public static String[] getWorkspaces(String prefs) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(prefs));
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Throwable)e);
        }
        String workspaces = properties.getProperty("RECENT_WORKSPACES");
        return workspaces == null ? ArrayUtil.EMPTY_STRING_ARRAY : workspaces.split("\\n");
    }

    static void scanForProjects(String workspace, List<String> projects) {
        if (EclipseProjectDetector.isInSpecialMacFolder(workspace)) {
            return;
        }
        File[] files = new File(workspace).listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            Object[] list;
            if (EclipseProjectDetector.isInSpecialMacFolder(file.getPath()) || (list = file.list()) == null || !ContainerUtil.or((Object[])list, s -> ".project".equals(s)) || !ContainerUtil.or((Object[])list, s -> ".classpath".equals(s))) continue;
            projects.add(file.getPath());
        }
    }

    @VisibleForTesting
    public static List<String> parseOomphLocations(String fileContent) throws Exception {
        Element root = JDOMUtil.load((CharSequence)fileContent);
        List elements = root.getChildren("workspace");
        return ContainerUtil.map((Collection)elements, element1 -> StringUtil.trimEnd((String)Objects.requireNonNull(Objects.requireNonNull(element1.getChild("key")).getAttributeValue("href")), (String)"/.metadata/.plugins/org.eclipse.oomph.setup/workspace.setup#/"));
    }

    private static boolean isInSpecialMacFolder(String file) {
        if (!SystemInfo.isMac) {
            return false;
        }
        if (FileSystemUtil.isSymLink((String)file)) {
            return true;
        }
        String home = System.getProperty("user.home");
        Path path = Path.of(file, new String[0]);
        return path.startsWith(Path.of(home, "Documents")) || path.startsWith(Path.of(home, "Pictures")) || path.startsWith(Path.of(home, "Downloads")) || path.startsWith(Path.of(home, "Desktop")) || path.startsWith(Path.of(home, "Library"));
    }

    private static void visitFiles(File file, Consumer<File> processor, int depth) {
        if (depth == 0 || EclipseProjectDetector.isInSpecialMacFolder(file.getPath())) {
            return;
        }
        processor.accept(file);
        File[] files = file.listFiles(pathname -> !pathname.getName().startsWith("."));
        if (files == null) {
            return;
        }
        for (File child : files) {
            EclipseProjectDetector.visitFiles(child, processor, depth - 1);
        }
    }
}

