/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ThreadListOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.BackTracesCallTree;
import com.intellij.profiler.model.CallTree;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.MergedCallTree;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.RichCallTreeModel;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.threadview.NoMetric;
import com.intellij.profiler.ui.threadview.PersistentMetric;
import com.intellij.profiler.ui.threadview.ThreadList;
import com.intellij.profiler.ui.threadview.ThreadListSortActions;
import com.intellij.profiler.ui.threadview.ThreadMetric;
import com.intellij.profiler.ui.threadview.ThreadMetricValue;
import com.intellij.profiler.ui.threadview.UIVisibleThreadInfo;
import com.intellij.profiler.ui.threadview.UIVisibleThreadInfoKt;
import com.intellij.ui.SortedListModel;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002<=B=\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020(H\u0002J+\u0010.\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b0H\u0002J.\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003H\u0002J \u00102\u001a\u000203\"\b\b\u0000\u00104*\u0002052\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H40\u0005H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u0002032\u0006\u00109\u001a\u000203H\u0002J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0004R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR:\u0010 \u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u000f0\u000f0\u001e2\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u000f0\u000f0\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;", "", "model", "", "Lcom/intellij/profiler/model/ThreadInfo;", "Lcom/intellij/profiler/model/CallTree;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "onThreadSelected", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lcom/intellij/profiler/api/ValueMetric;Lkotlin/jvm/functions/Function1;)V", "uiThreads", "", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "getUiThreads", "()Ljava/util/List;", "threadLists", "", "Lcom/intellij/profiler/ui/threadview/ThreadList;", "selector", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector;", "sortActions", "Lcom/intellij/profiler/ui/threadview/ThreadListSortActions;", "getSortActions", "()Lcom/intellij/profiler/ui/threadview/ThreadListSortActions;", "sortActions$delegate", "Lkotlin/Lazy;", "value", "Lcom/intellij/ui/SortedListModel;", "kotlin.jvm.PlatformType", "listModel", "getListModel", "()Lcom/intellij/ui/SortedListModel;", "selectionModel", "Ljavax/swing/DefaultListSelectionModel;", "register", "threadList", "isCurrentComparator", "", "comparator", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "updateModel", "newComparator", "state", "forEachWithPreservedSelection", "action", "Lkotlin/ExtensionFunctionType;", "buildUIThreadsList", "getValue", "", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "getFraction", "", "threadValue", "totalValue", "select", "thread", "ThreadListComparator", "ThreadListComparatorSelector", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nThreadListSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,327:1\n1869#2,2:328\n1252#2,4:332\n1563#2:336\n1634#2,3:337\n1563#2:340\n1634#2,3:341\n463#3:330\n413#3:331\n*S KotlinDebug\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer\n*L\n93#1:328,2\n104#1:332,4\n108#1:336\n108#1:337,3\n55#1:340\n55#1:341,3\n104#1:330\n104#1:331\n*E\n"})
public final class ThreadListSynchronizer {
    @NotNull
    private final Function1<ThreadInfo, Unit> onThreadSelected;
    @NotNull
    private final List<UIVisibleThreadInfo> uiThreads;
    @NotNull
    private final List<ThreadList> threadLists;
    @Nullable
    private final ThreadListComparatorSelector selector;
    @NotNull
    private final Lazy sortActions$delegate;
    @NotNull
    private SortedListModel<UIVisibleThreadInfo> listModel;
    @NotNull
    private final DefaultListSelectionModel selectionModel;

    /*
     * WARNING - void declaration
     */
    public ThreadListSynchronizer(@NotNull Map<ThreadInfo, ? extends CallTree<?>> model2, @NotNull ValueMetric metric, @NotNull Function1<? super ThreadInfo, Unit> onThreadSelected) {
        void $this$selectionModel_u24lambda_u244;
        DefaultListSelectionModel defaultListSelectionModel;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter(onThreadSelected, (String)"onThreadSelected");
        this.onThreadSelected = onThreadSelected;
        this.uiThreads = this.buildUIThreadsList(metric, model2);
        this.threadLists = new ArrayList();
        this.selector = ThreadListComparator.Companion.buildSelector((Collection<UIVisibleThreadInfo>)this.uiThreads);
        this.sortActions$delegate = LazyKt.lazy(() -> ThreadListSynchronizer.sortActions_delegate$lambda$2(this));
        Collection collection = this.uiThreads;
        Object object = this.selector;
        if (object == null || (object = ((ThreadListComparatorSelector)object).getCurrentComparator()) == null || (object = ((ThreadListComparator)object).getComparator()) == null) {
            object = ThreadListComparator.Default.INSTANCE.getComparator();
        }
        this.listModel = new SortedListModel(collection, object);
        DefaultListSelectionModel defaultListSelectionModel2 = defaultListSelectionModel = new DefaultListSelectionModel();
        ThreadListSynchronizer threadListSynchronizer = this;
        boolean bl = false;
        $this$selectionModel_u24lambda_u244.setSelectionMode(0);
        $this$selectionModel_u24lambda_u244.addListSelectionListener(arg_0 -> ThreadListSynchronizer.selectionModel$lambda$4$lambda$3((DefaultListSelectionModel)$this$selectionModel_u24lambda_u244, this, arg_0));
        threadListSynchronizer.selectionModel = defaultListSelectionModel;
    }

    public /* synthetic */ ThreadListSynchronizer(Map map, ValueMetric valueMetric, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = ThreadListSynchronizer::_init_$lambda$0;
        }
        this(map, valueMetric, (Function1<? super ThreadInfo, Unit>)function1);
    }

    @NotNull
    public final List<UIVisibleThreadInfo> getUiThreads() {
        return this.uiThreads;
    }

    @NotNull
    public final ThreadListSortActions getSortActions() {
        Lazy lazy = this.sortActions$delegate;
        return (ThreadListSortActions)lazy.getValue();
    }

    @NotNull
    public final SortedListModel<UIVisibleThreadInfo> getListModel() {
        return this.listModel;
    }

    public final void register(@NotNull ThreadList threadList) {
        Intrinsics.checkNotNullParameter((Object)((Object)threadList), (String)"threadList");
        threadList.getList().setSelectionModel((ListSelectionModel)this.selectionModel);
        ((Collection)this.threadLists).add(threadList);
    }

    private final boolean isCurrentComparator(ThreadListComparator comparator) {
        ThreadListComparatorSelector threadListComparatorSelector = this.selector;
        return threadListComparatorSelector != null ? threadListComparatorSelector.isSelected(comparator) : false;
    }

    private final void updateModel(ThreadListComparator newComparator, boolean state) {
        if (this.selector == null) {
            return;
        }
        if (state) {
            this.selector.select(newComparator);
        } else {
            this.selector.deselect(newComparator);
        }
        this.listModel = new SortedListModel((Collection)this.uiThreads, this.selector.getCurrentComparator().getComparator());
        this.forEachWithPreservedSelection(this.threadLists, (Function1<? super ThreadList, Unit>)((Function1)arg_0 -> ThreadListSynchronizer.updateModel$lambda$5(this, arg_0)));
    }

    private final void forEachWithPreservedSelection(List<ThreadList> $this$forEachWithPreservedSelection, Function1<? super ThreadList, Unit> action) {
        ThreadList threadList = (ThreadList)((Object)CollectionsKt.firstOrNull($this$forEachWithPreservedSelection));
        if (threadList == null) {
            return;
        }
        ThreadList representative = threadList;
        List values = representative.getList().getSelectedValuesList();
        Iterable $this$forEach$iv = $this$forEachWithPreservedSelection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThreadList it = (ThreadList)((Object)element$iv);
            boolean bl = false;
            action.invoke((Object)it);
        }
        List indices = new ArrayList();
        int n = representative.getList().getModel().getSize();
        for (int i = 0; i < n; ++i) {
            if (!values.contains(representative.getList().getModel().getElementAt(i))) continue;
            ((Collection)indices).add(i);
        }
        representative.getList().setSelectedIndices(CollectionsKt.toIntArray((Collection)indices));
    }

    /*
     * WARNING - void declaration
     */
    private final List<UIVisibleThreadInfo> buildUIThreadsList(ValueMetric metric, Map<ThreadInfo, ? extends CallTree<?>> model2) {
        void $this$mapTo$iv$iv;
        Object object;
        ThreadInfo it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<ThreadInfo, CallTree<?>> $this$mapValues$iv = model2;
        boolean $i$f$mapValues = false;
        Map<ThreadInfo, CallTree<?>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            ThreadInfo thread = (ThreadInfo)entry2.getKey();
            CallTree model3 = (CallTree)entry2.getValue();
            Long l = thread instanceof AllThreadsMerged ? 0L : this.getValue(model3);
            object.put(k, l);
        }
        Map threads2Values = destination$iv$iv;
        long allThreadsValue = CollectionsKt.sumOfLong((Iterable)threads2Values.values());
        Iterable $this$map$iv = model2.keySet();
        boolean $i$f$map = false;
        Iterable $i$f$mapValuesTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UIVisibleThreadInfo uIVisibleThreadInfo;
            void thread;
            it$iv$iv = (ThreadInfo)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            if (thread instanceof AllThreadsMerged) {
                uIVisibleThreadInfo = UIVisibleThreadInfoKt.asUIThread$default((ThreadInfo)thread, null, 1, null);
            } else {
                ThreadMetric<Float> threadMetric = metric.getThreadMetric();
                ThreadMetricValue<Float> metricValue = threadMetric != null ? threadMetric.buildValue((Float)((Comparable)Float.valueOf(this.getFraction(((Number)MapsKt.getValue((Map)threads2Values, (Object)thread)).longValue(), allThreadsValue)))) : null;
                uIVisibleThreadInfo = UIVisibleThreadInfoKt.asUIThread((ThreadInfo)thread, metricValue);
            }
            object.add(uIVisibleThreadInfo);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
    }

    private final <Call extends BaseCallStackElement> long getValue(CallTree<Call> model2) {
        TreeNode treeNode;
        CallTree<Call> callTree = model2;
        if (callTree instanceof BackTracesCallTree.NotRecursive) {
            treeNode = ((BackTracesCallTree.NotRecursive)model2).getRoot();
        } else if (callTree instanceof BackTracesCallTree.Recursive) {
            treeNode = ((BackTracesCallTree.Recursive)model2).getFromRoots();
        } else if (callTree instanceof MergedCallTree.NotRecursive) {
            treeNode = ((MergedCallTree.NotRecursive)model2).getRoot();
        } else if (callTree instanceof MergedCallTree.Recursive) {
            treeNode = ((MergedCallTree.Recursive)model2).getUnfolded();
        } else if (callTree instanceof RichCallTreeModel) {
            treeNode = ((RichCallTreeModel)model2).getCallTree();
        } else {
            throw new RuntimeException("Unknown model: " + model2);
        }
        TreeNode tree = treeNode;
        return ProfilerUIUtilsKt.valueOrSumOfChildrenValues(tree);
    }

    private final float getFraction(long threadValue, long totalValue) {
        if (threadValue <= 0L) {
            return 0.0f;
        }
        return (float)threadValue / (float)totalValue;
    }

    public final void select(@NotNull ThreadInfo thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        int threadIdToSelect = 0;
        int n = this.listModel.getSize();
        for (int i = 0; i < n; ++i) {
            ThreadInfo t = ((UIVisibleThreadInfo)this.listModel.get(i)).getThreadInfo();
            if (!Intrinsics.areEqual((Object)t.getName(), (Object)thread.getName()) || !Intrinsics.areEqual((Object)t.getNativeId(), (Object)thread.getNativeId())) continue;
            threadIdToSelect = i;
            break;
        }
        this.selectionModel.setSelectionInterval(threadIdToSelect, threadIdToSelect);
    }

    private static final Unit _init_$lambda$0(ThreadInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final ToggleAction sortActions_delegate$lambda$2$createSortAction(ThreadListSynchronizer this$0, List<? extends ThreadListComparator> allComparators, ThreadListComparator comparator) {
        String string = comparator.getName();
        return (ToggleAction)new DumbAwareToggleAction(this$0, comparator, allComparators, string){
            final /* synthetic */ ThreadListSynchronizer this$0;
            final /* synthetic */ ThreadListComparator $comparator;
            final /* synthetic */ List<ThreadListComparator> $allComparators;
            {
                this.this$0 = $receiver;
                this.$comparator = $comparator;
                this.$allComparators = $allComparators;
                super($super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return ThreadListSynchronizer.access$isCurrentComparator(this.this$0, this.$comparator);
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.recordSort(e, state);
                ThreadListSynchronizer.access$updateModel(this.this$0, this.$comparator, state);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            /*
             * WARNING - void declaration
             */
            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                if (this.$comparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                    boolean bl;
                    Presentation presentation;
                    block4: {
                        void $this$any$iv;
                        Iterable iterable = this.$allComparators;
                        ThreadListComparatorSelector threadListComparatorSelector = ThreadListSynchronizer.access$getSelector$p(this.this$0);
                        presentation = e.getPresentation();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                ThreadListComparator p0 = (ThreadListComparator)element$iv;
                                boolean bl2 = false;
                                if (!threadListComparatorSelector.isSelected(p0)) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    boolean bl3 = bl;
                    presentation.setEnabled(bl3);
                }
            }

            private final void recordSort(AnActionEvent e, boolean state) {
                ProfilerUsageTriggerCollector.INSTANCE.logSnapshotInteraction(this.$comparator.getActionDescriptor(), e, state);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final ThreadListSortActions sortActions_delegate$lambda$2(ThreadListSynchronizer this$0) {
        void $this$mapTo$iv$iv;
        Object object = this$0.selector;
        if (object == null || (object = ((ThreadListComparatorSelector)object).getAllComparators()) == null) {
            return new ThreadListSortActions(CollectionsKt.emptyList(), null, 2, null);
        }
        Object allComparators = object;
        Iterable $this$map$iv = (Iterable)allComparators;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreadListComparator threadListComparator = (ThreadListComparator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThreadListSynchronizer.sortActions_delegate$lambda$2$createSortAction(this$0, (List<? extends ThreadListComparator>)allComparators, (ThreadListComparator)it));
        }
        ToggleAction toggleAction = ThreadListSynchronizer.sortActions_delegate$lambda$2$createSortAction(this$0, (List<? extends ThreadListComparator>)allComparators, new ThreadListComparator.KeepingSimilarThreadsClose((Collection<UIVisibleThreadInfo>)this$0.uiThreads, (ThreadListComparator)CollectionsKt.first((List)allComparators)));
        List list = (List)destination$iv$iv;
        return new ThreadListSortActions(list, toggleAction);
    }

    private static final void selectionModel$lambda$4$lambda$3(DefaultListSelectionModel $this_apply, ThreadListSynchronizer this$0, ListSelectionEvent event) {
        int index;
        block4: {
            block3: {
                index = $this_apply.getMinSelectionIndex();
                if (event.getValueIsAdjusting()) break block3;
                if (0 <= index ? index < this$0.listModel.getSize() : false) break block4;
            }
            return;
        }
        this$0.onThreadSelected.invoke((Object)((UIVisibleThreadInfo)this$0.listModel.get(index)).getThreadInfo());
    }

    private static final Unit updateModel$lambda$5(ThreadListSynchronizer this$0, ThreadList $this$forEachWithPreservedSelection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forEachWithPreservedSelection), (String)"$this$forEachWithPreservedSelection");
        $this$forEachWithPreservedSelection.getList().setModel((ListModel)this$0.listModel);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isCurrentComparator(ThreadListSynchronizer $this, ThreadListComparator comparator) {
        return $this.isCurrentComparator(comparator);
    }

    public static final /* synthetic */ void access$updateModel(ThreadListSynchronizer $this, ThreadListComparator newComparator, boolean state) {
        $this.updateModel(newComparator, state);
    }

    public static final /* synthetic */ ThreadListComparatorSelector access$getSelector$p(ThreadListSynchronizer $this) {
        return $this.selector;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0016\b\u0004\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u0082\u0001\u0003\u001e\u001f \u00a8\u0006!"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "", "name", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "actionDescriptor", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "getActionDescriptor", "()Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "baseComparator", "getBaseComparator", "equals", "", "other", "hashCode", "", "Default", "ByPrimaryMetric", "KeepingSimilarThreadsClose", "Companion", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose;", "intellij.profiler.common"})
    private static abstract class ThreadListComparator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Comparator<UIVisibleThreadInfo> baseComparator;

        private ThreadListComparator(String name) {
            this.name = name;
            Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> ThreadListComparator.baseComparator$lambda$1(ThreadListComparator::baseComparator$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingInt(...)");
            this.baseComparator = comparator;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public abstract Comparator<UIVisibleThreadInfo> getComparator();

        @NotNull
        public abstract ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor getActionDescriptor();

        @NotNull
        protected final Comparator<UIVisibleThreadInfo> getBaseComparator() {
            return this.baseComparator;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.threadview.ThreadListSynchronizer.ThreadListComparator");
            ThreadListComparator cfr_ignored_0 = (ThreadListComparator)other;
            return Intrinsics.areEqual((Object)this.name, (Object)((ThreadListComparator)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private static final int baseComparator$lambda$0(UIVisibleThreadInfo it) {
            ThreadInfo threadInfo = it.getThreadInfo();
            return threadInfo instanceof AllThreadsMerged ? 0 : (threadInfo instanceof JVMThread ? 1 : (threadInfo instanceof NativeThread ? 2 : 3));
        }

        private static final int baseComparator$lambda$1(Function1 $tmp0, Object p0) {
            return ((Number)$tmp0.invoke(p0)).intValue();
        }

        public /* synthetic */ ThreadListComparator(String name, DefaultConstructorMarker $constructor_marker) {
            this(name);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "primaryMetric", "Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "<init>", "(Lcom/intellij/profiler/ui/threadview/ThreadMetric;)V", "getPrimaryMetric", "()Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "actionDescriptor", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "getActionDescriptor", "()Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "intellij.profiler.common"})
        public static final class ByPrimaryMetric
        extends ThreadListComparator {
            @NotNull
            private final ThreadMetric<?> primaryMetric;
            @NotNull
            private final ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor actionDescriptor;
            @NotNull
            private final Comparator<UIVisibleThreadInfo> comparator;

            public ByPrimaryMetric(@NotNull ThreadMetric<?> primaryMetric) {
                Intrinsics.checkNotNullParameter(primaryMetric, (String)"primaryMetric");
                Object[] objectArray = new Object[]{primaryMetric.getName()};
                super(CommonProfilerBundleKt.profilerMessage("ui.threadlist.sort.action.message", objectArray), null);
                this.primaryMetric = primaryMetric;
                this.actionDescriptor = ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.THREAD_LIST_SORT_BY_METRIC;
                Function1 function1 = ByPrimaryMetric::comparator$lambda$0;
                Comparator<UIVisibleThreadInfo> comparator = this.getBaseComparator().thenComparing(Comparator.comparing(new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                }));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
                this.comparator = comparator;
            }

            @NotNull
            public final ThreadMetric<?> getPrimaryMetric() {
                return this.primaryMetric;
            }

            @Override
            @NotNull
            public ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor getActionDescriptor() {
                return this.actionDescriptor;
            }

            @Override
            @NotNull
            public Comparator<UIVisibleThreadInfo> getComparator() {
                return this.comparator;
            }

            private static final ThreadMetricValue comparator$lambda$0(UIVisibleThreadInfo t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return t.getPrimaryMetricValue();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001c\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Companion;", "", "<init>", "()V", "buildSelector", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector;", "threads", "", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "getCommonPrimaryMetric", "Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "intellij.profiler.common"})
        @SourceDebugExtension(value={"SMAP\nThreadListSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1563#2:328\n1634#2,3:329\n774#2:332\n865#2,2:333\n*S KotlinDebug\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Companion\n*L\n221#1:328\n221#1:329,3\n221#1:332\n221#1:333,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ThreadListComparatorSelector buildSelector(@NotNull Collection<UIVisibleThreadInfo> threads) {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                ThreadMetric<?> threadMetric = this.getCommonPrimaryMetric(threads);
                if (threadMetric == null) {
                    return null;
                }
                ThreadMetric<?> primaryMetric = threadMetric;
                ByPrimaryMetric byPrimaryMetric = new ByPrimaryMetric(primaryMetric);
                return new ThreadListComparatorSelector(threads, Default.INSTANCE, byPrimaryMetric);
            }

            /*
             * WARNING - void declaration
             */
            private final ThreadMetric<?> getCommonPrimaryMetric(Collection<UIVisibleThreadInfo> threads) {
                void $this$filterTo$iv$iv;
                ThreadMetric it;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = threads;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    UIVisibleThreadInfo uIVisibleThreadInfo = (UIVisibleThreadInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((UIVisibleThreadInfo)((Object)it)).getPrimaryMetricValue().getMetric());
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ThreadMetric)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)NoMetric.INSTANCE))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (ThreadMetric)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "<init>", "()V", "actionDescriptor", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "getActionDescriptor", "()Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "intellij.profiler.common"})
        public static final class Default
        extends ThreadListComparator {
            @NotNull
            public static final Default INSTANCE = new Default();
            @NotNull
            private static final ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor actionDescriptor = ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.THREAD_LIST_SORT_BY_NAME;
            @NotNull
            private static final Comparator<UIVisibleThreadInfo> comparator;

            private Default() {
                super(CommonProfilerBundleKt.profilerMessage("ui.threadlist.sort.by.name.action.message", new Object[0]), null);
            }

            @Override
            @NotNull
            public ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor getActionDescriptor() {
                return actionDescriptor;
            }

            @Override
            @NotNull
            public Comparator<UIVisibleThreadInfo> getComparator() {
                return comparator;
            }

            private static final Boolean comparator$lambda$0(UIVisibleThreadInfo t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return ((CharSequence)t.getThreadInfo().getName()).length() == 0;
            }

            private static final Boolean comparator$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final String comparator$lambda$2(UIVisibleThreadInfo t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return t.getThreadInfo().getName();
            }

            private static final String comparator$lambda$3(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }

            private static final String comparator$lambda$4(UIVisibleThreadInfo t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return t.getThreadInfo().getNativeId();
            }

            private static final String comparator$lambda$5(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }

            static {
                Comparator<Object> comparator = INSTANCE.getBaseComparator().thenComparing(Comparator.comparing(arg_0 -> Default.comparator$lambda$1(Default::comparator$lambda$0, arg_0))).thenComparing(Comparator.comparing(arg_0 -> Default.comparator$lambda$3(Default::comparator$lambda$2, arg_0))).thenComparing(Comparator.comparing(arg_0 -> Default.comparator$lambda$5(Default::comparator$lambda$4, arg_0)));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
                Default.comparator = comparator;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "threads", "", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "innerComparator", "<init>", "(Ljava/util/Collection;Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;)V", "actionDescriptor", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "getActionDescriptor", "()Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$SnapshotActionFusDescriptor;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "comparator$delegate", "Lkotlin/Lazy;", "wrappedComparator", "threadsOrder", "", "", "getThreadsOrder", "()Ljava/util/Map;", "threadsOrder$delegate", "onlyLetters", "", "threadName", "intellij.profiler.common"})
        @SourceDebugExtension(value={"SMAP\nThreadListSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,327:1\n434#2:328\n507#2,5:329\n1491#3:334\n1516#3,3:335\n1519#3,3:345\n1208#3,2:348\n1236#3,2:350\n1239#3:353\n1573#3:360\n1604#3,4:361\n382#4,7:338\n1#5:352\n77#6:354\n97#6,5:355\n*S KotlinDebug\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose\n*L\n210#1:328\n210#1:329,5\n199#1:334\n199#1:335,3\n199#1:345,3\n203#1:348,2\n203#1:350,2\n203#1:353\n207#1:360\n207#1:361,4\n199#1:338,7\n207#1:354\n207#1:355,5\n*E\n"})
        public static final class KeepingSimilarThreadsClose
        extends ThreadListComparator {
            @NotNull
            private final Collection<UIVisibleThreadInfo> threads;
            @NotNull
            private final ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor actionDescriptor;
            @NotNull
            private final Lazy comparator$delegate;
            @NotNull
            private final Comparator<UIVisibleThreadInfo> wrappedComparator;
            @NotNull
            private final Lazy threadsOrder$delegate;

            public KeepingSimilarThreadsClose(@NotNull Collection<UIVisibleThreadInfo> threads, @NotNull ThreadListComparator innerComparator) {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                Intrinsics.checkNotNullParameter((Object)innerComparator, (String)"innerComparator");
                super(CommonProfilerBundleKt.profilerMessage("ui.threadlist.keep.similar.threads.close.action.message", new Object[0]), null);
                this.threads = threads;
                this.actionDescriptor = ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.THREAD_LIST_KEEP_SIMILAR_CLOSE;
                this.comparator$delegate = LazyKt.lazy(() -> KeepingSimilarThreadsClose.comparator_delegate$lambda$2(this));
                this.wrappedComparator = innerComparator.getComparator();
                this.threadsOrder$delegate = LazyKt.lazy(() -> KeepingSimilarThreadsClose.threadsOrder_delegate$lambda$9(this));
            }

            @Override
            @NotNull
            public ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor getActionDescriptor() {
                return this.actionDescriptor;
            }

            @Override
            @NotNull
            public Comparator<UIVisibleThreadInfo> getComparator() {
                Lazy lazy = this.comparator$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (Comparator)object;
            }

            private final Map<UIVisibleThreadInfo, Integer> getThreadsOrder() {
                Lazy lazy = this.threadsOrder$delegate;
                return (Map)lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            private final String onlyLetters(String threadName) {
                void $this$filterTo$iv$iv;
                String $this$filter$iv = threadName;
                boolean $i$f$filter = false;
                CharSequence charSequence = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char element$iv$iv;
                    char p0 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (!Character.isLetter(p0)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                return ((StringBuilder)destination$iv$iv).toString();
            }

            private static final int comparator_delegate$lambda$2$lambda$0(KeepingSimilarThreadsClose this$0, UIVisibleThreadInfo it) {
                return ((Number)MapsKt.getValue(this$0.getThreadsOrder(), (Object)it)).intValue();
            }

            private static final int comparator_delegate$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                return ((Number)$tmp0.invoke(p0)).intValue();
            }

            private static final Comparator comparator_delegate$lambda$2(KeepingSimilarThreadsClose this$0) {
                return Comparator.comparingInt(arg_0 -> KeepingSimilarThreadsClose.comparator_delegate$lambda$2$lambda$1(arg_0 -> KeepingSimilarThreadsClose.comparator_delegate$lambda$2$lambda$0(this$0, arg_0), arg_0));
            }

            private static final int threadsOrder_delegate$lambda$9$lambda$6(KeepingSimilarThreadsClose this$0, Pair pair, Pair pair2) {
                UIVisibleThreadInfo k1 = (UIVisibleThreadInfo)pair.component1();
                UIVisibleThreadInfo k2 = (UIVisibleThreadInfo)pair2.component1();
                return this$0.wrappedComparator.compare(k1, k2);
            }

            /*
             * WARNING - void declaration
             */
            private static final Map threadsOrder_delegate$lambda$9(KeepingSimilarThreadsClose this$0) {
                void $this$mapIndexedTo$iv$iv;
                Iterable $this$flatMapTo$iv$iv;
                Map topThreadToSimilarThreads;
                Object object;
                void $this$associateByTo$iv$iv;
                Object value$iv$iv$iv;
                Object key$iv$iv;
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)this$0.threads, this$0.wrappedComparator);
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo22 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    UIVisibleThreadInfo it = (UIVisibleThreadInfo)element$iv$iv;
                    boolean bl = false;
                    key$iv$iv = this$0.onlyLetters(it.getThreadInfo().getName());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Collection similarThreads = destination$iv$iv.values();
                Iterable $this$associateBy$iv = similarThreads;
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable $i$f$groupByTo22 = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo22 = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void list;
                    key$iv$iv = (List)element$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    Iterable $i$f$getOrPut = (Iterable)list;
                    value$iv$iv$iv = this$0.wrappedComparator;
                    Iterator iterator2 = $i$f$getOrPut.iterator();
                    if (!iterator2.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    UIVisibleThreadInfo it = (UIVisibleThreadInfo)iterator2.next();
                    boolean bl3 = false;
                    UIVisibleThreadInfo uIVisibleThreadInfo = it;
                    while (iterator2.hasNext()) {
                        UIVisibleThreadInfo it2 = (UIVisibleThreadInfo)iterator2.next();
                        $i$a$-minOfWith-ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose$threadsOrder$2$topThreadToSimilarThreads$1$1 = false;
                        UIVisibleThreadInfo uIVisibleThreadInfo2 = it2;
                        if (value$iv$iv$iv.compare((UIVisibleThreadInfo)uIVisibleThreadInfo, (UIVisibleThreadInfo)uIVisibleThreadInfo2) <= 0) continue;
                        uIVisibleThreadInfo = uIVisibleThreadInfo2;
                    }
                    object.put(uIVisibleThreadInfo, element$iv$iv);
                }
                Map $this$flatMap$iv = topThreadToSimilarThreads = MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)MapsKt.toList((Map)destination$iv$iv2), (arg_0, arg_1) -> KeepingSimilarThreadsClose.threadsOrder_delegate$lambda$9$lambda$6(this$0, arg_0, arg_1)));
                boolean $i$f$flatMap = false;
                Map capacity$iv22 = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator $i$f$associateByTo22 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while ($i$f$associateByTo22.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = $i$f$associateByTo22.next();
                    boolean bl = false;
                    Iterable list$iv$iv = (Iterable)it.getValue();
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                Iterable $this$mapIndexed$iv = (List)destination$iv$iv3;
                boolean $i$f$mapIndexed = false;
                $this$flatMapTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void i;
                    void thread;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    UIVisibleThreadInfo bl = (UIVisibleThreadInfo)item$iv$iv;
                    int $i$f$getOrPut = n;
                    object = destination$iv$iv3;
                    boolean bl4 = false;
                    object.add(TuplesKt.to((Object)thread, (Object)((int)i)));
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv3));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0015J\b\u0010!\u001a\u00020\u001fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector;", "", "threads", "", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "defaultComparator", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;", "byPrimaryMetricComparator", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;", "<init>", "(Ljava/util/Collection;Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;)V", "persistentPrimaryMetricOrNull", "Lcom/intellij/profiler/ui/threadview/PersistentMetric;", "threadListOptions", "Lcom/intellij/profiler/ThreadListOptions;", "defaultSelected", "", "primaryMetricSelected", "keepingSimilarThreadsCloseSelected", "allComparators", "", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "getAllComparators", "()Ljava/util/List;", "currentComparator", "getCurrentComparator", "()Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "lastComparator", "isSelected", "comparator", "select", "", "deselect", "updatePersistentState", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nThreadListSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadListSynchronizer.kt\ncom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n1#2:328\n*E\n"})
    private static final class ThreadListComparatorSelector {
        @NotNull
        private final Collection<UIVisibleThreadInfo> threads;
        @NotNull
        private final ThreadListComparator.Default defaultComparator;
        @NotNull
        private final ThreadListComparator.ByPrimaryMetric byPrimaryMetricComparator;
        @Nullable
        private final PersistentMetric persistentPrimaryMetricOrNull;
        @NotNull
        private final ThreadListOptions threadListOptions;
        private boolean defaultSelected;
        private boolean primaryMetricSelected;
        private boolean keepingSimilarThreadsCloseSelected;
        @NotNull
        private final List<ThreadListComparator> allComparators;
        @NotNull
        private ThreadListComparator lastComparator;

        /*
         * Unable to fully structure code
         */
        public ThreadListComparatorSelector(@NotNull Collection<UIVisibleThreadInfo> threads, @NotNull ThreadListComparator.Default defaultComparator, @NotNull ThreadListComparator.ByPrimaryMetric byPrimaryMetricComparator) {
            Intrinsics.checkNotNullParameter(threads, (String)"threads");
            Intrinsics.checkNotNullParameter((Object)defaultComparator, (String)"defaultComparator");
            Intrinsics.checkNotNullParameter((Object)byPrimaryMetricComparator, (String)"byPrimaryMetricComparator");
            super();
            this.threads = threads;
            this.defaultComparator = defaultComparator;
            this.byPrimaryMetricComparator = byPrimaryMetricComparator;
            var4_4 = this.byPrimaryMetricComparator.getPrimaryMetric();
            this.persistentPrimaryMetricOrNull = var4_4 instanceof PersistentMetric != false ? (PersistentMetric)var4_4 : null;
            this.threadListOptions = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getThreadListOptions();
            this.defaultSelected = this.threadListOptions.getSortByName();
            v0 = this;
            v1 = this.persistentPrimaryMetricOrNull;
            if (v1 == null) ** GOTO lbl-1000
            var5_5 = v1;
            var7_6 = v0;
            $i$a$-let-ThreadListSynchronizer$ThreadListComparatorSelector$primaryMetricSelected$1 = false;
            v2 = this.threadListOptions.getSortMetrics().computeIfAbsent(metric.getPersistentName(), (Function<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, primaryMetricSelected$lambda$2$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, primaryMetricSelected$lambda$2$lambda$0(com.intellij.profiler.ui.threadview.PersistentMetric java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((PersistentMetric)metric)));
            v0 = var7_6;
            v1 = v2;
            if (v2 != null) {
                v3 = v1.booleanValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = true;
            }
            v0.primaryMetricSelected = v3;
            this.keepingSimilarThreadsCloseSelected = this.threadListOptions.getKeepSimilarThreadsClose();
            var4_4 = new ThreadListComparator[]{this.defaultComparator, this.byPrimaryMetricComparator};
            this.allComparators = CollectionsKt.listOf((Object[])var4_4);
            this.lastComparator = this.getCurrentComparator();
        }

        @NotNull
        public final List<ThreadListComparator> getAllComparators() {
            return this.allComparators;
        }

        @NotNull
        public final ThreadListComparator getCurrentComparator() {
            ThreadListComparator threadListComparator;
            ThreadListComparator threadListComparator2;
            if (this.defaultSelected) {
                threadListComparator2 = this.defaultComparator;
            } else if (this.primaryMetricSelected) {
                threadListComparator2 = this.byPrimaryMetricComparator;
            } else {
                return this.lastComparator;
            }
            ThreadListComparator result2 = threadListComparator2;
            if (this.keepingSimilarThreadsCloseSelected) {
                result2 = new ThreadListComparator.KeepingSimilarThreadsClose(this.threads, result2);
            }
            ThreadListComparator it = threadListComparator = result2;
            boolean bl = false;
            this.lastComparator = it;
            return threadListComparator;
        }

        public final boolean isSelected(@NotNull ThreadListComparator comparator) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)comparator, (String)"comparator");
            ThreadListComparator threadListComparator = comparator;
            if (threadListComparator instanceof ThreadListComparator.Default) {
                bl = this.defaultSelected;
            } else if (threadListComparator instanceof ThreadListComparator.ByPrimaryMetric) {
                bl = this.primaryMetricSelected;
            } else if (threadListComparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                bl = this.keepingSimilarThreadsCloseSelected;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        public final void select(@NotNull ThreadListComparator comparator) {
            Intrinsics.checkNotNullParameter((Object)comparator, (String)"comparator");
            ThreadListComparator threadListComparator = comparator;
            if (threadListComparator instanceof ThreadListComparator.Default) {
                this.defaultSelected = true;
                this.primaryMetricSelected = false;
            } else if (threadListComparator instanceof ThreadListComparator.ByPrimaryMetric) {
                this.defaultSelected = false;
                this.primaryMetricSelected = true;
            } else if (threadListComparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                this.keepingSimilarThreadsCloseSelected = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.updatePersistentState();
        }

        public final void deselect(@NotNull ThreadListComparator comparator) {
            Intrinsics.checkNotNullParameter((Object)comparator, (String)"comparator");
            ThreadListComparator threadListComparator = comparator;
            if (threadListComparator instanceof ThreadListComparator.Default) {
                this.defaultSelected = false;
            } else if (threadListComparator instanceof ThreadListComparator.ByPrimaryMetric) {
                this.primaryMetricSelected = false;
            } else if (threadListComparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                this.keepingSimilarThreadsCloseSelected = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.updatePersistentState();
        }

        private final void updatePersistentState() {
            this.threadListOptions.setSortByName(this.defaultSelected);
            PersistentMetric persistentMetric = this.persistentPrimaryMetricOrNull;
            if (persistentMetric != null) {
                PersistentMetric metric = persistentMetric;
                boolean bl = false;
                this.threadListOptions.getSortMetrics().put(metric.getPersistentName(), this.primaryMetricSelected);
            }
            this.threadListOptions.setKeepSimilarThreadsClose(this.keepingSimilarThreadsCloseSelected);
        }

        private static final Boolean primaryMetricSelected$lambda$2$lambda$0(PersistentMetric $metric, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $metric.isVisibleByDefault();
        }

        private static final Boolean primaryMetricSelected$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

