/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 =2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001=B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0002J0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u001e\u0010.\u001a\u0010\u0012\u0004\u0012\u000200\u0012\u0006\u0012\u0004\u0018\u00010\u001f0/2\u0006\u00101\u001a\u000202H\u0002J0\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0016J0\u0010<\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006>"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "isVertical", "", "(Z)V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "widthUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getWidthUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "setWidthUnit", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "heightSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "coordAes", "resolution", "isDiscrete", "updateAestheticsDefaults", "Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "aestheticDefaults", "widthSpan", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCrossBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n*L\n34#1:142\n34#1:143,3\n78#1:146\n78#1:147,3\n*E\n"})
public final class CrossBarGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    private double fattenMidline;
    @NotNull
    private DimensionUnit widthUnit;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = BoxHelper.INSTANCE.legendFactory(false);
    @NotNull
    private static final DimensionUnit DEF_WIDTH_UNIT = DimensionUnit.RESOLUTION;

    public CrossBarGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
        this.fattenMidline = 2.5;
        this.widthUnit = DEF_WIDTH_UNIT;
    }

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    @NotNull
    public final DimensionUnit getWidthUnit() {
        return this.widthUnit;
    }

    public final void setWidthUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.widthUnit = dimensionUnit;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public AestheticsDefaults updateAestheticsDefaults(@NotNull AestheticsDefaults aestheticDefaults) {
        Intrinsics.checkNotNullParameter((Object)aestheticDefaults, (String)"aestheticDefaults");
        return this.isVertical ? aestheticDefaults.with(Aes.Companion.getY(), Double.NaN) : aestheticDefaults.with(Aes.Companion.getX(), Double.NaN);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        BoxHelper.INSTANCE.buildBoxes(root, aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(geomHelper));
        BoxHelper.INSTANCE.buildMidlines(root, aesthetics2, this.afterRotation(Aes.Companion.getX()), this.afterRotation(Aes.Companion.getY()), Aes.Companion.getWIDTH(), this.widthUnit, geomHelper, this.fattenMidline, !this.isVertical);
        Object object = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getY(), Aes.Companion.getYMAX()};
        object = CollectionsKt.listOf((Object[])object);
        FlippableGeomHelper flippableGeomHelper = this.flipHelper;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        FlippableGeomHelper.buildHints$default(flippableGeomHelper, (List)destination$iv$iv, aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(geomHelper), buildIntern.2.INSTANCE, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, 128, null);
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getWIDTH(), resolution, this.widthUnit);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getWIDTH(), resolution, this.widthUnit);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomHelper geomHelper) {
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yMinAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> yMaxAes = this.afterRotation(Aes.Companion.getYMAX());
        Aes<Double> widthAes = Aes.Companion.getWIDTH();
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(xAes, yMinAes, yMaxAes, widthAes, geomHelper, this){
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $yMinAes;
            final /* synthetic */ Aes<Double> $yMaxAes;
            final /* synthetic */ Aes<Double> $widthAes;
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ CrossBarGeom this$0;
            {
                this.$xAes = $xAes;
                this.$yMinAes = $yMinAes;
                this.$yMaxAes = $yMaxAes;
                this.$widthAes = $widthAes;
                this.$geomHelper = $geomHelper;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                DoubleRectangle doubleRectangle2 = CrossBarGeom.access$clientRectByDataPoint$factory(this.$xAes, this.$yMinAes, this.$yMaxAes, this.$widthAes, this.$geomHelper, this.this$0, p);
                if (doubleRectangle2 != null) {
                    DoubleRectangle doubleRectangle3 = doubleRectangle2;
                    GeomHelper geomHelper = this.$geomHelper;
                    CrossBarGeom crossBarGeom = this.this$0;
                    DoubleRectangle rect2 = doubleRectangle3;
                    boolean bl = false;
                    doubleRectangle = geomHelper.toClient(CrossBarGeom.access$afterRotation(crossBarGeom, rect2), p);
                } else {
                    doubleRectangle = null;
                }
                return doubleRectangle;
            }
        };
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(Aes<Double> xAes, Aes<Double> yMinAes, Aes<Double> yMaxAes, Aes<Double> widthAes, GeomHelper $geomHelper, CrossBarGeom this$0, DataPointAesthetics p) {
        Double d = p.finiteOrNull(xAes);
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(yMinAes);
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(yMaxAes);
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        Double d4 = p.finiteOrNull(widthAes);
        if (d4 == null) {
            return null;
        }
        double w = d4;
        double width2 = w * $geomHelper.getUnitResolution(this$0.widthUnit, xAes);
        DoubleVector origin = new DoubleVector(x2 - width2 / (double)2, ymin);
        DoubleVector dimension = new DoubleVector(width2, ymax - ymin);
        return new DoubleRectangle(origin, dimension);
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(Aes xAes, Aes yMinAes, Aes yMaxAes, Aes widthAes, GeomHelper $geomHelper, CrossBarGeom this$0, DataPointAesthetics p) {
        return CrossBarGeom.clientRectByDataPoint$factory(xAes, yMinAes, yMaxAes, widthAes, $geomHelper, this$0, p);
    }

    public static final /* synthetic */ DoubleRectangle access$afterRotation(CrossBarGeom $this, DoubleRectangle rectangle) {
        return $this.afterRotation(rectangle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom$Companion;", "", "()V", "DEF_WIDTH_UNIT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

