/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.svggen.SVGGraphicObjectConverter;
import org.jetbrains.relocated.apache.batik.svggen.SVGLine;
import org.w3c.dom.Element;

public class SVGRectangle
extends SVGGraphicObjectConverter {
    private SVGLine svgLine;

    public SVGRectangle(SVGGeneratorContext generatorContext) {
        super(generatorContext);
        this.svgLine = new SVGLine(generatorContext);
    }

    public Element toSVG(Rectangle2D rect2) {
        return this.toSVG((RectangularShape)rect2);
    }

    public Element toSVG(RoundRectangle2D rect2) {
        Element svgRect = this.toSVG((RectangularShape)rect2);
        if (svgRect != null && svgRect.getTagName() == "rect") {
            svgRect.setAttributeNS(null, "rx", this.doubleString(Math.abs(rect2.getArcWidth() / 2.0)));
            svgRect.setAttributeNS(null, "ry", this.doubleString(Math.abs(rect2.getArcHeight() / 2.0)));
        }
        return svgRect;
    }

    private Element toSVG(RectangularShape rect2) {
        if (rect2.getWidth() > 0.0 && rect2.getHeight() > 0.0) {
            Element svgRect = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "rect");
            svgRect.setAttributeNS(null, "x", this.doubleString(rect2.getX()));
            svgRect.setAttributeNS(null, "y", this.doubleString(rect2.getY()));
            svgRect.setAttributeNS(null, "width", this.doubleString(rect2.getWidth()));
            svgRect.setAttributeNS(null, "height", this.doubleString(rect2.getHeight()));
            return svgRect;
        }
        if (rect2.getWidth() == 0.0 && rect2.getHeight() > 0.0) {
            Line2D.Double line2 = new Line2D.Double(rect2.getX(), rect2.getY(), rect2.getX(), rect2.getY() + rect2.getHeight());
            return this.svgLine.toSVG(line2);
        }
        if (rect2.getWidth() > 0.0 && rect2.getHeight() == 0.0) {
            Line2D.Double line3 = new Line2D.Double(rect2.getX(), rect2.getY(), rect2.getX() + rect2.getWidth(), rect2.getY());
            return this.svgLine.toSVG(line3);
        }
        return null;
    }
}

